/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgis;

import com.github.jasync.sql.db.postgis.ByteGetter;
import com.github.jasync.sql.db.postgis.Geom;
import com.github.jasync.sql.db.postgis.ValueGetter;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J3\u0010\u0015\u001a\u0002H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0018J/\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u001b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u001dJ \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010(\u001a\u00020)2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J(\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/github/jasync/sql/db/postgis/JtsBinaryParser;", "", "()V", "jtsFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "parse", "Lorg/locationtech/jts/geom/Geometry;", "value", "", "", "parseCS", "Lorg/locationtech/jts/geom/CoordinateSequence;", "data", "Lcom/github/jasync/sql/db/postgis/ValueGetter;", "haveZ", "", "haveM", "parseCollection", "Lorg/locationtech/jts/geom/GeometryCollection;", "srid", "", "parseGeometry", "T", "inheritSrid", "(Lcom/github/jasync/sql/db/postgis/ValueGetter;IZ)Lorg/locationtech/jts/geom/Geometry;", "parseGeometryArray", "", "container", "", "(Lcom/github/jasync/sql/db/postgis/ValueGetter;[Lorg/locationtech/jts/geom/Geometry;I)V", "parseLineString", "Lorg/locationtech/jts/geom/LineString;", "parseLinearRing", "Lorg/locationtech/jts/geom/LinearRing;", "parseMultiLineString", "Lorg/locationtech/jts/geom/MultiLineString;", "parseMultiPoint", "Lorg/locationtech/jts/geom/MultiPoint;", "parseMultiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "parsePoint", "Lorg/locationtech/jts/geom/Point;", "parsePolygon", "Lorg/locationtech/jts/geom/Polygon;", "Companion", "jasync-postgis-jts"})
public final class JtsBinaryParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory jtsFactory = new GeometryFactory(new PrecisionModel(), 4326);

    @NotNull
    public final Geometry parse(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteGetter.StringByteGetter bytes = new ByteGetter.StringByteGetter(value);
        return JtsBinaryParser.parseGeometry$default(this, Companion.valueGetterForEndian(bytes), 0, false, 6, null);
    }

    @NotNull
    public final Geometry parse(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteGetter.BinaryByteGetter bytes = new ByteGetter.BinaryByteGetter(value);
        return JtsBinaryParser.parseGeometry$default(this, Companion.valueGetterForEndian(bytes), 0, false, 6, null);
    }

    private final <T extends Geometry> T parseGeometry(ValueGetter data, int srid, boolean inheritSrid) {
        Geometry geometry;
        boolean haveS;
        int sridVar = srid;
        byte endian = data.getByte();
        if (!(endian == data.getEndian())) {
            boolean $i$a$-require-JtsBinaryParser$parseGeometry$22 = false;
            String $i$a$-require-JtsBinaryParser$parseGeometry$22 = "Endian inconsistency!";
            throw new IllegalArgumentException($i$a$-require-JtsBinaryParser$parseGeometry$22.toString());
        }
        int typeword = data.getInt();
        int realtype = typeword & 0x1FFFFFFF;
        boolean haveZ = (typeword & Integer.MIN_VALUE) != 0;
        boolean haveM = (typeword & 0x40000000) != 0;
        boolean bl = haveS = (typeword & 0x20000000) != 0;
        if (haveS) {
            int newsrid = Geom.INSTANCE.parseSRID(data.getInt());
            if (inheritSrid && newsrid != sridVar) {
                throw new IllegalArgumentException("Inconsistent srids in complex geometry: " + sridVar + ", " + newsrid);
            }
            sridVar = newsrid;
        } else if (!inheritSrid) {
            sridVar = 0;
        }
        switch (realtype) {
            case 1: {
                geometry = (Geometry)this.parsePoint(data, haveZ, haveM);
                break;
            }
            case 2: {
                geometry = (Geometry)this.parseLineString(data, haveZ, haveM);
                break;
            }
            case 3: {
                geometry = (Geometry)this.parsePolygon(data, haveZ, haveM, sridVar);
                break;
            }
            case 4: {
                geometry = (Geometry)this.parseMultiPoint(data, sridVar);
                break;
            }
            case 5: {
                geometry = (Geometry)this.parseMultiLineString(data, sridVar);
                break;
            }
            case 6: {
                geometry = (Geometry)this.parseMultiPolygon(data, sridVar);
                break;
            }
            case 7: {
                geometry = (Geometry)this.parseCollection(data, sridVar);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type!");
            }
        }
        Geometry result = geometry;
        result.setSRID(sridVar);
        return (T)result;
    }

    static /* synthetic */ Geometry parseGeometry$default(JtsBinaryParser jtsBinaryParser, ValueGetter valueGetter, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return jtsBinaryParser.parseGeometry(valueGetter, n, bl);
    }

    private final Point parsePoint(ValueGetter data, boolean haveZ, boolean haveM) {
        Point point;
        double X = data.getDouble();
        double Y = data.getDouble();
        Point result = null;
        if (haveZ) {
            double Z = data.getDouble();
            Point point2 = this.jtsFactory.createPoint(new Coordinate(X, Y, Z));
            point = point2;
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"{\n            val Z = da\u2026inate(X, Y, Z))\n        }");
        } else {
            Point point3 = this.jtsFactory.createPoint(new Coordinate(X, Y));
            point = point3;
            Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"{\n            jtsFactory\u2026ordinate(X, Y))\n        }");
        }
        result = point;
        if (haveM) {
            data.getDouble();
        }
        return result;
    }

    private final void parseGeometryArray(ValueGetter data, Geometry[] container, int srid) {
        int i = 0;
        int n = container.length;
        if (i < n) {
            Geometry[] geometryArray = container;
            int n2 = i;
            this.parseGeometry(data, srid, true);
            throw new KotlinNothingValueException();
        }
    }

    private final CoordinateSequence parseCS(ValueGetter data, boolean haveZ, boolean haveM) {
        int count = data.getInt();
        int dims = haveZ ? 3 : 2;
        CoordinateSequence cs = (CoordinateSequence)new PackedCoordinateSequence.Double(count, dims, 0);
        for (int i = 0; i < count; ++i) {
            for (int d = 0; d < dims; ++d) {
                cs.setOrdinate(i, d, data.getDouble());
            }
            if (!haveM) continue;
            data.getDouble();
        }
        return cs;
    }

    private final MultiPoint parseMultiPoint(ValueGetter data, int srid) {
        Point[] points = new Point[data.getInt()];
        this.parseGeometryArray(data, (Geometry[])points, srid);
        MultiPoint multiPoint = this.jtsFactory.createMultiPoint(points);
        Intrinsics.checkNotNullExpressionValue((Object)multiPoint, (String)"jtsFactory.createMultiPoint(points)");
        return multiPoint;
    }

    private final LineString parseLineString(ValueGetter data, boolean haveZ, boolean haveM) {
        LineString lineString = this.jtsFactory.createLineString(this.parseCS(data, haveZ, haveM));
        Intrinsics.checkNotNullExpressionValue((Object)lineString, (String)"jtsFactory.createLineStr\u2026seCS(data, haveZ, haveM))");
        return lineString;
    }

    private final LinearRing parseLinearRing(ValueGetter data, boolean haveZ, boolean haveM) {
        LinearRing linearRing = this.jtsFactory.createLinearRing(this.parseCS(data, haveZ, haveM));
        Intrinsics.checkNotNullExpressionValue((Object)linearRing, (String)"jtsFactory.createLinearR\u2026seCS(data, haveZ, haveM))");
        return linearRing;
    }

    private final Polygon parsePolygon(ValueGetter data, boolean haveZ, boolean haveM, int srid) {
        int holecount = data.getInt() - 1;
        LinearRing[] rings = new LinearRing[holecount];
        LinearRing shell = this.parseLinearRing(data, haveZ, haveM);
        shell.setSRID(srid);
        for (int i = 0; i < holecount; ++i) {
            rings[i] = this.parseLinearRing(data, haveZ, haveM);
            LinearRing linearRing = rings[i];
            Intrinsics.checkNotNull((Object)linearRing);
            linearRing.setSRID(srid);
        }
        Polygon polygon = this.jtsFactory.createPolygon(shell, rings);
        Intrinsics.checkNotNullExpressionValue((Object)polygon, (String)"jtsFactory.createPolygon(shell, rings)");
        return polygon;
    }

    private final MultiLineString parseMultiLineString(ValueGetter data, int srid) {
        int count = data.getInt();
        LineString[] strings = new LineString[count];
        this.parseGeometryArray(data, (Geometry[])strings, srid);
        MultiLineString multiLineString = this.jtsFactory.createMultiLineString(strings);
        Intrinsics.checkNotNullExpressionValue((Object)multiLineString, (String)"jtsFactory.createMultiLineString(strings)");
        return multiLineString;
    }

    private final MultiPolygon parseMultiPolygon(ValueGetter data, int srid) {
        int count = data.getInt();
        Polygon[] polys = new Polygon[count];
        this.parseGeometryArray(data, (Geometry[])polys, srid);
        MultiPolygon multiPolygon = this.jtsFactory.createMultiPolygon(polys);
        Intrinsics.checkNotNullExpressionValue((Object)multiPolygon, (String)"jtsFactory.createMultiPolygon(polys)");
        return multiPolygon;
    }

    private final GeometryCollection parseCollection(ValueGetter data, int srid) {
        int count = data.getInt();
        Geometry[] geoms = new Geometry[count];
        this.parseGeometryArray(data, geoms, srid);
        GeometryCollection geometryCollection = this.jtsFactory.createGeometryCollection(geoms);
        Intrinsics.checkNotNullExpressionValue((Object)geometryCollection, (String)"jtsFactory.createGeometryCollection(geoms)");
        return geometryCollection;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/jasync/sql/db/postgis/JtsBinaryParser$Companion;", "", "()V", "valueGetterForEndian", "Lcom/github/jasync/sql/db/postgis/ValueGetter;", "bytes", "Lcom/github/jasync/sql/db/postgis/ByteGetter;", "jasync-postgis-jts"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ValueGetter valueGetterForEndian(@NotNull ByteGetter bytes) {
            ValueGetter valueGetter;
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            if (bytes.get(0) == 0) {
                valueGetter = new ValueGetter.XDR(bytes);
            } else if (bytes.get(0) == 1) {
                valueGetter = new ValueGetter.NDR(bytes);
            } else {
                throw new IllegalArgumentException("Unknown Endian type:" + bytes.get(0));
            }
            return valueGetter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

