/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgis;

import com.github.jasync.sql.db.postgis.ByteGetter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\b&\u0018\u00002\u00020\u0001:\u0002 !B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0014H$J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0014H$R\u0011\u0010\u0007\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0016\"\u0004\b\u001d\u0010\u001e\u00a8\u0006\""}, d2={"Lcom/github/jasync/sql/db/postgis/ValueGetter;", "", "data", "Lcom/github/jasync/sql/db/postgis/ByteGetter;", "endian", "", "(Lcom/github/jasync/sql/db/postgis/ByteGetter;B)V", "byte", "getByte", "()B", "getData", "()Lcom/github/jasync/sql/db/postgis/ByteGetter;", "setData", "(Lcom/github/jasync/sql/db/postgis/ByteGetter;)V", "double", "", "getDouble", "()D", "getEndian", "int", "", "getInt", "()I", "long", "", "getLong", "()J", "position", "getPosition", "setPosition", "(I)V", "index", "NDR", "XDR", "jasync-postgis-jts"})
public abstract class ValueGetter {
    @NotNull
    private ByteGetter data;
    private int position;
    private final byte endian;

    public ValueGetter(@NotNull ByteGetter data, byte endian) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.endian = endian;
    }

    @NotNull
    public final ByteGetter getData() {
        return this.data;
    }

    public final void setData(@NotNull ByteGetter byteGetter) {
        Intrinsics.checkNotNullParameter((Object)byteGetter, (String)"<set-?>");
        this.data = byteGetter;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) {
        this.position = n;
    }

    public final byte getEndian() {
        return this.endian;
    }

    public final byte getByte() {
        int n = this.position;
        this.position = n + 1;
        return (byte)this.data.get(n);
    }

    public final int getInt() {
        int res = this.getInt(this.position);
        this.position += 4;
        return res;
    }

    public final long getLong() {
        long res = this.getLong(this.position);
        this.position += 8;
        return res;
    }

    protected abstract int getInt(int var1);

    protected abstract long getLong(int var1);

    public final double getDouble() {
        long bitrep = this.getLong();
        return Double.longBitsToDouble(bitrep);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/postgis/ValueGetter$XDR;", "Lcom/github/jasync/sql/db/postgis/ValueGetter;", "data", "Lcom/github/jasync/sql/db/postgis/ByteGetter;", "(Lcom/github/jasync/sql/db/postgis/ByteGetter;)V", "getInt", "", "index", "getLong", "", "Companion", "jasync-postgis-jts"})
    public static final class XDR
    extends ValueGetter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final byte NUMBER = 0;

        public XDR(@NotNull ByteGetter data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(data, (byte)0);
        }

        @Override
        protected int getInt(int index) {
            return (this.getData().get(index) << 24) + (this.getData().get(index + 1) << 16) + (this.getData().get(index + 2) << 8) + this.getData().get(index + 3);
        }

        @Override
        protected long getLong(int index) {
            return ((long)this.getData().get(index) << 56) + ((long)this.getData().get(index + 1) << 48) + ((long)this.getData().get(index + 2) << 40) + ((long)this.getData().get(index + 3) << 32) + ((long)this.getData().get(index + 4) << 24) + ((long)this.getData().get(index + 5) << 16) + ((long)this.getData().get(index + 6) << 8) + ((long)this.getData().get(index + 7) << 0);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/jasync/sql/db/postgis/ValueGetter$XDR$Companion;", "", "()V", "NUMBER", "", "jasync-postgis-jts"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/postgis/ValueGetter$NDR;", "Lcom/github/jasync/sql/db/postgis/ValueGetter;", "data", "Lcom/github/jasync/sql/db/postgis/ByteGetter;", "(Lcom/github/jasync/sql/db/postgis/ByteGetter;)V", "getInt", "", "index", "getLong", "", "Companion", "jasync-postgis-jts"})
    public static final class NDR
    extends ValueGetter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final byte NUMBER = 1;

        public NDR(@NotNull ByteGetter data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(data, (byte)1);
        }

        @Override
        protected int getInt(int index) {
            return (this.getData().get(index + 3) << 24) + (this.getData().get(index + 2) << 16) + (this.getData().get(index + 1) << 8) + this.getData().get(index);
        }

        @Override
        protected long getLong(int index) {
            return ((long)this.getData().get(index + 7) << 56) + ((long)this.getData().get(index + 6) << 48) + ((long)this.getData().get(index + 5) << 40) + ((long)this.getData().get(index + 4) << 32) + ((long)this.getData().get(index + 3) << 24) + ((long)this.getData().get(index + 2) << 16) + ((long)this.getData().get(index + 1) << 8) + ((long)this.getData().get(index) << 0);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/jasync/sql/db/postgis/ValueGetter$NDR$Companion;", "", "()V", "NUMBER", "", "jasync-postgis-jts"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

