/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.validator;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.SwitchEntry;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.UnionType;
import com.github.javaparser.ast.validator.Java6Validator;
import com.github.javaparser.ast.validator.SimpleValidator;
import com.github.javaparser.ast.validator.SingleNodeTypeValidator;
import com.github.javaparser.ast.validator.Validator;

public class Java7Validator
extends Java6Validator {
    final SingleNodeTypeValidator<TryStmt> tryWithLimitedResources = new SingleNodeTypeValidator<TryStmt>(TryStmt.class, (n, reporter) -> {
        if (n.getCatchClauses().isEmpty() && n.getResources().isEmpty() && !n.getFinallyBlock().isPresent()) {
            reporter.report(n, "Try has no finally, no catch, and no resources.", new Object[0]);
        }
        for (Expression resource : n.getResources()) {
            if (resource.isVariableDeclarationExpr()) continue;
            reporter.report(n, "Try with resources only supports variable declarations.", new Object[0]);
        }
    });
    private final SingleNodeTypeValidator<UnionType> multiCatch = new SingleNodeTypeValidator<UnionType>(UnionType.class, (n, reporter) -> {
        if (n.getElements().size() == 1) {
            reporter.report(n, "Union type (multi catch) must have at least two elements.", new Object[0]);
        }
    });
    final Validator intAndEnumAndStringSwitch = new SimpleValidator<SwitchEntry>(SwitchEntry.class, n -> !n.getLabels().stream().allMatch(l -> l.isIntegerLiteralExpr() || l.isNameExpr() || l.isStringLiteralExpr() || l.isCharLiteralExpr()), (n, reporter) -> reporter.report(n.getLabels().getParentNode().get(), "Only 'int's, enums, and strings in switch statements are supported.", new Object[0]));

    public Java7Validator() {
        this.remove(this.genericsWithoutDiamondOperator);
        this.replace(this.tryWithoutResources, this.tryWithLimitedResources);
        this.replace(this.intAndEnumSwitch, this.intAndEnumAndStringSwitch);
        this.remove(this.noBinaryIntegerLiterals);
        this.remove(this.noUnderscoresInIntegerLiterals);
        this.replace(this.noMultiCatch, this.multiCatch);
    }
}

