/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.mybatis.dialect;

import com.github.yt.mybatis.dialect.Dialect;
import com.github.yt.mybatis.dialect.DialectHandler;
import com.github.yt.mybatis.query.QueryLikeType;
import com.github.yt.mybatis.util.EntityUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.ibatis.jdbc.SQL;

public abstract class BaseDialect
implements Dialect {
    protected final String TABLE_ALIAS = "t";
    protected final String POINT = ".";

    @Override
    public String getTableName(Class<?> entityClass) {
        return EntityUtils.getTableName(entityClass);
    }

    @Override
    public String getTableNameWithAlas(Class<?> entityClass) {
        return this.getTableName(entityClass) + " " + this.getTableAlas();
    }

    @Override
    public String getTableAlas() {
        return "t";
    }

    @Override
    public String getColumnName(Field field) {
        return EntityUtils.getFieldColumnName(field);
    }

    @Override
    public String getFieldName(Field field) {
        return field.getName();
    }

    @Override
    public String getColumnNameWithTableAlas(Field field) {
        return this.getTableAlas() + "." + this.getColumnName(field);
    }

    @Override
    public String getLikeParam(String paramName, QueryLikeType likeType) {
        String fieldParam = this.getFieldParam(paramName);
        StringBuilder result = new StringBuilder("CONCAT(");
        if (likeType == QueryLikeType.MIDDLE || likeType == QueryLikeType.RIGHT) {
            result.append("'%', ");
        }
        result.append(fieldParam);
        if (likeType == QueryLikeType.MIDDLE || likeType == QueryLikeType.LEFT) {
            result.append(", '%'");
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public String getInsertSql(Collection<?> entityCollection) {
        Class<?> entityClass = EntityUtils.getEntityClass(entityCollection);
        List<Field> tableFieldList = EntityUtils.getTableFieldList(entityClass);
        HashSet<String> fieldColumnNameSet = new HashSet<String>();
        ArrayList<String> fieldNameList = new ArrayList<String>();
        ArrayList<String> columnNameList = new ArrayList<String>();
        ArrayList valueNamesList = new ArrayList();
        for (Object entity : entityCollection) {
            for (Field field : tableFieldList) {
                if (fieldColumnNameSet.contains(EntityUtils.getFieldColumnName(field)) || EntityUtils.getValue(entity, field) == null) continue;
                fieldColumnNameSet.add(EntityUtils.getFieldColumnName(field));
                fieldNameList.add(field.getName());
                columnNameList.add(DialectHandler.getDialect().getColumnName(field));
            }
        }
        for (int i = 0; i < entityCollection.size(); ++i) {
            ArrayList<String> values = new ArrayList<String>();
            for (String fieldColumnName : fieldNameList) {
                values.add("#{collection[" + i + "]." + fieldColumnName + "}");
            }
            valueNamesList.add(values);
        }
        SQL sql = new SQL();
        sql.INSERT_INTO(this.getTableName(entityClass));
        for (String string : columnNameList) {
            sql.INTO_COLUMNS(new String[]{string});
        }
        for (List list : valueNamesList) {
            for (String value : list) {
                sql.INTO_VALUES(new String[]{value});
            }
            sql.ADD_ROW();
        }
        return sql.toString();
    }

    @Override
    public String limitOffset(String sql, Integer limitFrom, Integer limitSize) {
        if (limitFrom != null && limitSize != null) {
            return sql + " LIMIT " + limitSize + " OFFSET " + limitFrom;
        }
        return sql;
    }

    @Override
    public String getFieldParam(String paramName) {
        return "#{" + paramName + "}";
    }
}

