/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.mybatis.dialect.impl;

import com.github.yt.commons.util.YtStringUtils;
import com.github.yt.mybatis.dialect.BaseDialect;
import com.github.yt.mybatis.dialect.DialectHandler;
import com.github.yt.mybatis.query.QueryLikeType;
import com.github.yt.mybatis.util.EntityUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OracleDialect
extends BaseDialect {
    @Override
    public String getInsertSql(Collection<?> entityCollection) {
        Class<?> entityClass = EntityUtils.getEntityClass(entityCollection);
        List<Field> tableFieldList = EntityUtils.getTableFieldList(entityClass);
        String tableName = this.getTableName(entityClass);
        StringBuilder stringBuffer = new StringBuilder("INSERT ");
        if (entityCollection.size() > 1) {
            stringBuffer.append("All ");
        }
        ArrayList entityList = new ArrayList(entityCollection);
        for (int i = 0; i < entityList.size(); ++i) {
            Object entity = entityList.get(i);
            ArrayList<String> columnNameList = new ArrayList<String>();
            ArrayList<String> valueNameList = new ArrayList<String>();
            for (Field field : tableFieldList) {
                if (EntityUtils.getValue(entity, field) == null) continue;
                columnNameList.add(DialectHandler.getDialect().getColumnName(field));
                valueNameList.add("#{collection[" + i + "]." + field.getName() + "}");
            }
            stringBuffer.append("\n\t INTO ").append(tableName);
            stringBuffer.append(" (").append(YtStringUtils.join(columnNameList, (String)", ")).append(") ");
            stringBuffer.append(" VALUES ");
            stringBuffer.append(" (").append(YtStringUtils.join(valueNameList, (String)", ")).append(") ");
        }
        if (entityCollection.size() > 1) {
            stringBuffer.append("SELECT * FROM dual");
        }
        return stringBuffer.toString();
    }

    @Override
    public String limitOffset(String sql, Integer limitFrom, Integer limitSize) {
        if (limitFrom != null && limitSize != null) {
            return "SELECT * FROM (SELECT t_limit_offset_end_.*, ROWNUM AS t_end_row_no_ FROM (" + sql + ") t_limit_offset_end_ WHERE ROWNUM <= " + (limitFrom + limitSize) + ") t_limit_offset_begin_ WHERE t_limit_offset_begin_.t_end_row_no_ > " + limitFrom;
        }
        return sql;
    }

    @Override
    public String getFieldParam(String paramName) {
        return "#{" + paramName + ", jdbcType=VARCHAR}";
    }

    @Override
    public String getLikeParam(String paramName, QueryLikeType likeType) {
        String fieldParam = this.getFieldParam(paramName);
        StringBuilder result = new StringBuilder();
        if (likeType == QueryLikeType.MIDDLE || likeType == QueryLikeType.RIGHT) {
            result.append("'%'||");
        }
        result.append(fieldParam);
        if (likeType == QueryLikeType.MIDDLE || likeType == QueryLikeType.LEFT) {
            result.append("||'%'");
        }
        return result.toString();
    }
}

