/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.mybatis.generator;

import com.github.yt.commons.util.YtArrayUtils;
import com.github.yt.commons.util.YtStringUtils;
import com.github.yt.mybatis.generator.ColumnData;
import com.github.yt.mybatis.generator.CommonPageParser;
import com.github.yt.mybatis.generator.CreateBean;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.VelocityContext;

public class JavaCodeGenerator {
    private String username;
    private String passWord;
    private String dbInstance;
    private String url;
    private String packageEntity = "entity";
    private String packagePo = "po";
    private String packageDao = "dao";
    private String packageService = "service";
    private String packageController = "controller";
    private static List<String> CLASS_NAME_SUFFIX_LIST = new ArrayList<String>();

    public JavaCodeGenerator setPackagePo(String packagePo) {
        this.packagePo = packagePo;
        return this;
    }

    public JavaCodeGenerator setPackageEntity(String packageEntity) {
        this.packageEntity = packageEntity;
        return this;
    }

    public JavaCodeGenerator setPackageDao(String packageDao) {
        this.packageDao = packageDao;
        return this;
    }

    public JavaCodeGenerator setPackageService(String packageService) {
        this.packageService = packageService;
        return this;
    }

    public JavaCodeGenerator setPackageController(String packageController) {
        this.packageController = packageController;
        return this;
    }

    public JavaCodeGenerator(String username, String passWord, String dbInstance, String url) {
        this.username = username;
        this.passWord = passWord;
        this.dbInstance = dbInstance;
        this.url = url;
    }

    public String getReplaceSuffixClassName(String className) {
        if (className == null || className.length() < 1) {
            return className;
        }
        String suffix = className.substring(className.length() - 1, className.length());
        if (CLASS_NAME_SUFFIX_LIST.contains(suffix)) {
            className = className.substring(0, className.length() - 1);
        }
        return className;
    }

    @Deprecated
    public void create(String tableName, String codeName, String moduleName, String modulePackage, String ... templates) {
        if (YtArrayUtils.isEmpty((Object[])templates)) {
            return;
        }
        TemplateEnum[] templateEnums = new TemplateEnum[templates.length];
        for (int i = 0; i < templates.length; ++i) {
            templateEnums[i] = TemplateEnum.valueOf(templates[i].toUpperCase());
        }
        this.create(tableName, codeName, modulePackage, CodePath.SRC_MAIN, null, templateEnums);
    }

    public void create(String tableName, String modulePackage, TemplateEnum ... templates) {
        this.create(tableName, null, modulePackage, CodePath.SRC_TEST, null, templates);
    }

    public void create(String tableName, String tableDesc, String modulePackage, CodePath codePath, Class<?> baseEntityClass, TemplateEnum ... templates) {
        if (YtStringUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        if (YtStringUtils.isBlank((CharSequence)modulePackage)) {
            return;
        }
        if (codePath == null) {
            return;
        }
        if (YtArrayUtils.isEmpty((Object[])templates)) {
            return;
        }
        CreateBean createBean = new CreateBean();
        createBean.setMysqlInfo(this.url, this.username, this.passWord, this.dbInstance);
        String className = createBean.getTablesNameToClassName(tableName);
        String poClassName = className + "PO";
        String replaceSuffixClassName = this.getReplaceSuffixClassName(className);
        String lowerName = className.substring(0, 1).toLowerCase() + className.substring(1, className.length());
        String replaceSuffixLowerName = replaceSuffixClassName.substring(0, 1).toLowerCase() + replaceSuffixClassName.substring(1, replaceSuffixClassName.length());
        String rootPath = CommonPageParser.getRootPath();
        String resourcePath = File.separator + codePath.path + File.separator + "resources" + File.separator;
        String javaPath = File.separator + codePath.path + File.separator + "java" + File.separator;
        String webappPath = File.separator + codePath.path + File.separator + "webapp" + File.separator + "module" + File.separator;
        String moduleSimplePackage = modulePackage.substring(modulePackage.lastIndexOf(".") + 1, modulePackage.length());
        String entityPath = File.separator + this.packageEntity + File.separator + className + ".java";
        String poPath = File.separator + this.packagePo + File.separator + poClassName + ".java";
        String mapperPath = File.separator + this.packageDao + File.separator + replaceSuffixClassName + "Mapper.java";
        String mapperXmlPath = File.separator + this.packageDao + File.separator + replaceSuffixClassName + "Mapper.xml";
        String servicePath = File.separator + this.packageService + File.separator + replaceSuffixClassName + "Service.java";
        String serviceImplPath = File.separator + this.packageService + File.separator + "impl" + File.separator + replaceSuffixClassName + "ServiceImpl.java";
        String controllerPath = File.separator + this.packageController + File.separator + replaceSuffixClassName + "Controller.java";
        String htmlPath = File.separator + replaceSuffixLowerName + ".html";
        try {
            if (YtStringUtils.isBlank((CharSequence)tableDesc)) {
                tableDesc = createBean.getTableComment(tableName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        VelocityContext context = new VelocityContext();
        context.put("className", (Object)className);
        context.put("poClassName", (Object)poClassName);
        context.put("lowerName", (Object)lowerName);
        context.put("codeName", (Object)tableDesc);
        context.put("tableName", (Object)tableName);
        context.put("modulePackage", (Object)modulePackage);
        context.put("moduleSimplePackage", (Object)moduleSimplePackage);
        context.put("replaceSuffixClassName", (Object)replaceSuffixClassName);
        context.put("replaceSuffixLowerName", (Object)replaceSuffixLowerName);
        context.put("packageEntity", (Object)this.packageEntity);
        context.put("packagePO", (Object)this.packagePo);
        context.put("packageDao", (Object)this.packageDao);
        context.put("packageService", (Object)this.packageService);
        context.put("packageController", (Object)this.packageController);
        if (baseEntityClass != null) {
            context.put("importBaseEntity", (Object)("import " + baseEntityClass.getName() + ";"));
            context.put("extendsBaseEntity", (Object)("extends " + baseEntityClass.getSimpleName() + "<T>"));
        } else {
            context.put("importBaseEntity", (Object)"");
            context.put("extendsBaseEntity", (Object)"");
        }
        List<ColumnData> columnDataList = null;
        try {
            columnDataList = createBean.getColumnDataList(tableName, baseEntityClass);
            String fieldList = createBean.getBeanFieldList(columnDataList);
            context.put("columnDataList", columnDataList);
            context.put("fieldList", (Object)fieldList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        String modulePakPath = modulePackage.replaceAll("\\.", "/");
        block13: for (TemplateEnum templateEnum : templates) {
            switch (templateEnum) {
                case PO: {
                    for (ColumnData columnData : columnDataList) {
                        if (!"enum".equals(columnData.getDataType())) continue;
                        context.put("columnComment", (Object)columnData.getColumnComment());
                        context.put("enumClassName", (Object)columnData.getEnumClassName());
                        String enumPath = File.separator + this.packagePo + File.separator + columnData.getEnumClassName() + ".java";
                        context.put("enumColumnDataList", columnData.getEnumColumnDataList());
                        CommonPageParser.writerPage(context, "Enum.java.vm", rootPath + javaPath + modulePakPath, enumPath);
                    }
                    CommonPageParser.writerPage(context, "PO.java.vm", rootPath + javaPath + modulePakPath, poPath);
                    continue block13;
                }
                case BEAN: {
                    CommonPageParser.writerPage(context, "Bean.java.vm", rootPath + javaPath + modulePakPath, entityPath);
                    continue block13;
                }
                case MAPPER: {
                    CommonPageParser.writerPage(context, "Mapper.java.vm", rootPath + javaPath + modulePakPath, mapperPath);
                    continue block13;
                }
                case MAPPER_XML: {
                    CommonPageParser.writerPage(context, "Mapper.xml.vm", rootPath + resourcePath + modulePakPath, mapperXmlPath);
                    continue block13;
                }
                case SERVICE: {
                    CommonPageParser.writerPage(context, "Service.java.vm", rootPath + javaPath + modulePakPath, servicePath);
                    CommonPageParser.writerPage(context, "ServiceImpl.java.vm", rootPath + javaPath + modulePakPath, serviceImplPath);
                    continue block13;
                }
                case CONTROLLER: {
                    CommonPageParser.writerPage(context, "Controller.java.vm", rootPath + javaPath + modulePakPath, controllerPath);
                    continue block13;
                }
                case HTML: {
                    CommonPageParser.writerPage(context, "Html.html.vm", rootPath + webappPath + YtStringUtils.substringAfterLast((String)modulePackage, (String)"."), htmlPath);
                    continue block13;
                }
            }
        }
    }

    static {
        CLASS_NAME_SUFFIX_LIST.add("T");
        CLASS_NAME_SUFFIX_LIST.add("R");
    }

    public static enum CodePath {
        SRC_MAIN("src" + File.separator + "main"),
        SRC_TEST("src" + File.separator + "test");

        String path;

        private CodePath(String path) {
            this.path = path;
        }
    }

    public static enum TemplateEnum {
        PO,
        BEAN,
        MAPPER,
        MAPPER_XML,
        SERVICE,
        CONTROLLER,
        HTML;

    }
}

