/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.mybatis.query;

import com.github.yt.mybatis.dialect.DialectHandler;
import com.github.yt.mybatis.query.MybatisQuery;
import com.github.yt.mybatis.query.Query;
import com.github.yt.mybatis.util.EntityUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class ParamUtils {
    public static final String QUERY_OBJECT = "_queryObject_";
    public static final String ENTITY_CONDITION_CLASS = "_entityConditionClass_";
    public static final String IN_CONDITION = "_inCondition_";

    public static void setPageInfo(MybatisQuery<?> query) {
        if (query.takePageNo() == null) {
            query.makePageNo(1);
        }
        if (query.takePageSize() == null) {
            query.makePageSize(10);
        }
    }

    public static <T> Map<String, Object> getParamMap(T entityCondition, MybatisQuery<?> query, boolean withAlias) {
        Assert.notNull(entityCondition, (String)"\u5bf9\u8c61\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put(QUERY_OBJECT, query);
        param.put(ENTITY_CONDITION_CLASS, entityCondition.getClass());
        List<Field> fieldList = EntityUtils.getTableFieldList(entityCondition.getClass());
        for (Field field : fieldList) {
            Object value = EntityUtils.getValue(entityCondition, field);
            if (value == null) continue;
            if (query == null) {
                query = new Query();
            }
            String columnName = withAlias ? DialectHandler.getDialect().getColumnNameWithTableAlas(field) : DialectHandler.getDialect().getColumnName(field);
            query.equal(columnName, value);
        }
        if (query != null) {
            query.takeParam().forEach(param::put);
            HashMap inParamMap = new HashMap(16);
            query.takeInParamList().forEach(inCondition -> {
                String column = inCondition.takeParam().replaceAll("\\.", "__");
                for (int i = 0; i < inCondition.takeValues().size(); ++i) {
                    inParamMap.put(column, inCondition.takeValues().toArray());
                }
                param.put(IN_CONDITION, inParamMap);
            });
        }
        return param;
    }
}

