/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.mybatis.query;

import com.github.yt.commons.util.YtStringUtils;
import com.github.yt.mybatis.dialect.DialectHandler;
import com.github.yt.mybatis.query.MybatisQuery;
import com.github.yt.mybatis.query.QueryInCondition;
import com.github.yt.mybatis.query.QueryJoin;
import com.github.yt.mybatis.query.QueryJoinType;
import com.github.yt.mybatis.query.QueryLikeType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Query
implements MybatisQuery<Query> {
    protected Integer pageNo;
    protected Integer pageSize;
    protected boolean updateBaseColumn = true;
    protected final List<String> updateColumnList = new ArrayList<String>();
    protected final List<String> extendSelectColumnList = new ArrayList<String>();
    protected final List<String> excludeSelectColumnList = new ArrayList<String>();
    protected boolean excludeAllSelectColumn = false;
    protected final List<String> whereList = new ArrayList<String>();
    protected final List<QueryInCondition> inParamList = new ArrayList<QueryInCondition>();
    protected final List<String> orderByList = new ArrayList<String>();
    protected String groupBy = "";
    protected Integer limitFrom;
    protected Integer limitSize;
    protected final List<QueryJoin> joinList = new ArrayList<QueryJoin>();
    protected final Map<String, Object> param = new HashMap<String, Object>();

    @Override
    public Query updateBaseColumn(boolean updateBaseColumn) {
        this.updateBaseColumn = updateBaseColumn;
        return this;
    }

    @Override
    public boolean takeUpdateBaseColumn() {
        return this.updateBaseColumn;
    }

    @Override
    public Query addParam(String paramName, Object paramValue) {
        if (paramValue instanceof Collection) {
            this.addInParam(paramName, (Collection)paramValue);
        } else {
            this.param.put(paramName, paramValue);
        }
        return this;
    }

    private void addInParam(String paramName, Collection<?> paramValue) {
        this.inParamList.add(new QueryInCondition(paramName, paramValue));
    }

    @Override
    public Query addExtendSelectColumn(String extendSelectColumn) {
        this.extendSelectColumnList.add(extendSelectColumn);
        return this;
    }

    @Override
    public Query addExcludeSelectColumn(String excludeSelectColumn) {
        this.excludeSelectColumnList.add(excludeSelectColumn);
        return this;
    }

    @Override
    public Query excludeAllSelectColumn() {
        this.excludeAllSelectColumn = true;
        return this;
    }

    @Override
    public Query addUpdate(String updateColumn) {
        this.updateColumnList.add(updateColumn);
        return this;
    }

    @Override
    public Query addWhere(String where) {
        this.whereList.add(where);
        return this;
    }

    @Override
    public Query addOrderBy(String columns) {
        this.orderByList.add(columns);
        return this;
    }

    @Override
    public Query addGroupBy(String columns) {
        this.groupBy = columns;
        return this;
    }

    @Override
    public Query limit(int from, int size) {
        this.limitFrom = from;
        this.limitSize = size;
        return this;
    }

    @Override
    public Query addJoin(QueryJoinType joinType, String tableNameAndOnConditions) {
        this.joinList.add(new QueryJoin(joinType, tableNameAndOnConditions));
        return this;
    }

    @Override
    public Query gt(String columnName, Object value) {
        if (value != null) {
            String randomColumnName = "_gt_" + Query.generateRandomColumn(columnName);
            this.addWhere(columnName + " > " + DialectHandler.getDialect().getFieldParam(randomColumnName));
            this.addParam(randomColumnName, value);
        }
        return this;
    }

    @Override
    public Query ge(String columnName, Object value) {
        if (value != null) {
            String randomColumnName = "_ge_" + Query.generateRandomColumn(columnName);
            this.addWhere(columnName + " >= " + DialectHandler.getDialect().getFieldParam(randomColumnName));
            this.addParam(randomColumnName, value);
        }
        return this;
    }

    @Override
    public Query lt(String columnName, Object value) {
        if (value != null) {
            String randomColumnName = "_lt_" + Query.generateRandomColumn(columnName);
            this.addWhere(columnName + " < " + DialectHandler.getDialect().getFieldParam(randomColumnName));
            this.addParam(randomColumnName, value);
        }
        return this;
    }

    @Override
    public Query le(String columnName, Object value) {
        if (value != null) {
            String randomColumnName = "_le_" + Query.generateRandomColumn(columnName);
            this.addWhere(columnName + " <= " + DialectHandler.getDialect().getFieldParam(randomColumnName));
            this.addParam(randomColumnName, value);
        }
        return this;
    }

    private static String generateRandomColumn(String columnName) {
        return columnName.replace(".", "_") + "_" + UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public Query like(String columnName, String value) {
        return this.like(columnName, value, QueryLikeType.MIDDLE);
    }

    @Override
    public Query like(String columnName, String value, QueryLikeType likeType) {
        if (YtStringUtils.isNotEmpty((CharSequence)value)) {
            String randomColumnName = "_like_" + Query.generateRandomColumn(columnName);
            this.addWhere(columnName + " like " + DialectHandler.getDialect().getLikeParam(randomColumnName, likeType));
            this.addParam(randomColumnName, value);
        }
        return this;
    }

    @Override
    public Query equal(String columnName, Object value) {
        String randomColumnName = "_equal_" + Query.generateRandomColumn(columnName);
        this.addWhere(columnName + " = " + DialectHandler.getDialect().getFieldParam(randomColumnName));
        this.addParam(randomColumnName, value);
        return this;
    }

    @Override
    public Query notEqual(String columnName, Object value) {
        String randomColumnName = "_notEqual_" + Query.generateRandomColumn(columnName);
        this.addWhere(columnName + " != " + DialectHandler.getDialect().getFieldParam(randomColumnName));
        this.addParam(randomColumnName, value);
        return this;
    }

    @Override
    public Query in(String columnName, Object firstValue, Object ... moreValues) {
        String randomColumnName = "_in_" + Query.generateRandomColumn(columnName);
        this.addWhere(columnName + " IN ${" + randomColumnName + "}");
        this.addParam(randomColumnName, this.convertToCollection(firstValue, moreValues));
        return this;
    }

    @Override
    public Query notIn(String columnName, Object firstValue, Object ... moreValues) {
        String randomColumnName = "_notIn_" + Query.generateRandomColumn(columnName);
        this.addWhere(columnName + " NOT IN ${" + randomColumnName + "}");
        this.addParam(randomColumnName, this.convertToCollection(firstValue, moreValues));
        return this;
    }

    @Override
    public Query update(String columnName, Object value) {
        String randomColumnName = "_update_" + Query.generateRandomColumn(columnName);
        this.addUpdate(columnName + " = " + DialectHandler.getDialect().getFieldParam(randomColumnName));
        this.addParam(randomColumnName, value);
        return this;
    }

    private Object convertToCollection(Object firstValue, Object ... moreValues) {
        if (firstValue instanceof Collection) {
            return firstValue;
        }
        if (firstValue.getClass().isArray()) {
            int length = Array.getLength(firstValue);
            Object[] os = new Object[length];
            for (int i = 0; i < os.length; ++i) {
                os[i] = Array.get(firstValue, i);
            }
            return Arrays.asList(os);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(firstValue);
        list.addAll(Arrays.asList(moreValues));
        return list;
    }

    @Override
    public Map<String, Object> takeParam() {
        return this.param;
    }

    @Override
    public List<QueryInCondition> takeInParamList() {
        return this.inParamList;
    }

    @Override
    public List<String> takeUpdateColumnList() {
        return this.updateColumnList;
    }

    @Override
    public List<String> takeExtendSelectColumnList() {
        return this.extendSelectColumnList;
    }

    @Override
    public List<String> takeExcludeSelectColumnList() {
        return this.excludeSelectColumnList;
    }

    @Override
    public boolean takeExcludeAllSelectColumn() {
        return this.excludeAllSelectColumn;
    }

    @Override
    public List<String> takeWhereList() {
        return this.whereList;
    }

    @Override
    public List<String> takeOrderByList() {
        return this.orderByList;
    }

    @Override
    public String takeGroupBy() {
        return this.groupBy;
    }

    @Override
    public List<QueryJoin> takeJoinList() {
        return this.joinList;
    }

    public Query makePageNo(Integer pageNo) {
        this.pageNo = pageNo;
        return this;
    }

    public Query makePageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Integer takePageNo() {
        return this.pageNo;
    }

    public Integer takePageSize() {
        return this.pageSize;
    }

    @Override
    public Integer takeLimitFrom() {
        return this.limitFrom;
    }

    @Override
    public Integer takeLimitSize() {
        return this.limitSize;
    }
}

