/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.mybatis.query;

import com.github.yt.commons.util.YtStringUtils;
import com.github.yt.mybatis.dialect.DialectHandler;
import com.github.yt.mybatis.query.MybatisQuery;
import com.github.yt.mybatis.util.EntityUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.NullArgumentException;
import org.apache.ibatis.jdbc.SQL;

public class SqlUtils {
    public static void select(SQL sql, Class<?> entityClass, MybatisQuery<?> query) {
        List<String> columnList;
        if (query != null) {
            columnList = new ArrayList<String>(query.takeExtendSelectColumnList());
            if (!query.takeExcludeAllSelectColumn()) {
                columnList.addAll(SqlUtils.getEntitySelectColumn(entityClass, query.takeExcludeSelectColumnList()));
            }
        } else {
            columnList = SqlUtils.getEntitySelectColumn(entityClass, null);
        }
        for (String column : columnList) {
            sql.SELECT(column);
        }
    }

    public static void from(SQL sql, Class<?> entityClass) {
        sql.FROM(DialectHandler.getDialect().getTableNameWithAlas(entityClass));
    }

    public static void join(SQL sql, MybatisQuery<?> query) {
        if (query == null) {
            return;
        }
        query.takeJoinList().forEach(queryJoin -> {
            switch (queryJoin.takeJoinType()) {
                case JOIN: {
                    sql.JOIN(queryJoin.takeTableNameAndOnConditions());
                    break;
                }
                case LEFT_JOIN: {
                    sql.LEFT_OUTER_JOIN(queryJoin.takeTableNameAndOnConditions());
                    break;
                }
                case RIGHT_JOIN: {
                    sql.RIGHT_OUTER_JOIN(queryJoin.takeTableNameAndOnConditions());
                    break;
                }
                default: {
                    throw new NullArgumentException("\u8fde\u63a5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        });
    }

    public static void set(SQL sql, MybatisQuery<?> query) {
        if (query.takeUpdateColumnList() != null) {
            for (String set : query.takeUpdateColumnList()) {
                sql.SET(set);
            }
        }
    }

    public static void where(SQL sql, MybatisQuery<?> query) {
        if (query != null && query.takeWhereList() != null && !query.takeWhereList().isEmpty()) {
            for (String where : query.takeWhereList()) {
                sql.WHERE(where);
            }
        }
    }

    public static void groupBy(SQL sql, MybatisQuery<?> query) {
        if (query != null && YtStringUtils.isNotBlank((CharSequence)query.takeGroupBy())) {
            sql.GROUP_BY(query.takeGroupBy());
        }
    }

    public static void orderBy(SQL sql, MybatisQuery<?> query) {
        if (query != null && query.takeOrderByList() != null && !query.takeOrderByList().isEmpty()) {
            for (String orderBy : query.takeOrderByList()) {
                sql.ORDER_BY(orderBy);
            }
        }
    }

    public static String limitOffset(String sql, MybatisQuery<?> query) {
        if (query != null) {
            return DialectHandler.getDialect().limitOffset(sql, query.takeLimitFrom(), query.takeLimitSize());
        }
        return sql;
    }

    private static List<String> getEntitySelectColumn(Class<?> entityClass, List<String> excludeSelectColumnList) {
        HashSet<String> excludeColumnSet = new HashSet<String>();
        if (excludeSelectColumnList != null && excludeSelectColumnList.size() > 0) {
            excludeSelectColumnList.forEach(excludeSelectColumn -> {
                String[] excludeColumns;
                for (String excludeColumn : excludeColumns = excludeSelectColumn.split(",")) {
                    excludeColumnSet.add(excludeColumn.trim());
                }
            });
        }
        return SqlUtils.getSelectColumnList(entityClass, excludeColumnSet);
    }

    private static List<String> getSelectColumnList(Class<?> entityClass, Set<String> excludeColumnSet) {
        ArrayList<String> columnList = new ArrayList<String>();
        List<Field> fieldList = EntityUtils.getTableFieldList(entityClass);
        fieldList.forEach(field -> {
            field.setAccessible(true);
            String fieldColumnName = EntityUtils.getFieldColumnName(field);
            String fieldAliasName = DialectHandler.getDialect().getColumnNameWithTableAlas((Field)field);
            if (!excludeColumnSet.contains(fieldColumnName)) {
                if (!fieldColumnName.equals(field.getName())) {
                    fieldAliasName = fieldAliasName + " as " + DialectHandler.getDialect().getFieldName((Field)field);
                }
                columnList.add(fieldAliasName);
            }
        });
        return columnList;
    }

    public static String replaceInParam(SQL sql, MybatisQuery<?> query) {
        if (query == null) {
            return sql.toString();
        }
        if (query.takeInParamList().size() == 0) {
            return sql.toString();
        }
        HashMap<String, Object> inParamListMap = new HashMap<String, Object>(16);
        query.takeInParamList().forEach(queryInCondition -> {
            String inSql;
            String column = queryInCondition.takeParam().replaceAll("\\.", "__");
            if (queryInCondition.takeValues() == null || queryInCondition.takeValues().isEmpty()) {
                inSql = "(null)";
            } else {
                ArrayList<String> inParamList = new ArrayList<String>();
                for (int i = 0; i < queryInCondition.takeValues().size(); ++i) {
                    inParamList.add(DialectHandler.getDialect().getFieldParam("_inCondition_." + column + "[" + i + "]"));
                }
                inSql = "(" + YtStringUtils.join((Object[])inParamList.toArray(), (String)", ") + ")";
            }
            inParamListMap.put(column, inSql);
        });
        return SqlUtils.format(sql.toString(), inParamListMap);
    }

    public static String format(String template, Map<String, Object> params) {
        StringBuffer sb = new StringBuffer();
        String s = "\\$\\{\\s*\\w+\\s*}";
        Matcher m = Pattern.compile(s).matcher(template);
        while (m.find()) {
            String param = m.group();
            Object value = params.get(param.substring(2, param.length() - 1).trim());
            if (value == null) continue;
            m.appendReplacement(sb, value.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

