/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.mybatis.service;

import com.github.yt.mybatis.YtMybatisExceptionEnum;
import com.github.yt.mybatis.dialect.DialectHandler;
import com.github.yt.mybatis.entity.YtColumnType;
import com.github.yt.mybatis.mapper.BaseMapper;
import com.github.yt.mybatis.query.MybatisQuery;
import com.github.yt.mybatis.query.Page;
import com.github.yt.mybatis.query.PageUtils;
import com.github.yt.mybatis.query.ParamUtils;
import com.github.yt.mybatis.query.Query;
import com.github.yt.mybatis.service.IBaseService;
import com.github.yt.mybatis.util.BaseEntityHandler;
import com.github.yt.mybatis.util.EntityUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Id;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.util.Assert;

public abstract class BaseService<T>
implements IBaseService<T> {
    private static final String ID_MUST_NOT_BE_NULL = "The given id must not be null!";
    private static final String ENTITY_MUST_NOT_BE_NULL = "The given entity must not be null!";
    private Class<T> domainClass;
    private BaseMapper<?> mapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <M extends BaseMapper<T>> M getMapper() {
        if (this.mapper == null) {
            BaseService baseService = this;
            synchronized (baseService) {
                if (this.mapper == null) {
                    Field mapperField = EntityUtils.getField(this.getClass(), "mapper");
                    this.mapper = (BaseMapper)EntityUtils.getValue((Object)this, mapperField);
                    com.github.yt.commons.exception.Assert.notNull(this.mapper, (Enum)YtMybatisExceptionEnum.CODE_85);
                }
            }
        }
        return (M)this.mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<T> getEntityClass() {
        if (this.domainClass == null) {
            BaseService baseService = this;
            synchronized (baseService) {
                if (this.domainClass == null) {
                    Type[] actualTypeArguments = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
                    if (actualTypeArguments.length == 0) {
                        throw new RuntimeException("\u8be5 mapper \u6ca1\u6709\u6cdb\u578b\u53c2\u6570");
                    }
                    this.domainClass = (Class)actualTypeArguments[0];
                }
            }
        }
        return this.domainClass;
    }

    private T newEntityInstance() {
        try {
            return this.getEntityClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int save(T entity) {
        List<T> entityList = Collections.singletonList(entity);
        return this.saveBatch(entityList, false);
    }

    @Override
    public int saveBatch(Collection<T> entityCollection) {
        return this.saveBatch(entityCollection, true);
    }

    private int saveBatch(Collection<T> entityCollection, boolean batch) {
        if (entityCollection == null || entityCollection.size() == 0) {
            return 0;
        }
        this.setEntityId(entityCollection, batch);
        this.setCreatorInfo(entityCollection);
        this.setDeleteFlag(entityCollection);
        return this.getMapper().saveBatch(entityCollection);
    }

    @Override
    public int updateById(T entity, String ... fieldColumnNames) {
        Assert.notNull(entity, (String)ENTITY_MUST_NOT_BE_NULL);
        Assert.notNull((Object)EntityUtils.getIdValue(entity), (String)ID_MUST_NOT_BE_NULL);
        return this.update(entity, true, fieldColumnNames);
    }

    @Override
    public int updateForSelectiveById(T entity, String ... fieldColumnNames) {
        Assert.notNull(entity, (String)ENTITY_MUST_NOT_BE_NULL);
        Assert.notNull((Object)EntityUtils.getIdValue(entity), (String)ID_MUST_NOT_BE_NULL);
        return this.update(entity, false, fieldColumnNames);
    }

    @Override
    public int updateBatchById(Collection<T> entities, String ... fieldColumnNames) {
        throw new UnsupportedOperationException("\u6682\u672a\u5b9e\u73b0");
    }

    @Override
    public int updateBatchForSelectiveById(Collection<T> entities, String ... fieldColumnNames) {
        throw new UnsupportedOperationException("\u6682\u672a\u5b9e\u73b0");
    }

    private int update(T entity, boolean isUpdateNullField, String ... selectedFieldColumnNames) {
        Set<String> selectedFieldColumnNameSet = this.getSelectedFieldColumnNameSet(selectedFieldColumnNames, entity);
        Query query = new Query();
        this.setModifier(entity);
        Field idField = EntityUtils.getIdField(entity.getClass());
        for (Field field : EntityUtils.getTableFieldList(entity.getClass())) {
            field.setAccessible(true);
            if (null != field.getAnnotation(Id.class) || null != field.getAnnotation(Transient.class) || !isUpdateNullField && EntityUtils.getValue(entity, field) == null || selectedFieldColumnNameSet != null && selectedFieldColumnNameSet.size() > 0 && !selectedFieldColumnNameSet.contains(EntityUtils.getFieldColumnName(field))) continue;
            query.update(DialectHandler.getDialect().getColumnName(field), EntityUtils.getValue(entity, field));
        }
        query.equal(DialectHandler.getDialect().getColumnName(idField), EntityUtils.getValue(entity, idField));
        return this.getMapper().update(ParamUtils.getParamMap(this.newEntityInstance(), query, false));
    }

    @Override
    public int update(T entityCondition, MybatisQuery<?> query) {
        this.setUpdateBaseColumn(entityCondition.getClass(), query);
        return this.getMapper().update(ParamUtils.getParamMap(entityCondition, query, false));
    }

    @Override
    public int update(MybatisQuery<?> query) {
        return this.update(this.newEntityInstance(), query);
    }

    @Override
    public int logicDeleteOneById(Serializable id) {
        int num = this.logicDeleteById(id);
        if (num != 1) {
            throw new EmptyResultDataAccessException("\u903b\u8f91\u5220\u9664\u7684\u6570\u636e\u4e0d\u4e3a1\u6761\uff0c\u5220\u9664\u4e86: " + num + "\u6761\u6570\u636e\uff0cid: " + id, 1);
        }
        return num;
    }

    @Override
    public int logicDeleteById(Serializable id) {
        Assert.notNull((Object)id, (String)ID_MUST_NOT_BE_NULL);
        Field idField = EntityUtils.getIdField(this.getEntityClass());
        Query query = new Query();
        query.equal(DialectHandler.getDialect().getColumnName(idField), id);
        int num = this.logicDelete(this.newEntityInstance(), query);
        com.github.yt.commons.exception.Assert.le((Number)num, (Number)1, (Enum)YtMybatisExceptionEnum.CODE_77, (Object[])new Object[0]);
        return num;
    }

    @Override
    public int logicDelete(T entityCondition, MybatisQuery<?> query) {
        this.setUpdateDeleteFlag(entityCondition, query);
        this.setUpdateBaseColumn(entityCondition.getClass(), query);
        return this.getMapper().update(ParamUtils.getParamMap(entityCondition, query, false));
    }

    @Override
    public int logicDelete(MybatisQuery<?> query) {
        return this.logicDelete(this.newEntityInstance(), query);
    }

    @Override
    public int logicDelete(T entityCondition) {
        Assert.notNull(entityCondition, (String)"\u903b\u8f91\u5220\u9664\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        return this.logicDelete(entityCondition, new Query());
    }

    @Override
    public int deleteOneById(Serializable id) {
        int num = this.deleteById(id);
        if (num != 1) {
            throw new EmptyResultDataAccessException("\u903b\u8f91\u5220\u9664\u7684\u6570\u636e\u4e0d\u4e3a1\u6761\uff0c\u5220\u9664\u4e86: " + num + "\u6761\u6570\u636e\uff0cid: " + id, 1);
        }
        return num;
    }

    @Override
    public int deleteById(Serializable id) {
        Assert.notNull((Object)id, (String)ID_MUST_NOT_BE_NULL);
        Field idField = EntityUtils.getIdField(this.getEntityClass());
        Query query = new Query();
        query.equal(DialectHandler.getDialect().getColumnName(idField), id);
        int num = this.delete(this.newEntityInstance(), query);
        com.github.yt.commons.exception.Assert.le((Number)num, (Number)1, (Enum)YtMybatisExceptionEnum.CODE_76, (Object[])new Object[0]);
        return num;
    }

    @Override
    public int delete(T entityCondition) {
        return this.delete(entityCondition, new Query());
    }

    @Override
    public int delete(T entityCondition, MybatisQuery<?> query) {
        return this.getMapper().delete(ParamUtils.getParamMap(entityCondition, query, false));
    }

    @Override
    public int delete(MybatisQuery<?> query) {
        return this.delete(this.newEntityInstance(), query);
    }

    @Override
    public T findById(Serializable id) {
        Assert.notNull((Object)id, (String)ID_MUST_NOT_BE_NULL);
        Field idField = EntityUtils.getIdField(this.getEntityClass());
        Query query = new Query();
        query.equal(DialectHandler.getDialect().getColumnName(idField), id);
        return this.find(this.newEntityInstance(), query);
    }

    @Override
    public T findOneById(@NotNull Serializable id) {
        T entity = this.findById(id);
        if (entity == null) {
            throw new EmptyResultDataAccessException("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\uff0cid: " + id, 1);
        }
        return entity;
    }

    @Override
    public T find(T entityCondition) {
        return this.find(entityCondition, new Query());
    }

    @Override
    public T findOne(T entityCondition) {
        T entity = this.find(entityCondition);
        if (entity == null) {
            throw new EmptyResultDataAccessException("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", 1);
        }
        return entity;
    }

    @Override
    public T findOne(T entityCondition, MybatisQuery<?> query) {
        T entity = this.find(entityCondition, query);
        if (entity == null) {
            throw new EmptyResultDataAccessException("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", 1);
        }
        return entity;
    }

    @Override
    public T findOne(MybatisQuery<?> query) {
        return this.findOne(this.newEntityInstance(), query);
    }

    @Override
    public T find(T entityCondition, MybatisQuery<?> query) {
        if (query.takeLimitFrom() == null) {
            query.limit(0, 2);
        }
        return this.getMapper().find(ParamUtils.getParamMap(entityCondition, query, true));
    }

    @Override
    public T find(MybatisQuery<?> query) {
        return this.find(this.newEntityInstance(), query);
    }

    @Override
    public List<T> findList(T entityCondition) {
        return this.findList(entityCondition, new Query());
    }

    @Override
    public List<T> findList(T entityCondition, MybatisQuery<?> query) {
        return this.getMapper().findList(ParamUtils.getParamMap(entityCondition, query, true));
    }

    @Override
    public List<T> findList(MybatisQuery<?> query) {
        return this.findList(this.newEntityInstance(), query);
    }

    @Override
    public int count(T entityCondition) {
        return this.count(entityCondition, new Query());
    }

    @Override
    public int count(T entityCondition, MybatisQuery<?> query) {
        return this.getMapper().count(ParamUtils.getParamMap(entityCondition, query, true));
    }

    @Override
    public int count(MybatisQuery<?> query) {
        return this.count(this.newEntityInstance(), query);
    }

    @Override
    public Page<T> findPage(T entityCondition, MybatisQuery<?> query) {
        ParamUtils.setPageInfo(query);
        Map<String, Object> paramMap = ParamUtils.getParamMap(entityCondition, query, true);
        query.limit((query.takePageNo() - 1) * query.takePageSize(), query.takePageSize());
        List entityList = this.getMapper().findList(paramMap);
        int count = entityList.size() == 0 ? (query.takePageNo() == 0 ? 0 : this.getMapper().count(paramMap)) : (entityList.size() == query.takePageSize().intValue() ? this.getMapper().count(paramMap) : entityList.size() + (query.takePageNo() - 1) * query.takePageSize());
        return PageUtils.createPage(query.takePageNo(), query.takePageSize(), count, entityList);
    }

    @Override
    public Page<T> findPage(MybatisQuery<?> query) {
        return this.findPage(this.newEntityInstance(), query);
    }

    private static String generateUuidIdValue() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private void setEntityId(Collection<T> entityCollection, boolean batch) {
        Field idField;
        Class<T> entityClass = EntityUtils.getEntityClass(entityCollection);
        try {
            idField = EntityUtils.getIdField(entityClass);
        }
        catch (Exception e) {
            return;
        }
        if (idField.getType() != String.class) {
            return;
        }
        int i = 0;
        String generateIdValue = BaseService.generateUuidIdValue();
        for (T entity : entityCollection) {
            String idValue = (String)EntityUtils.getValue(entity, idField);
            if (idValue != null) continue;
            idValue = batch ? generateIdValue + "_" + i : generateIdValue;
            try {
                idField.set(entity, idValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
    }

    private void setCreatorInfo(Collection<T> entityCollection) {
        Class<T> entityClass = EntityUtils.getEntityClass(entityCollection);
        Field founderIdField = EntityUtils.getYtColumnField(entityClass, YtColumnType.FOUNDER_ID);
        Field founderNameField = EntityUtils.getYtColumnField(entityClass, YtColumnType.FOUNDER_NAME);
        Field createTimeField = EntityUtils.getYtColumnField(entityClass, YtColumnType.CREATE_TIME);
        Object founderId = null;
        String founderName = null;
        Date createTime = null;
        if (founderIdField != null) {
            founderId = BaseEntityHandler.getBaseEntityValue().getFounderId();
        }
        if (founderNameField != null) {
            founderName = BaseEntityHandler.getBaseEntityValue().getFounderName();
        }
        if (createTimeField != null) {
            createTime = new Date();
        }
        for (T entity : entityCollection) {
            Object trueCreateTime;
            Object trueFounderName;
            Object trueFounderId;
            if (founderIdField != null && founderId != null && (trueFounderId = EntityUtils.getValue(entity, founderIdField)) == null) {
                EntityUtils.setValue(entity, founderIdField, founderId);
            }
            if (founderNameField != null && founderName != null && (trueFounderName = EntityUtils.getValue(entity, founderNameField)) == null) {
                EntityUtils.setValue(entity, founderNameField, founderName);
            }
            if (createTimeField == null || (trueCreateTime = EntityUtils.getValue(entity, createTimeField)) != null) continue;
            EntityUtils.setValue(entity, createTimeField, createTime);
        }
    }

    private void setDeleteFlag(Collection<T> entityCollection) {
        Class<T> entityClass = EntityUtils.getEntityClass(entityCollection);
        Field deleteFlagField = EntityUtils.getYtColumnField(entityClass, YtColumnType.DELETE_FLAG);
        for (T entity : entityCollection) {
            Object deleteFlag;
            if (deleteFlagField == null || (deleteFlag = EntityUtils.getValue(entity, deleteFlagField)) != null) continue;
            EntityUtils.setValue(entity, deleteFlagField, false);
        }
    }

    private void setModifier(T entity) {
        Field modifierIdField = EntityUtils.getYtColumnField(entity.getClass(), YtColumnType.MODIFIER_ID);
        Field modifierNameField = EntityUtils.getYtColumnField(entity.getClass(), YtColumnType.MODIFIER_NAME);
        Field modifyTimeField = EntityUtils.getYtColumnField(entity.getClass(), YtColumnType.MODIFY_TIME);
        if (modifierIdField != null) {
            Object modifierId = BaseEntityHandler.getBaseEntityValue().getModifierId();
            Object trueModifierId = EntityUtils.getValue(entity, modifierIdField);
            if (trueModifierId == null) {
                EntityUtils.setValue(entity, modifierIdField, modifierId);
            }
        }
        if (modifierNameField != null) {
            String modifierName = BaseEntityHandler.getBaseEntityValue().getModifierName();
            Object trueModifierName = EntityUtils.getValue(entity, modifierNameField);
            if (trueModifierName == null) {
                EntityUtils.setValue(entity, modifierNameField, modifierName);
            }
        }
        if (modifyTimeField != null) {
            Date modifyTime = new Date();
            Object trueModifyTime = EntityUtils.getValue(entity, modifyTimeField);
            if (trueModifyTime == null) {
                EntityUtils.setValue(entity, modifyTimeField, modifyTime);
            }
        }
    }

    private void setUpdateBaseColumn(Class<?> entityClass, MybatisQuery<?> query) {
        if (query.takeUpdateBaseColumn()) {
            Field modifierIdField = EntityUtils.getYtColumnField(entityClass, YtColumnType.MODIFIER_ID);
            Field modifierNameField = EntityUtils.getYtColumnField(entityClass, YtColumnType.MODIFIER_NAME);
            Field modifyTimeField = EntityUtils.getYtColumnField(entityClass, YtColumnType.MODIFY_TIME);
            if (modifierIdField != null) {
                query.update(DialectHandler.getDialect().getColumnName(modifierIdField), BaseEntityHandler.getBaseEntityValue().getModifierId());
            }
            if (modifierNameField != null) {
                query.update(DialectHandler.getDialect().getColumnName(modifierNameField), BaseEntityHandler.getBaseEntityValue().getModifierName());
            }
            if (modifyTimeField != null) {
                query.update(DialectHandler.getDialect().getColumnName(modifyTimeField), new Date());
            }
        }
    }

    private void setUpdateDeleteFlag(T entityCondition, MybatisQuery<?> query) {
        Field deleteFlagField = EntityUtils.getYtColumnField(entityCondition.getClass(), YtColumnType.DELETE_FLAG);
        Assert.notNull((Object)deleteFlagField, (String)"\u903b\u8f91\u5220\u9664\u5b57\u6bb5\u4e0d\u5b58\u5728");
        String deleteFlagColumn = DialectHandler.getDialect().getColumnName(deleteFlagField);
        query.update(deleteFlagColumn, true);
        query.equal(deleteFlagColumn, false);
    }

    private Set<String> getSelectedFieldColumnNameSet(String[] selectedFieldColumnNames, T entity) {
        HashSet<String> selectedFieldColumnNameSet = null;
        if (selectedFieldColumnNames != null && selectedFieldColumnNames.length > 0) {
            selectedFieldColumnNameSet = new HashSet<String>(Arrays.asList(selectedFieldColumnNames));
            Field modifierIdField = EntityUtils.getYtColumnField(entity.getClass(), YtColumnType.MODIFIER_ID);
            Field modifierNameField = EntityUtils.getYtColumnField(entity.getClass(), YtColumnType.MODIFIER_NAME);
            Field modifyTimeField = EntityUtils.getYtColumnField(entity.getClass(), YtColumnType.MODIFY_TIME);
            if (modifierIdField != null) {
                selectedFieldColumnNameSet.add(EntityUtils.getFieldColumnName(modifierIdField));
            }
            if (modifierNameField != null) {
                selectedFieldColumnNameSet.add(EntityUtils.getFieldColumnName(modifierNameField));
            }
            if (modifyTimeField != null) {
                selectedFieldColumnNameSet.add(EntityUtils.getFieldColumnName(modifyTimeField));
            }
        }
        return selectedFieldColumnNameSet;
    }
}

