/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.mybatis.util;

import com.github.yt.commons.exception.BaseErrorException;
import com.github.yt.commons.util.YtStringUtils;
import com.github.yt.mybatis.YtMybatisExceptionEnum;
import com.github.yt.mybatis.entity.YtBaseEntityColumn;
import com.github.yt.mybatis.entity.YtColumnType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.beans.BeanUtils;

public class EntityUtils {
    public static Object getValue(Object source, Field field) {
        try {
            field.setAccessible(true);
            return field.get(source);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getValue(Object source, String fieldName) {
        try {
            Field field = EntityUtils.getField(source.getClass(), fieldName);
            field.setAccessible(true);
            return field.get(source);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setValue(Object source, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(source, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasField(Class clazz, String fieldName) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return true;
        }
        if (clazz.getSuperclass() == null || clazz.getSuperclass().equals(Object.class)) {
            return false;
        }
        return EntityUtils.hasField(clazz.getSuperclass(), fieldName);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        if (clazz.getSuperclass() == null || clazz.getSuperclass().equals(Object.class)) {
            throw new BaseErrorException((Enum)YtMybatisExceptionEnum.CODE_94, new Object[0]);
        }
        return EntityUtils.getField(clazz.getSuperclass(), fieldName);
    }

    public static List<Field> getTableFieldList(Class<?> entityClass) {
        Field[] fields = entityClass.getDeclaredFields();
        return EntityUtils.getTableFieldList(entityClass.getSuperclass(), new ArrayList<Field>(Arrays.asList(fields)));
    }

    private static List<Field> getTableFieldList(Class<?> entityClass, List<Field> fieldList) {
        if (Object.class.equals(entityClass)) {
            ArrayList<Field> newFieldList = new ArrayList<Field>();
            for (Field field : fieldList) {
                if (null != field.getAnnotation(Transient.class) || Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                newFieldList.add(field);
            }
            return newFieldList;
        }
        Collections.addAll(fieldList, entityClass.getDeclaredFields());
        return EntityUtils.getTableFieldList(entityClass.getSuperclass(), fieldList);
    }

    public static Field getIdField(Class<?> entityClass) {
        for (Class<?> c = entityClass; c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (null == field.getAnnotation(Id.class)) continue;
                return field;
            }
        }
        throw new RuntimeException("id \u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c" + entityClass);
    }

    public static Object getIdValue(Object entity) {
        Field idField = EntityUtils.getIdField(entity.getClass());
        return EntityUtils.getValue(entity, idField);
    }

    public static String getTableName(Class<?> entityClass) {
        Table tableAnnotation = entityClass.getAnnotation(Table.class);
        if (tableAnnotation == null || YtStringUtils.isEmpty((CharSequence)tableAnnotation.name())) {
            return entityClass.getSimpleName();
        }
        return tableAnnotation.name();
    }

    public static String getFieldColumnName(Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column == null || YtStringUtils.isEmpty((CharSequence)column.name())) {
            return field.getName();
        }
        return column.name();
    }

    public static <T> Map<String, T> getIdEntityMap(Collection<T> entityCollection) {
        HashMap<String, T> result;
        if (entityCollection != null && !entityCollection.isEmpty()) {
            result = new HashMap(entityCollection.size());
            for (T entity : entityCollection) {
                Field idField = EntityUtils.getIdField(entity.getClass());
                result.put((String)EntityUtils.getValue(entity, idField), entity);
            }
        } else {
            result = new HashMap<String, T>(0);
        }
        return result;
    }

    public static <T> Map<Object, T> propertyEntityMap(String propertyName, Collection<T> entityCollection) {
        HashMap<Object, T> result;
        if (entityCollection != null && !entityCollection.isEmpty()) {
            result = new HashMap(entityCollection.size());
            for (T entity : entityCollection) {
                Field propertyField = EntityUtils.getField(entity.getClass(), propertyName);
                result.put(EntityUtils.getValue(entity, propertyField), entity);
            }
        } else {
            result = new HashMap<Object, T>(0);
        }
        return result;
    }

    public static <T> Map<Object, Collection<T>> propertyCollectionMap(String propertyName, Collection<T> entityCollection) {
        HashMap<Object, Collection<Object>> result;
        if (entityCollection != null && !entityCollection.isEmpty()) {
            result = new HashMap(entityCollection.size());
            for (T entity : entityCollection) {
                Field propertyField;
                try {
                    propertyField = entity.getClass().getDeclaredField(propertyName);
                }
                catch (NoSuchFieldException e) {
                    throw new BaseErrorException((Enum)YtMybatisExceptionEnum.CODE_94, (Throwable)e, new Object[0]);
                }
                Object propertyValue = EntityUtils.getValue(entity, propertyField);
                if (!result.containsKey(propertyValue)) {
                    result.put(propertyValue, new ArrayList());
                }
                ((Collection)result.get(propertyValue)).add(entity);
            }
        } else {
            result = new HashMap<Object, Collection<T>>(0);
        }
        return result;
    }

    private static <T, R> void setListToEntity(Collection<T> mainCollection, Collection<R> subCollection, Field collectionField, Field mainField, Field relationField) throws IllegalAccessException {
        collectionField.setAccessible(true);
        mainField.setAccessible(true);
        relationField.setAccessible(true);
        for (T main : mainCollection) {
            if (collectionField.get(main) != null) continue;
            if (List.class.isAssignableFrom(collectionField.getType())) {
                collectionField.set(main, new ArrayList());
                continue;
            }
            if (Set.class.isAssignableFrom(collectionField.getType())) {
                collectionField.set(main, new HashSet());
                continue;
            }
            throw new BaseErrorException((Enum)YtMybatisExceptionEnum.CODE_95, new Object[]{collectionField.getName()});
        }
        Map<Object, T> mainMap = EntityUtils.propertyEntityMap(mainField.getName(), mainCollection);
        Map<Object, Collection<R>> relationCollectionMap = EntityUtils.propertyCollectionMap(relationField.getName(), subCollection);
        for (Map.Entry<Object, Collection<R>> entry : relationCollectionMap.entrySet()) {
            T main = mainMap.get(entry.getKey());
            if (main == null) continue;
            Collection collection = (Collection)collectionField.get(main);
            collection.addAll(entry.getValue());
        }
    }

    public static <T, R> void setListToEntity(Collection<T> mainCollection, Collection<R> subCollection, String collectionProperty, String mainProperty, String relationProperty) {
        if (mainCollection == null || mainCollection.isEmpty() || subCollection == null || subCollection.isEmpty()) {
            return;
        }
        try {
            Field collectionField = null;
            Field mainField = null;
            Field relationField = null;
            Iterator<Object> iterator = mainCollection.iterator();
            if (iterator.hasNext()) {
                T main = iterator.next();
                collectionField = EntityUtils.getField(main.getClass(), collectionProperty);
                if (YtStringUtils.isBlank((CharSequence)mainProperty)) {
                    mainField = EntityUtils.getIdField(main.getClass());
                    mainProperty = mainField.getName();
                } else {
                    mainField = EntityUtils.getField(main.getClass(), mainProperty);
                }
            }
            if (YtStringUtils.isBlank((CharSequence)relationProperty)) {
                relationProperty = mainProperty;
            }
            if ((iterator = subCollection.iterator()).hasNext()) {
                Object sub = iterator.next();
                relationField = EntityUtils.getField(sub.getClass(), relationProperty);
            }
            EntityUtils.setListToEntity(mainCollection, subCollection, collectionField, mainField, relationField);
        }
        catch (Exception e) {
            throw new BaseErrorException((Enum)YtMybatisExceptionEnum.CODE_96, (Throwable)e, new Object[0]);
        }
    }

    public static <T, R> void setListToEntity(Collection<T> mainCollection, Collection<R> subCollection, String collectionProperty, String relationProperty) {
        EntityUtils.setListToEntity(mainCollection, subCollection, collectionProperty, null, relationProperty);
    }

    public static <T, R> void setListToEntity(Collection<T> mainCollection, Collection<R> subCollection, String collectionProperty) {
        EntityUtils.setListToEntity(mainCollection, subCollection, collectionProperty, null, null);
    }

    public static <T, R> void setSubEntityToEntity(Collection<T> mainCollection, Collection<R> subCollection, String entityFieldName, String mainFieldName, String subFieldName) {
    }

    public static <T, R> void setValueToEntity(Collection<T> mainCollection, Collection<R> subCollection, String valueFieldName, String mainFieldName, String subFieldName) {
        if (mainCollection == null || mainCollection.isEmpty() || subCollection == null || subCollection.isEmpty()) {
            return;
        }
    }

    public static <S, T> T convertObject(S fromObject, Class<T> toClass, Converter converter) {
        try {
            T resultObject = toClass.newInstance();
            converter.convert(fromObject, resultObject);
            return resultObject;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BaseErrorException((Enum)YtMybatisExceptionEnum.CODE_99, (Throwable)e, new Object[0]);
        }
    }

    public static <S, T> T convertObject(S fromObject, Class<T> toClass) {
        return EntityUtils.convertObject(fromObject, toClass, new Converter(){});
    }

    public static <S, T> List<T> convertList(List<S> fromCollection, Class<T> toClass, Converter converter) {
        ArrayList<T> result = new ArrayList<T>();
        if (fromCollection == null || fromCollection.isEmpty()) {
            return result;
        }
        for (S s : fromCollection) {
            try {
                T resultObject = toClass.newInstance();
                converter.convert(s, resultObject);
                result.add(resultObject);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new BaseErrorException((Enum)YtMybatisExceptionEnum.CODE_99, (Throwable)e, new Object[0]);
            }
        }
        return result;
    }

    public static <S, T> List<T> convertList(List<S> fromCollection, Class<T> toClass) {
        return EntityUtils.convertList(fromCollection, toClass, new Converter(){});
    }

    public static <T> Class<T> getEntityClass(Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            return t.getClass();
        }
        throw new RuntimeException("\u83b7\u53d6\u96c6\u5408\u6cdb\u578b\u6570\u636e\u7c7b\u578b\u5931\u8d25");
    }

    public static <T> Field getYtColumnField(Class<T> entityClass, YtColumnType type) {
        List<Field> tableFieldList = EntityUtils.getTableFieldList(entityClass);
        for (Field tableField : tableFieldList) {
            YtBaseEntityColumn ytBaseEntityColumn = tableField.getAnnotation(YtBaseEntityColumn.class);
            if (null == ytBaseEntityColumn || !type.equals((Object)ytBaseEntityColumn.value())) continue;
            return tableField;
        }
        return null;
    }

    public static interface Converter<S, T> {
        default public void convert(S source, T target) {
            BeanUtils.copyProperties(source, target);
        }
    }
}

