/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.mybatis.util;

import com.github.yt.commons.exception.BaseErrorException;
import com.github.yt.commons.util.YtStringUtils;
import com.github.yt.mybatis.YtMybatisExceptionEnum;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAUtils {
    private static Logger logger = LoggerFactory.getLogger(JPAUtils.class);

    public static List<Field> getAllFields(Class<?> entityClass) {
        Field[] fields = entityClass.getDeclaredFields();
        return JPAUtils.getAllFields(entityClass.getSuperclass(), new ArrayList<Field>(Arrays.asList(fields)));
    }

    private static List<Field> getAllFields(Class<?> entityClass, List<Field> fields) {
        if (Object.class.equals(entityClass)) {
            Iterator<Field> it = fields.iterator();
            while (it.hasNext()) {
                Field next = it.next();
                if ("serialVersionUID".equals(next.getName())) {
                    it.remove();
                    continue;
                }
                if (null == next.getAnnotation(Transient.class)) continue;
                it.remove();
            }
            return fields;
        }
        Collections.addAll(fields, entityClass.getDeclaredFields());
        return JPAUtils.getAllFields(entityClass.getSuperclass(), fields);
    }

    public static Field getIdField(Class<?> entityClass) {
        for (Class<?> c = entityClass; c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (null == field.getAnnotation(Id.class)) continue;
                return field;
            }
        }
        throw new BaseErrorException((Enum)YtMybatisExceptionEnum.CODE_91, new Object[]{entityClass, entityClass.getName()});
    }

    public static Object gtIdValue(Object po) {
        if (null == po) {
            return null;
        }
        return JPAUtils.getValue(po, JPAUtils.getIdField(po.getClass()));
    }

    public static Object getValue(Object po, String fieldName) {
        if (null == po || YtStringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BaseErrorException((Enum)YtMybatisExceptionEnum.CODE_92, new Object[0]);
        }
        try {
            Field field = JPAUtils.getField(po.getClass(), fieldName);
            field.setAccessible(true);
            return field.get(po);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getField(Class clazz, String fieldName) {
        if (clazz == Object.class) {
            throw new BaseErrorException((Enum)YtMybatisExceptionEnum.CODE_93, new Object[]{fieldName});
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return JPAUtils.getField(clazz.getSuperclass(), fieldName);
    }

    public static void setValue(Object source, String fieldName, Object value) {
        if (null == source || YtStringUtils.isEmpty((CharSequence)fieldName)) {
            throw new BaseErrorException((Enum)YtMybatisExceptionEnum.CODE_92, new Object[0]);
        }
        try {
            Field field = JPAUtils.getField(source.getClass(), fieldName);
            field.setAccessible(true);
            field.set(source, value);
        }
        catch (Exception e) {
            throw new BaseErrorException((Enum)YtMybatisExceptionEnum.CODE_99, (Throwable)e, new Object[0]);
        }
    }

    public static Object getValue(Object source, Field field) {
        try {
            field.setAccessible(true);
            return field.get(source);
        }
        catch (Exception e) {
            logger.error("JPAUtils getValue \u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    public static <T> Map<String, Object> getIdPropertyMap(String propertyName, Collection<T> entityCollection) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (entityCollection != null) {
            for (T entity : entityCollection) {
                try {
                    Field idField = JPAUtils.getIdField(entity.getClass());
                    idField.setAccessible(true);
                    Object propertyObj = JPAUtils.getValue(entity, entity.getClass().getDeclaredField(propertyName));
                    result.put((String)idField.get(entity), propertyObj);
                }
                catch (Exception e) {
                    logger.error("JPAUtils getValue \u5f02\u5e38\uff01", (Throwable)e);
                    return null;
                }
            }
        }
        return result;
    }

    public static <T> Map<String, T> getIdEntityMap(Collection<T> entityCollection) {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>();
        if (entityCollection != null) {
            for (T entity : entityCollection) {
                try {
                    Field idField = JPAUtils.getIdField(entity.getClass());
                    result.put((String)JPAUtils.getValue(entity, idField), entity);
                }
                catch (BaseErrorException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static <T> Map<Object, T> propertyEntityMap(String propertyName, Collection<T> entityCollection) {
        LinkedHashMap<Object, T> result = new LinkedHashMap<Object, T>();
        if (entityCollection != null) {
            for (T entity : entityCollection) {
                try {
                    Field propertyField = entity.getClass().getDeclaredField(propertyName);
                    result.put(JPAUtils.getValue(entity, propertyField), entity);
                }
                catch (NoSuchFieldException e) {
                    logger.error("JPAUtils getValue \u5f02\u5e38\uff01", (Throwable)e);
                    return null;
                }
            }
        }
        return result;
    }

    public static String getAnnotationColumnName(Field field) {
        Column columnAnnotation = field.getAnnotation(Column.class);
        if (columnAnnotation == null || YtStringUtils.isEmpty((CharSequence)columnAnnotation.name())) {
            return field.getName();
        }
        return columnAnnotation.name();
    }

    public static String getSearchAnnotationColumnName(Field field) {
        return JPAUtils.getSearchAnnotationColumnName(field, "");
    }

    public static String getSearchAnnotationColumnName(Field field, String aliasName) {
        Column columnAnnotation = field.getAnnotation(Column.class);
        if (columnAnnotation == null || YtStringUtils.isEmpty((CharSequence)columnAnnotation.name())) {
            return aliasName + field.getName();
        }
        return aliasName + columnAnnotation.name() + " as " + field.getName();
    }

    public static String getSelectSql(Class<?> entityClass) {
        return JPAUtils.getSelectSql(entityClass, "");
    }

    public static String getSelectSql(Class<?> entityClass, String aliasName) {
        StringBuilder selectSql = new StringBuilder();
        for (Field field : JPAUtils.getAllFields(entityClass)) {
            field.setAccessible(true);
            String fieldName = JPAUtils.getSearchAnnotationColumnName(field, aliasName);
            if (!YtStringUtils.isNotEmpty((CharSequence)fieldName)) continue;
            selectSql.append(",").append(fieldName);
        }
        if (YtStringUtils.isEmpty((CharSequence)(selectSql = new StringBuilder(selectSql.toString().replaceFirst(",", ""))).toString())) {
            return aliasName + "*";
        }
        return selectSql.toString();
    }
}

