/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application;

import com.github.jbgust.jsrm.application.exception.UnregisteredPropellantException;
import com.github.jbgust.jsrm.application.motor.propellant.PropellantType;
import com.github.jbgust.jsrm.application.motor.propellant.SolidPropellant;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RegisteredPropellant {
    private static Map<Integer, SolidPropellant> registeredPropellant = Stream.of(PropellantType.values()).collect(Collectors.toMap(PropellantType::getId, Function.identity()));

    public static Integer registerPropellant(SolidPropellant solidPropellant) {
        return RegisteredPropellant.findPropellant(solidPropellant).orElseGet(() -> RegisteredPropellant.register(solidPropellant));
    }

    private static Integer register(SolidPropellant solidPropellant) {
        Integer nextId = RegisteredPropellant.getNextId();
        registeredPropellant.put(nextId, solidPropellant);
        return nextId;
    }

    private static Optional<Integer> findPropellant(SolidPropellant solidPropellant) {
        return registeredPropellant.entrySet().stream().filter(entry -> solidPropellant.equals(entry.getValue())).map(Map.Entry::getKey).findFirst();
    }

    public static SolidPropellant getSolidPropellant(int propellantId) {
        SolidPropellant propellant = registeredPropellant.get(propellantId);
        if (propellant == null) {
            throw new UnregisteredPropellantException(propellantId);
        }
        return propellant;
    }

    private static Integer getNextId() {
        return (Integer)registeredPropellant.keySet().stream().max(Integer::compareTo).get() + 1;
    }
}

