/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain;

import com.github.jbgust.jsrm.application.exception.InvalidMotorDesignException;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.application.motor.grain.GrainSurface;
import com.github.jbgust.jsrm.application.motor.grain.core.BurningShape;
import com.github.jbgust.jsrm.application.motor.grain.core.ExtrudedShapeGrain;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class FinocylGrain
extends ExtrudedShapeGrain {
    private final double outerDiameter;
    private final double innerDiameter;
    private final double finWidth;
    private final double finDiameter;
    private final int finCount;
    private final int numberOfSegment;

    public FinocylGrain(double outerDiameter, double innerDiameter, double finWidth, double finDiameter, int finCount, double length, int numberOfSegment, GrainSurface endSurface) {
        this.outerDiameter = outerDiameter;
        this.innerDiameter = innerDiameter;
        this.finWidth = finWidth;
        this.finDiameter = finDiameter;
        this.finCount = finCount;
        this.numberOfSegment = numberOfSegment;
        this.setAftEndInhibited(endSurface);
        this.setForeEndInhibited(endSurface);
        this.setLength(length);
        this.generateGeometry();
    }

    private void generateGeometry() {
        this.xsection = new BurningShape();
        Ellipse2D.Double outside = new Ellipse2D.Double(-this.outerDiameter / 2.0, -this.outerDiameter / 2.0, this.outerDiameter, this.outerDiameter);
        this.xsection.add(outside);
        this.xsection.inhibit(outside);
        this.xsection.subtract(new Ellipse2D.Double(-this.innerDiameter / 2.0, -this.innerDiameter / 2.0, this.innerDiameter, this.innerDiameter));
        for (int i = 0; i < this.finCount; ++i) {
            Rectangle2D.Double fin = new Rectangle2D.Double(-this.finWidth / 2.0, 0.0, this.finWidth, this.finDiameter / 2.0);
            this.xsection.subtract(fin, AffineTransform.getRotateInstance((double)i * (Math.PI * 2 / (double)this.finCount)));
        }
    }

    @Override
    public void checkConfiguration(SolidRocketMotor solidRocketMotor) throws InvalidMotorDesignException {
        if (this.innerDiameter == 0.0) {
            throw new InvalidMotorDesignException("Inner diameter should be > 0");
        }
        if (this.outerDiameter == 0.0) {
            throw new InvalidMotorDesignException("Outer diameter should be > 0");
        }
        if (this.getLength() == 0.0) {
            throw new InvalidMotorDesignException("Grain length should be > 0");
        }
        if (this.numberOfSegment == 0) {
            throw new InvalidMotorDesignException("Number of segment should be > 0");
        }
        if (this.innerDiameter > this.outerDiameter) {
            throw new InvalidMotorDesignException("Inner diameter should be < than outer diameter");
        }
        if (this.getLength() * (double)this.getNumberOfSegments() > solidRocketMotor.getCombustionChamber().getChamberLengthInMillimeter()) {
            throw new InvalidMotorDesignException("Combustion chamber length should be >= than Grain total length");
        }
        if (this.outerDiameter > solidRocketMotor.getCombustionChamber().getChamberInnerDiameterInMillimeter()) {
            throw new InvalidMotorDesignException("Combution chamber diameter should be >= than grain outer diameter");
        }
    }

    @Override
    public int getNumberOfSegments() {
        return this.numberOfSegment;
    }
}

