/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain;

import com.github.jbgust.jsrm.application.exception.InvalidMotorDesignException;
import com.github.jbgust.jsrm.application.motor.CombustionChamber;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.application.motor.grain.GrainConfigutation;
import com.github.jbgust.jsrm.application.motor.grain.GrainSurface;
import com.github.jbgust.jsrm.infra.function.HollowCircleAreaFunction;

public class HollowCylinderGrain
implements GrainConfigutation {
    private final double outerDiameter;
    private final double coreDiameter;
    private final double segmentLength;
    private final int numberOfSegment;
    private final GrainSurface outerSurface;
    private final GrainSurface endsSurface;
    private final GrainSurface coreSurface;

    public HollowCylinderGrain(double outerDiameter, double coreDiameter, double segmentLength, int numberOfSegment, GrainSurface outerSurface, GrainSurface endsSurface, GrainSurface coreSurface) {
        this.outerDiameter = outerDiameter;
        this.coreDiameter = coreDiameter;
        this.segmentLength = segmentLength;
        this.numberOfSegment = numberOfSegment;
        this.outerSurface = outerSurface;
        this.endsSurface = endsSurface;
        this.coreSurface = coreSurface;
    }

    @Override
    public double getGrainEndSurface(double burnProgression) {
        HollowCircleAreaFunction hollowCircleAreaFunction = new HollowCircleAreaFunction();
        return hollowCircleAreaFunction.runFunction(this.getOuterDiameter(burnProgression), this.getCoreDiameter(burnProgression));
    }

    @Override
    public double getGrainVolume(double burnProgression) {
        return this.getGrainEndSurface(burnProgression) * this.getGrainLength(burnProgression);
    }

    @Override
    public double getBurningArea(double burnProgression) {
        return this.getGrainEndBurningSurface(burnProgression) + this.getGrainCoreBurningSurface(burnProgression) + this.getGrainOuterBurningSurface(burnProgression);
    }

    @Override
    public double getXincp(int numberOfPoints) {
        return (this.outerDiameter - this.coreDiameter) / (double)(numberOfPoints - 1) / 2.0 / (double)this.getWebRegressionDivider();
    }

    @Override
    public void checkConfiguration(SolidRocketMotor solidRocketMotor) throws InvalidMotorDesignException {
        CombustionChamber combustionChamber = solidRocketMotor.getCombustionChamber();
        if (this.coreDiameter < solidRocketMotor.getThroatDiameterInMillimeter()) {
            throw new InvalidMotorDesignException("Throat diameter should be <= than grain core diameter");
        }
        if (this.outerDiameter > combustionChamber.getChamberInnerDiameterInMillimeter()) {
            throw new InvalidMotorDesignException("Combution chamber diameter should be >= than grain outer diameter");
        }
        if (this.outerDiameter <= this.coreDiameter) {
            throw new InvalidMotorDesignException("Grain outer diameter should be > than grain core diameter");
        }
        double totalGrainLength = this.segmentLength * (double)this.numberOfSegment;
        if (totalGrainLength > combustionChamber.getChamberLengthInMillimeter()) {
            throw new InvalidMotorDesignException("Combustion chamber length should be >= than Grain total length");
        }
        if (GrainSurface.INHIBITED == this.coreSurface && GrainSurface.INHIBITED == this.outerSurface) {
            throw new InvalidMotorDesignException("The motor should have at least core surface or outer surface exposed.");
        }
    }

    private double getGrainEndBurningSurface(double burnProgression) {
        return (double)this.endsSurface.value() * this.getGrainEndSurface(burnProgression) * (double)this.numberOfSegment * 2.0;
    }

    private double getGrainOuterBurningSurface(double burnProgression) {
        return (double)this.outerSurface.value() * Math.PI * this.getOuterDiameter(burnProgression) * this.getGrainLength(burnProgression);
    }

    private double getGrainCoreBurningSurface(double burnProgression) {
        return (double)this.coreSurface.value() * Math.PI * this.getCoreDiameter(burnProgression) * this.getGrainLength(burnProgression);
    }

    private double getGrainLength(double burnProgression) {
        return (this.segmentLength - this.webRegression(burnProgression) * (double)this.endsSurface.value()) * (double)this.numberOfSegment;
    }

    private double getOuterDiameter(double burnProgression) {
        return this.outerDiameter - this.webRegression(burnProgression) * (double)this.outerSurface.value();
    }

    private double getCoreDiameter(double burnProgression) {
        return this.coreDiameter + this.webRegression(burnProgression) * (double)this.coreSurface.value();
    }

    private double webRegression(double burnProgression) {
        return (this.outerDiameter - this.coreDiameter) * burnProgression / (double)this.getWebRegressionDivider();
    }

    private int getWebRegressionDivider() {
        return this.coreSurface.value() + this.outerSurface.value();
    }
}

