/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain;

import com.github.jbgust.jsrm.application.exception.InvalidMotorDesignException;
import com.github.jbgust.jsrm.application.motor.SolidRocketMotor;
import com.github.jbgust.jsrm.application.motor.grain.GrainSurface;
import com.github.jbgust.jsrm.application.motor.grain.core.BurningShape;
import com.github.jbgust.jsrm.application.motor.grain.core.ExtrudedShapeGrain;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class StarGrain
extends ExtrudedShapeGrain {
    private final double outerDiameter;
    private final double innerDiameter;
    private final double pointDiameter;
    private final int pointCount;
    private final int numberOfSegment;

    public StarGrain(double outerDiameter, double innerDiameter, double pointDiameter, int pointCount, int numberOfSegment, double segmentLength, GrainSurface endSurface) {
        this.outerDiameter = outerDiameter;
        this.innerDiameter = innerDiameter;
        this.pointDiameter = pointDiameter;
        this.pointCount = pointCount;
        this.numberOfSegment = numberOfSegment;
        this.setAftEndInhibited(endSurface);
        this.setForeEndInhibited(endSurface);
        this.setLength(segmentLength);
        this.generateGeometry();
    }

    private void generateGeometry() {
        double odmm = this.outerDiameter;
        double idmm = this.innerDiameter / 2.0;
        double pdmm = this.pointDiameter / 2.0;
        this.xsection = new BurningShape();
        Ellipse2D.Double outside = new Ellipse2D.Double(-odmm / 2.0, -odmm / 2.0, odmm, odmm);
        this.xsection.add(outside);
        this.xsection.inhibit(outside);
        GeneralPath p = new GeneralPath();
        double theta = 0.0;
        double dTheta = Math.PI * 2 / ((double)this.pointCount * 2.0);
        p.moveTo(0.0, idmm);
        for (int i = 0; i < this.pointCount; ++i) {
            p.lineTo(pdmm * Math.sin(theta += dTheta), pdmm * Math.cos(theta));
            p.lineTo(idmm * Math.sin(theta += dTheta), idmm * Math.cos(theta));
        }
        p.closePath();
        this.xsection.subtract(new Area(p));
    }

    @Override
    public int getNumberOfSegments() {
        return this.numberOfSegment;
    }

    @Override
    public void checkConfiguration(SolidRocketMotor solidRocketMotor) throws InvalidMotorDesignException {
        if (this.innerDiameter <= 0.0) {
            throw new InvalidMotorDesignException("Inner diameter should be > 0");
        }
        if (this.outerDiameter <= 0.0) {
            throw new InvalidMotorDesignException("Outer diameter should be > 0");
        }
        if (this.getLength() <= 0.0) {
            throw new InvalidMotorDesignException("Grain length should be > 0");
        }
        if (this.innerDiameter > this.outerDiameter) {
            throw new InvalidMotorDesignException("Inner diameter should be < than outer diameter");
        }
        if (this.innerDiameter > this.pointDiameter) {
            throw new InvalidMotorDesignException("Inner diameter should be < than point diameter");
        }
        if (this.pointDiameter > this.outerDiameter) {
            throw new InvalidMotorDesignException("Point diameter should be < than outer diameter");
        }
        if (this.pointCount <= 0) {
            throw new InvalidMotorDesignException("Point count should be > 0");
        }
        if (this.numberOfSegment <= 0) {
            throw new InvalidMotorDesignException("Number of segment should be > 0");
        }
        if (this.getLength() * (double)this.getNumberOfSegments() > solidRocketMotor.getCombustionChamber().getChamberLengthInMillimeter()) {
            throw new InvalidMotorDesignException("Combustion chamber length should be >= than Grain total length");
        }
        if (this.outerDiameter > solidRocketMotor.getCombustionChamber().getChamberInnerDiameterInMillimeter()) {
            throw new InvalidMotorDesignException("Combution chamber diameter should be >= than grain outer diameter");
        }
    }
}

