/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain.core;

import com.github.jbgust.jsrm.application.motor.grain.GrainConfigutation;
import com.github.jbgust.jsrm.application.motor.grain.core.BurningShape;
import com.github.jbgust.jsrm.application.motor.grain.core.ExtrudedGrain;
import com.github.jbgust.jsrm.application.motor.grain.core.ShapeUtil;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.Map;

public abstract class ExtrudedShapeGrain
extends ExtrudedGrain
implements GrainConfigutation {
    protected BurningShape xsection = new BurningShape();
    private double webThickness = -1.0;
    private Map<Double, Double> areaCache = new HashMap<Double, Double>();

    @Override
    public double getGrainEndSurface(double burnProgression) {
        double regression = burnProgression * this.webThickness();
        return this.getEndsBurningSurfaceArea(regression);
    }

    @Override
    public double getGrainVolume(double burnProgression) {
        return (double)this.getNumberOfSegments() * this.volume(burnProgression * this.webThickness());
    }

    @Override
    public double getBurningArea(double burnProgression) {
        return (double)this.getNumberOfSegments() * this.surfaceArea(burnProgression * this.webThickness());
    }

    @Override
    public double getXincp(int numberOfPoints) {
        return this.webThickness() / (double)numberOfPoints;
    }

    private double surfaceArea(double regression) {
        double zero = 0.0;
        if (regression > this.webThickness()) {
            return zero;
        }
        double rLen = this.regressedLength(regression);
        if (rLen < 0.0) {
            return zero;
        }
        Area burn = this.getCrossSection(regression);
        if (burn.isEmpty()) {
            return zero;
        }
        burn.subtract(this.getCrossSection(regression + 0.001));
        double sides = ShapeUtil.perimeter(burn) / 2.0 * rLen;
        double ends = this.getEndsBurningSurfaceArea(regression) * (double)this.numberOfBurningEnds(regression);
        return sides + ends;
    }

    private double getEndsBurningSurfaceArea(double regression) {
        return this.getCachedArea(regression);
    }

    private double getCachedArea(double regression) {
        return this.areaCache.computeIfAbsent(regression, currentRegression -> ShapeUtil.area(this.getCrossSection(regression)));
    }

    private double volume(double regression) {
        double zero = 0.0;
        double rLen = this.regressedLength(regression);
        if (rLen < 0.0) {
            return zero;
        }
        double xSection = this.getCachedArea(regression);
        return xSection * rLen;
    }

    public double webThickness() {
        double guess;
        if (this.webThickness != -1.0) {
            return this.webThickness;
        }
        Area a = this.getCrossSection(0.0);
        Rectangle r = a.getBounds();
        double max = Math.max(r.getWidth(), r.getHeight());
        double min = 0.0;
        do {
            if ((a = this.getCrossSection(guess = min + (max - min) / 2.0)).isEmpty()) {
                max = guess;
                continue;
            }
            min = guess;
        } while (!(max - min < 0.01));
        this.webThickness = guess;
        int ends = this.numberOfBurningEnds(0.0);
        if (ends != 0 && this.webThickness > this.getLength() / (double)ends) {
            this.webThickness = this.getLength() / (double)ends;
        }
        return this.webThickness;
    }

    private Area getCrossSection(double regression) {
        return this.xsection.getShape(regression);
    }

    public abstract int getNumberOfSegments();
}

