/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.calculation;

import com.github.jbgust.jsrm.calculation.Calculator;
import com.github.jbgust.jsrm.calculation.Formula;
import com.github.jbgust.jsrm.calculation.ResultLineProvider;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class CalculatorBuilder {
    private Formula formula;
    private Map<String, Double> constants = Collections.emptyMap();
    private Map<Formula, Double> initialValues = Collections.emptyMap();
    private Formula[] resultsToSave;
    private Set<ResultLineProvider> resultLineProviders = Collections.emptySet();

    public CalculatorBuilder(Formula formula) {
        this.formula = formula;
        this.resultsToSave = new Formula[]{formula};
    }

    public CalculatorBuilder withConstants(Map<String, Double> constants) {
        this.constants = constants;
        return this;
    }

    public CalculatorBuilder withInitialValues(Map<Formula, Double> initialValues) {
        this.initialValues = initialValues;
        return this;
    }

    public CalculatorBuilder withResultsToSave(Formula ... resultsToSave) {
        this.resultsToSave = resultsToSave;
        return this;
    }

    public CalculatorBuilder withResultLineProviders(ResultLineProvider ... resultLineProviders) {
        this.resultLineProviders = Sets.newHashSet((Object[])resultLineProviders);
        return this;
    }

    public Calculator createCalculator() {
        return new Calculator(this.formula, this.constants, this.initialValues, this.resultLineProviders, this.resultsToSave);
    }
}

