/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra.propellant;

public final class BurnRateData {
    private final double burnRateCoefficient;
    private final double pressureExponent;

    public BurnRateData(double burnRateCoefficient, double pressureExponent) {
        this.burnRateCoefficient = burnRateCoefficient;
        this.pressureExponent = pressureExponent;
    }

    public double getBurnRateCoefficient() {
        return this.burnRateCoefficient;
    }

    public double getPressureExponent() {
        return this.pressureExponent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BurnRateData)) {
            return false;
        }
        BurnRateData other = (BurnRateData)o;
        if (Double.compare(this.getBurnRateCoefficient(), other.getBurnRateCoefficient()) != 0) {
            return false;
        }
        return Double.compare(this.getPressureExponent(), other.getPressureExponent()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $burnRateCoefficient = Double.doubleToLongBits(this.getBurnRateCoefficient());
        result = result * 59 + (int)($burnRateCoefficient >>> 32 ^ $burnRateCoefficient);
        long $pressureExponent = Double.doubleToLongBits(this.getPressureExponent());
        result = result * 59 + (int)($pressureExponent >>> 32 ^ $pressureExponent);
        return result;
    }

    public String toString() {
        return "BurnRateData(burnRateCoefficient=" + this.getBurnRateCoefficient() + ", pressureExponent=" + this.getPressureExponent() + ")";
    }
}

