/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.http;

import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.jchanghong.gson.JsonHelper;
import com.github.jchanghong.gson.JsonsKt;
import com.github.jchanghong.http.HttpHelperKt;
import com.github.jchanghong.http.SetCookieBO;
import com.google.common.net.MediaType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002VWB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u00105\u001a\u000206H\u0002J,\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010:\u001a\u00020\u00052\u0016\b\u0002\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010<J.\u00107\u001a\u00020=2\u0006\u0010:\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?2\u0016\b\u0002\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010<J@\u0010@\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010:\u001a\u00020\u00052\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050<2\u0016\b\u0002\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010<J\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010C\u001a\u00020=2\u0006\u0010D\u001a\u00020\u0001J\u0016\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005J@\u0010H\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010:\u001a\u00020\u00052\u0006\u0010I\u001a\u00020J2\n\b\u0002\u0010K\u001a\u0004\u0018\u00010L2\u0016\b\u0002\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010<J@\u0010M\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010:\u001a\u00020\u00052\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050<2\u0016\b\u0002\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010<JL\u0010N\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010:\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\u00052\u0016\b\u0002\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010<2\u0016\b\u0002\u0010A\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010<J@\u0010P\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010:\u001a\u00020\u00052\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010<2\u0016\b\u0002\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010<J@\u0010Q\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010:\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u00052\n\b\u0002\u0010K\u001a\u0004\u0018\u00010L2\u0016\b\u0002\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010<J.\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010:\u001a\u00020\u00052\b\b\u0002\u0010T\u001a\u00020\u00052\b\b\u0002\u0010U\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010 \"\u0004\b'\u0010\"R\u001a\u0010(\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010 \"\u0004\b*\u0010\"R\u001a\u0010+\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010 \"\u0004\b-\u0010\"R\u001a\u0010.\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010 \"\u0004\b0\u0010\"R\u001a\u00101\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010 \"\u0004\b3\u0010\"R\u000e\u00104\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/github/jchanghong/http/HttpHelper;", "", "()V", "cSRFRequestHeadXbody", "Lkotlin/Pair;", "", "cSRFRequestHeadXcross", "cSRFRequestHeadXface", "cSRFRequestHeadialarm", "client", "Lokhttp3/OkHttpClient;", "cookieStore", "Ljava/util/concurrent/ConcurrentHashMap;", "Lokhttp3/Cookie;", "getCookieStore", "()Ljava/util/concurrent/ConcurrentHashMap;", "cookieVoList", "Lcn/hutool/core/collection/ConcurrentHashSet;", "Lcom/github/jchanghong/http/SetCookieBO;", "getCookieVoList", "()Lcn/hutool/core/collection/ConcurrentHashSet;", "csrf_headerName", "csrf_parameterName", "csrf_token", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "pviaCenterPassword", "getPviaCenterPassword", "()Ljava/lang/String;", "setPviaCenterPassword", "(Ljava/lang/String;)V", "pviaCenterisLogin", "Ljava/util/concurrent/atomic/AtomicBoolean;", "pviaIpAndPort", "getPviaIpAndPort", "setPviaIpAndPort", "pviaIpAndPortCenter", "getPviaIpAndPortCenter", "setPviaIpAndPortCenter", "pviaLoginUrlPath", "getPviaLoginUrlPath", "setPviaLoginUrlPath", "pviaLoginUrlPathCenter", "getPviaLoginUrlPathCenter", "setPviaLoginUrlPathCenter", "pviaPassword", "getPviaPassword", "setPviaPassword", "pviaisLogin", "createSSLSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getAsyn", "Ljava/util/concurrent/CompletableFuture;", "Lokhttp3/Response;", "url", "headers", "", "", "callback", "Lokhttp3/Callback;", "getAsynWithForm", "form", "ialarmCSRFRequestHead", "info", "i", "login", "user", "password", "postFileAsyn", "file", "Ljava/io/File;", "mediaType", "Lcom/google/common/net/MediaType;", "postFormAsyn", "postJsonStringAsyn", "jsonBody", "postMultipartAsyn", "postStringAsyn", "postBody", "requestCSRFRequestHead", "nameRegex", "valueRegex", "TrustAllCerts", "TrustAllHostnameVerifier", "kotlin-lib-min"})
public final class HttpHelper {
    @NotNull
    public static final HttpHelper INSTANCE;
    private static boolean debug;
    @NotNull
    private static String pviaLoginUrlPath;
    @NotNull
    private static String pviaLoginUrlPathCenter;
    @NotNull
    private static String pviaIpAndPort;
    @NotNull
    private static String pviaIpAndPortCenter;
    @NotNull
    private static String pviaPassword;
    @NotNull
    private static String pviaCenterPassword;
    @NotNull
    private static final OkHttpClient client;
    @NotNull
    private static final AtomicBoolean pviaisLogin;
    @NotNull
    private static final AtomicBoolean pviaCenterisLogin;
    @NotNull
    private static final ConcurrentHashMap<String, ConcurrentHashMap<String, Cookie>> cookieStore;
    @NotNull
    private static final ConcurrentHashSet<SetCookieBO> cookieVoList;
    @NotNull
    private static String csrf_parameterName;
    @NotNull
    private static String csrf_headerName;
    @NotNull
    private static String csrf_token;
    @NotNull
    private static Pair<String, String> cSRFRequestHeadXface;
    @NotNull
    private static Pair<String, String> cSRFRequestHeadXcross;
    @NotNull
    private static Pair<String, String> cSRFRequestHeadXbody;
    @NotNull
    private static Pair<String, String> cSRFRequestHeadialarm;

    private HttpHelper() {
    }

    public final boolean getDebug() {
        return debug;
    }

    public final void setDebug(boolean bl) {
        debug = bl;
    }

    @NotNull
    public final String getPviaLoginUrlPath() {
        return pviaLoginUrlPath;
    }

    public final void setPviaLoginUrlPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        pviaLoginUrlPath = string;
    }

    @NotNull
    public final String getPviaLoginUrlPathCenter() {
        return pviaLoginUrlPathCenter;
    }

    public final void setPviaLoginUrlPathCenter(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        pviaLoginUrlPathCenter = string;
    }

    @NotNull
    public final String getPviaIpAndPort() {
        return pviaIpAndPort;
    }

    public final void setPviaIpAndPort(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        pviaIpAndPort = string;
    }

    @NotNull
    public final String getPviaIpAndPortCenter() {
        return pviaIpAndPortCenter;
    }

    public final void setPviaIpAndPortCenter(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        pviaIpAndPortCenter = string;
    }

    @NotNull
    public final String getPviaPassword() {
        return pviaPassword;
    }

    public final void setPviaPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        pviaPassword = string;
    }

    @NotNull
    public final String getPviaCenterPassword() {
        return pviaCenterPassword;
    }

    public final void setPviaCenterPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        pviaCenterPassword = string;
    }

    public final void info(@NotNull Object i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        if (debug) {
            boolean bl = false;
            System.out.println(i);
        }
    }

    private final SSLSocketFactory createSSLSocketFactory() {
        Object object = SSLContext.getInstance("TLS");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(\"TLS\")");
        TrustManager[] sc = object;
        object = new TrustManager[]{new TrustAllCerts()};
        sc.init(null, (TrustManager[])object, new SecureRandom());
        object = sc.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sc.socketFactory");
        return object;
    }

    @NotNull
    public final ConcurrentHashMap<String, ConcurrentHashMap<String, Cookie>> getCookieStore() {
        return cookieStore;
    }

    @NotNull
    public final ConcurrentHashSet<SetCookieBO> getCookieVoList() {
        return cookieVoList;
    }

    public final boolean login(@NotNull String user, @NotNull String password) {
        boolean bl;
        String url2;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        FormBody formBody = new FormBody.Builder(null, 1, null).add("userName", "admin").build();
        Response response = client.newCall(new Request.Builder().url(Intrinsics.stringPlus((String)pviaIpAndPort, (Object)"/portal/login/ajax/postLoginData.do")).post((RequestBody)formBody).build()).execute();
        String message = HttpHelperKt.bodyString(response);
        this.info(message);
        JSONObject parseObj1 = JSONUtil.parseObj((String)message);
        JSONObject parseObj = parseObj1.getJSONObject((Object)"data");
        String vcodestr = parseObj.getStr((Object)"vCode");
        String salt = parseObj.getStr((Object)"salt");
        String passtmp = SecureUtil.sha256((String)Intrinsics.stringPlus((String)SecureUtil.sha256((String)Intrinsics.stringPlus((String)password, (Object)salt)), (Object)vcodestr));
        FormBody.Builder builder2 = new FormBody.Builder(null, 1, null).add("userName", user);
        Intrinsics.checkNotNullExpressionValue((Object)passtmp, (String)"passtmp");
        FormBody.Builder builder3 = builder2.add("password", passtmp).add("serviceUrl", pviaIpAndPort + "/portal/cas/loginPage?service=" + pviaIpAndPort + "/portal").add("imageCode", "");
        String string = parseObj.getStr((Object)"codeId");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parseObj.getStr(\"codeId\")");
        FormBody formBodyLogin = builder3.add("codeId", string).add("userType", "0").add("lang", "zh_CN").build();
        Response response1 = client.newCall(new Request.Builder().url(Intrinsics.stringPlus((String)pviaIpAndPort, (Object)"/portal/login/ajax/submit.do")).post((RequestBody)formBodyLogin).build()).execute();
        String loginMessage = HttpHelperKt.bodyString(response1);
        this.info(loginMessage);
        String string2 = JSONUtil.parseObj((String)loginMessage).getStr((Object)"data");
        String string3 = url2 = string2 == null ? "" : string2;
        if (StringsKt.contains$default((CharSequence)url2, (CharSequence)"http", (boolean)false, (int)2, null)) {
            Response response2 = client.newCall(new Request.Builder().url(url2).build()).execute();
            response.close();
            response1.close();
            if (response2.code() == 200) {
                String string4 = Intrinsics.stringPlus((String)"\u767b\u9646pvia\u6210\u529f ", (Object)response2);
                boolean bl2 = false;
                System.out.println((Object)string4);
                response2.close();
                bl = true;
            } else {
                response2.close();
                bl = false;
            }
        } else {
            string2 = "\u767b\u9646pvia\u5931\u8d25";
            boolean bl3 = false;
            System.out.println((Object)string2);
            response.close();
            response1.close();
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Pair<String, String> requestCSRFRequestHead(@NotNull String url, @NotNull String nameRegex, @NotNull String valueRegex) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkNotNullParameter((Object)valueRegex, (String)"valueRegex");
        Response response = (Response)HttpHelper.getAsyn$default(this, url, null, 2, null).get();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        String execute4 = HttpHelperKt.bodyString(response);
        String string = "name=\"" + valueRegex + "\"\\s+content=\"(\\S+)\"";
        boolean bl = false;
        Regex toRegex1 = new Regex(string);
        String string2 = "name=\"" + nameRegex + "\"\\s+content=\"(\\S+)\"";
        boolean bl2 = false;
        Regex toRegex2 = new Regex(string2);
        MatchResult matchResult = Regex.find$default((Regex)toRegex1, (CharSequence)execute4, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        String v = (String)matchResult.getGroupValues().get(1);
        MatchResult matchResult2 = Regex.find$default((Regex)toRegex2, (CharSequence)execute4, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult2);
        String k = (String)matchResult2.getGroupValues().get(1);
        this.info("add csrf header :" + k + "  -> " + v);
        response.close();
        return TuplesKt.to((Object)k, (Object)v);
    }

    public static /* synthetic */ Pair requestCSRFRequestHead$default(HttpHelper httpHelper, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "_csrf_header";
        }
        if ((n & 4) != 0) {
            string3 = "_csrf";
        }
        return httpHelper.requestCSRFRequestHead(string, string2, string3);
    }

    @NotNull
    public final Pair<String, String> ialarmCSRFRequestHead() {
        Response response = client.newCall(new Request.Builder().url(Intrinsics.stringPlus((String)pviaIpAndPort, (Object)"/ialarm-web/search.do")).build()).execute();
        String execute4 = HttpHelperKt.bodyString(response);
        String string = "name=_csrf\\s+content=([^>]+)";
        boolean bl = false;
        Regex toRegex1 = new Regex(string);
        String string2 = "name=_csrf_header\\s+content=([^>]+)";
        boolean bl2 = false;
        Regex toRegex2 = new Regex(string2);
        MatchResult matchResult = Regex.find$default((Regex)toRegex1, (CharSequence)execute4, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        String v = (String)matchResult.getGroupValues().get(1);
        MatchResult matchResult2 = Regex.find$default((Regex)toRegex2, (CharSequence)execute4, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult2);
        String k = (String)matchResult2.getGroupValues().get(1);
        this.info("add ilarm csrf :" + k + "  -> " + v);
        response.close();
        return TuplesKt.to((Object)k, (Object)v);
    }

    public final void getAsyn(@NotNull String url, @NotNull Callback callback, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Request request = HttpHelperKt.addHeaders(new Request.Builder().url(url), headers).build();
        client.newCall(request).enqueue(callback);
    }

    public static /* synthetic */ void getAsyn$default(HttpHelper httpHelper, String string, Callback callback, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = null;
        }
        httpHelper.getAsyn(string, callback, map);
    }

    @NotNull
    public final CompletableFuture<Response> getAsyn(@NotNull String url, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        Request request = HttpHelperKt.addHeaders(new Request.Builder().url(url), headers).build();
        client.newCall(request).enqueue(new Callback(future){
            final /* synthetic */ CompletableFuture<Response> $future;
            {
                this.$future = $future;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$future.complete(response);
            }
        });
        return future;
    }

    public static /* synthetic */ CompletableFuture getAsyn$default(HttpHelper httpHelper, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return httpHelper.getAsyn(string, map);
    }

    @NotNull
    public final CompletableFuture<Response> getAsynWithForm(@NotNull String url, @NotNull Map<String, String> form, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(form, (String)"form");
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        Request.Builder builder2 = new Request.Builder();
        String string = HttpUtil.urlWithForm((String)url, form, (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlWithForm(url, form, CharsetUtil.CHARSET_UTF_8, true)");
        Request request = HttpHelperKt.addHeaders(builder2.url(string), headers).build();
        client.newCall(request).enqueue(new Callback(future){
            final /* synthetic */ CompletableFuture<Response> $future;
            {
                this.$future = $future;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$future.complete(response);
            }
        });
        return future;
    }

    public static /* synthetic */ CompletableFuture getAsynWithForm$default(HttpHelper httpHelper, String string, Map map, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = null;
        }
        return httpHelper.getAsynWithForm(string, map, map2);
    }

    @NotNull
    public final CompletableFuture<Response> postFileAsyn(@NotNull String url, @NotNull File file, @Nullable MediaType mediaType, @Nullable Map<String, String> headers) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        MediaType mediaType2 = mediaType;
        Request request = HttpHelperKt.addHeaders(new Request.Builder().url(url).post(RequestBody.Companion.create(file, mediaType2 == null ? null : ((string = mediaType2.toString()) == null ? null : okhttp3.MediaType.Companion.get(string)))), headers).build();
        client.newCall(request).enqueue(new Callback(future){
            final /* synthetic */ CompletableFuture<Response> $future;
            {
                this.$future = $future;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$future.complete(response);
            }
        });
        return future;
    }

    public static /* synthetic */ CompletableFuture postFileAsyn$default(HttpHelper httpHelper, String string, File file, MediaType mediaType, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            mediaType = null;
        }
        if ((n & 8) != 0) {
            map = null;
        }
        return httpHelper.postFileAsyn(string, file, mediaType, map);
    }

    @NotNull
    public final CompletableFuture<Response> postFormAsyn(@NotNull String url, @NotNull Map<String, String> form, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(form, (String)"form");
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        FormBody.Builder formbuilder = new FormBody.Builder(null, 1, null);
        Object object = form;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String k = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            String v = (String)object3.getValue();
            formbuilder.add(k, v);
        }
        FormBody formBody = formbuilder.build();
        Request request = HttpHelperKt.addHeaders(new Request.Builder().url(url).post((RequestBody)formBody), headers).build();
        client.newCall(request).enqueue(new Callback(future){
            final /* synthetic */ CompletableFuture<Response> $future;
            {
                this.$future = $future;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$future.complete(response);
            }
        });
        return future;
    }

    public static /* synthetic */ CompletableFuture postFormAsyn$default(HttpHelper httpHelper, String string, Map map, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = null;
        }
        return httpHelper.postFormAsyn(string, map, map2);
    }

    @NotNull
    public final CompletableFuture<Response> postStringAsyn(@NotNull String url, @NotNull String postBody, @Nullable MediaType mediaType, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)postBody, (String)"postBody");
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        Request.Builder builder2 = new Request.Builder().url(url);
        MediaType mediaType2 = mediaType;
        String string = (mediaType2 == null ? MediaType.PLAIN_TEXT_UTF_8 : mediaType2).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mediaType ?: MediaType.PLAIN_TEXT_UTF_8).toString()");
        Request request = HttpHelperKt.addHeaders(builder2.post(RequestBody.Companion.create(postBody, okhttp3.MediaType.Companion.get(string))), headers).build();
        client.newCall(request).enqueue(new Callback(future){
            final /* synthetic */ CompletableFuture<Response> $future;
            {
                this.$future = $future;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$future.complete(response);
            }
        });
        return future;
    }

    public static /* synthetic */ CompletableFuture postStringAsyn$default(HttpHelper httpHelper, String string, String string2, MediaType mediaType, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            mediaType = null;
        }
        if ((n & 8) != 0) {
            map = null;
        }
        return httpHelper.postStringAsyn(string, string2, mediaType, map);
    }

    @NotNull
    public final CompletableFuture<Response> postJsonStringAsyn(@NotNull String url, @NotNull String jsonBody, @Nullable Map<String, String> headers, @Nullable Map<String, String> form) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        Map<String, String> map = form;
        boolean bl = false;
        boolean bl2 = false;
        String urls = map == null || map.isEmpty() ? url : HttpUtil.urlWithForm((String)url, form, (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)true);
        Request.Builder builder2 = new Request.Builder();
        Intrinsics.checkNotNullExpressionValue((Object)urls, (String)"urls");
        Request.Builder builder3 = builder2.url(urls);
        String string = MediaType.JSON_UTF_8.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSON_UTF_8.toString()");
        Request request = HttpHelperKt.addHeaders(builder3.post(RequestBody.Companion.create(jsonBody, okhttp3.MediaType.Companion.get(string))), headers).build();
        client.newCall(request).enqueue(new Callback(future){
            final /* synthetic */ CompletableFuture<Response> $future;
            {
                this.$future = $future;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$future.complete(response);
            }
        });
        return future;
    }

    public static /* synthetic */ CompletableFuture postJsonStringAsyn$default(HttpHelper httpHelper, String string, String string2, Map map, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            map = null;
        }
        if ((n & 8) != 0) {
            map2 = null;
        }
        return httpHelper.postJsonStringAsyn(string, string2, map, map2);
    }

    @NotNull
    public final CompletableFuture<Response> postMultipartAsyn(@NotNull String url, @NotNull Map<String, ? extends Object> form, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(form, (String)"form");
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        MultipartBody.Builder builder2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
        Object object = form;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            File file;
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String k = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            Object v = object3.getValue();
            File file2 = file = v instanceof File ? (File)v : null;
            if (file == null) {
                builder2.addFormDataPart(k, v.toString());
                continue;
            }
            builder2.addFormDataPart(k, file.getName(), RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (File)file, null, (int)1, null));
        }
        MultipartBody requestBody2 = builder2.build();
        Request request = HttpHelperKt.addHeaders(new Request.Builder().url(url).post((RequestBody)requestBody2), headers).build();
        client.newCall(request).enqueue(new Callback(future){
            final /* synthetic */ CompletableFuture<Response> $future;
            {
                this.$future = $future;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$future.complete(response);
            }
        });
        return future;
    }

    public static /* synthetic */ CompletableFuture postMultipartAsyn$default(HttpHelper httpHelper, String string, Map map, Map map2, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = null;
        }
        return httpHelper.postMultipartAsyn(string, map, map2);
    }

    public static final /* synthetic */ Pair access$getCSRFRequestHeadXcross$p() {
        return cSRFRequestHeadXcross;
    }

    public static final /* synthetic */ Pair access$getCSRFRequestHeadXface$p() {
        return cSRFRequestHeadXface;
    }

    public static final /* synthetic */ Pair access$getCSRFRequestHeadXbody$p() {
        return cSRFRequestHeadXbody;
    }

    public static final /* synthetic */ Pair access$getCSRFRequestHeadialarm$p() {
        return cSRFRequestHeadialarm;
    }

    public static final /* synthetic */ void access$setCsrf_headerName$p(String string) {
        csrf_headerName = string;
    }

    public static final /* synthetic */ void access$setCsrf_parameterName$p(String string) {
        csrf_parameterName = string;
    }

    public static final /* synthetic */ void access$setCsrf_token$p(String string) {
        csrf_token = string;
    }

    public static final /* synthetic */ void access$setCSRFRequestHeadXface$p(Pair pair) {
        cSRFRequestHeadXface = pair;
    }

    public static final /* synthetic */ void access$setCSRFRequestHeadXcross$p(Pair pair) {
        cSRFRequestHeadXcross = pair;
    }

    public static final /* synthetic */ void access$setCSRFRequestHeadXbody$p(Pair pair) {
        cSRFRequestHeadXbody = pair;
    }

    public static final /* synthetic */ void access$setCSRFRequestHeadialarm$p(Pair pair) {
        cSRFRequestHeadialarm = pair;
    }

    public static final /* synthetic */ String access$getCsrf_headerName$p() {
        return csrf_headerName;
    }

    public static final /* synthetic */ String access$getCsrf_token$p() {
        return csrf_token;
    }

    public static final /* synthetic */ String access$getCsrf_parameterName$p() {
        return csrf_parameterName;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$_init__u24lambda_u2d7;
        Iterator destination$iv$iv;
        Object object;
        Object object2;
        Object object3;
        INSTANCE = new HttpHelper();
        pviaLoginUrlPath = "/portal/cas/loginPage";
        pviaLoginUrlPathCenter = "/center/login";
        pviaIpAndPort = "https://1.1.1.2";
        pviaIpAndPortCenter = "http://1.1.1.2:8001";
        pviaPassword = "123456";
        pviaCenterPassword = "123456";
        pviaisLogin = new AtomicBoolean(false);
        pviaCenterisLogin = new AtomicBoolean(false);
        cookieStore = new ConcurrentHashMap();
        cookieVoList = new ConcurrentHashSet();
        csrf_parameterName = "";
        csrf_headerName = "";
        csrf_token = "";
        cSRFRequestHeadXface = new Pair((Object)"", (Object)"");
        cSRFRequestHeadXcross = new Pair((Object)"", (Object)"");
        cSRFRequestHeadXbody = new Pair((Object)"", (Object)"");
        cSRFRequestHeadialarm = new Pair((Object)"", (Object)"");
        File cookieDirectory = new File("okhttpCacheResponseTmp" + System.getProperty("file.separator") + "cookie.json");
        if (!cookieDirectory.exists()) {
            FileUtil.touch((File)cookieDirectory);
            object3 = cookieDirectory.getAbsolutePath();
            boolean bl = false;
            System.out.println(object3);
        } else {
            Object orNull;
            void $this$mapValuesTo$iv$iv;
            Object answer$iv$iv$iv;
            Object key$iv$iv;
            Iterator $this$groupByTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Object object4;
            void $this$jsonToObject$iv;
            object3 = cookieDirectory.getAbsolutePath();
            boolean bl = false;
            System.out.println(object3);
            String string = FilesKt.readText$default((File)cookieDirectory, null, (int)1, null);
            object2 = cookieVoList;
            boolean $i$f$jsonToObject = false;
            Object object5 = $this$jsonToObject$iv;
            if (object5 == null) {
                object4 = null;
            } else {
                try {
                    object5 = JsonHelper.INSTANCE.getObjectMapper().readValue((String)$this$jsonToObject$iv, (TypeReference)new TypeReference<HashSet<SetCookieBO>>(){});
                }
                catch (Exception e$iv) {
                    JsonsKt.getLogger().error(e$iv.getLocalizedMessage());
                    object5 = null;
                }
                object4 = object5;
            }
            object = object4;
            object3 = (HashSet)object;
            object2.addAll(object3 == null ? (Collection)SetsKt.emptySet() : (Collection)object3);
            Iterable $this$mapNotNull$iv = (Iterable)cookieVoList;
            boolean $i$f$mapNotNull = false;
            object5 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object6 = $this$forEach$iv$iv$iv.iterator();
            while (object6.hasNext()) {
                Cookie cookie;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object6.next();
                boolean bl2 = false;
                SetCookieBO it = (SetCookieBO)element$iv$iv;
                boolean bl3 = false;
                if (Cookie.Companion.parse(HttpUrl.Companion.get(it.getUrl()), it.getSetCookie()) == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                Cookie it$iv$iv = cookie;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$groupBy$iv = (List)((Object)destination$iv$iv);
            boolean $i$f$groupBy = false;
            $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            $this$forEach$iv$iv$iv = $this$groupByTo$iv$iv.iterator();
            while ($this$forEach$iv$iv$iv.hasNext()) {
                Object object7;
                Object element$iv$iv = $this$forEach$iv$iv$iv.next();
                Cookie it = (Cookie)element$iv$iv;
                boolean bl7 = false;
                key$iv$iv = it.domain();
                Iterator $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl8 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object7 = answer$iv$iv$iv;
                } else {
                    object7 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object7;
                list$iv$iv.add(element$iv$iv);
            }
            Iterator $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map map;
                void $this$associateByTo$iv$iv;
                void it;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Iterator iterator = destination$iv$iv;
                boolean bl9 = false;
                Object k = it$iv$iv.getKey();
                answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                object = k;
                object2 = iterator;
                boolean bl10 = false;
                Iterable $this$associateBy$iv = (Iterable)it.getValue();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo2 = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it2;
                    Cookie cookie = (Cookie)element$iv$iv;
                    map = destination$iv$iv2;
                    boolean bl11 = false;
                    String string2 = it2.name();
                    map.put(string2, element$iv$iv);
                }
                Map map2 = map = destination$iv$iv2;
                ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(map2);
                object2.put(object, concurrentHashMap);
            }
            Iterator map = destination$iv$iv;
            cookieStore.putAll((Map<String, ConcurrentHashMap<String, Cookie>>)((Object)map));
            $this$mapValues$iv = (Collection)cookieVoList;
            $i$f$mapValues = false;
            if (!$this$mapValues$iv.isEmpty()) {
                Object v3;
                Object $this$firstOrNull$iv;
                block16: {
                    $this$firstOrNull$iv = (Iterable)cookieVoList;
                    boolean $i$f$firstOrNull = false;
                    destination$iv$iv = $this$firstOrNull$iv.iterator();
                    while (destination$iv$iv.hasNext()) {
                        Object element$iv = destination$iv$iv.next();
                        SetCookieBO it = (SetCookieBO)element$iv;
                        boolean bl12 = false;
                        object6 = it.getCsrf_headerName();
                        boolean bl13 = false;
                        boolean bl14 = !StringsKt.isBlank((CharSequence)object6);
                        if (!bl14) continue;
                        v3 = element$iv;
                        break block16;
                    }
                    v3 = null;
                }
                orNull = v3;
                $this$firstOrNull$iv = orNull;
                csrf_headerName = $this$firstOrNull$iv == null ? "" : ((SetCookieBO)$this$firstOrNull$iv).getCsrf_headerName();
                $this$firstOrNull$iv = orNull;
                csrf_token = $this$firstOrNull$iv == null ? "" : ((SetCookieBO)$this$firstOrNull$iv).getCsrf_token();
                $this$firstOrNull$iv = orNull;
                csrf_parameterName = $this$firstOrNull$iv == null ? "" : ((SetCookieBO)$this$firstOrNull$iv).getCsrf_parameterName();
            }
            orNull = Intrinsics.stringPlus((String)"\u52a0\u8f7d\u6587\u4ef6\u4e2dcookie ", (Object)JsonsKt.toJsonStr(cookieVoList));
            boolean $this$firstOrNull$iv = false;
            System.out.println(orNull);
        }
        OkHttpClient.Builder this_$iv = new OkHttpClient.Builder().followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(false);
        boolean bl = false;
        this_$iv = this_$iv.addInterceptor(new Interceptor(){

            @NotNull
            public final Response intercept(@NotNull Interceptor.Chain chain) {
                CharSequence charSequence;
                CharSequence proceed;
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                Request oldRequest = chain2.request();
                HttpHelper.INSTANCE.info(Intrinsics.stringPlus((String)"\u7528\u6237\u8bf7\u6c42===========", (Object)oldRequest));
                CharSequence charSequence2 = (CharSequence)HttpHelper.access$getCSRFRequestHeadXcross$p().getFirst();
                boolean bl2 = false;
                if (!StringsKt.isBlank((CharSequence)charSequence2) && HttpHelperKt.needCarCsrf(oldRequest)) {
                    charSequence = proceed = chain2.proceed(oldRequest.newBuilder().addHeader((String)HttpHelper.access$getCSRFRequestHeadXcross$p().getFirst(), (String)HttpHelper.access$getCSRFRequestHeadXcross$p().getSecond()).build());
                } else {
                    proceed = (CharSequence)HttpHelper.access$getCSRFRequestHeadXface$p().getFirst();
                    bl2 = false;
                    if (!StringsKt.isBlank((CharSequence)proceed) && HttpHelperKt.needFaceCsrf(oldRequest)) {
                        charSequence = proceed = chain2.proceed(oldRequest.newBuilder().addHeader((String)HttpHelper.access$getCSRFRequestHeadXface$p().getFirst(), (String)HttpHelper.access$getCSRFRequestHeadXface$p().getSecond()).build());
                    } else {
                        proceed = (CharSequence)HttpHelper.access$getCSRFRequestHeadXbody$p().getFirst();
                        bl2 = false;
                        if (!StringsKt.isBlank((CharSequence)proceed) && HttpHelperKt.needBodyCsrf(oldRequest)) {
                            charSequence = proceed = chain2.proceed(oldRequest.newBuilder().addHeader((String)HttpHelper.access$getCSRFRequestHeadXbody$p().getFirst(), (String)HttpHelper.access$getCSRFRequestHeadXbody$p().getSecond()).build());
                        } else {
                            proceed = (CharSequence)HttpHelper.access$getCSRFRequestHeadialarm$p().getFirst();
                            bl2 = false;
                            if (!StringsKt.isBlank((CharSequence)proceed) && HttpHelperKt.needAlarmCsrf(oldRequest)) {
                                charSequence = proceed = chain2.proceed(oldRequest.newBuilder().addHeader((String)HttpHelper.access$getCSRFRequestHeadialarm$p().getFirst(), (String)HttpHelper.access$getCSRFRequestHeadialarm$p().getSecond()).build());
                            } else {
                                Response response = chain2.proceed(oldRequest);
                                if (StringsKt.contains$default((CharSequence)response.request().url().toString(), (CharSequence)HttpHelper.INSTANCE.getPviaLoginUrlPath(), (boolean)false, (int)2, null)) {
                                    String body = HttpHelperKt.bodyString(response);
                                    String string = "enableCsrf\\s+\\=\\s+JSON.parse\\('([^']+)'\\)";
                                    boolean bl3 = false;
                                    Regex regex = new Regex(string);
                                    Object object = Regex.find$default((Regex)regex, (CharSequence)body, (int)0, (int)2, null);
                                    Intrinsics.checkNotNull((Object)object);
                                    List list = object.getGroupValues();
                                    Intrinsics.checkNotNull((Object)list);
                                    String get2 = (String)list.get(1);
                                    HttpHelper.INSTANCE.info(get2);
                                    JSONObject jsonObject = JSONUtil.parseObj((String)get2);
                                    object = jsonObject.getStr((Object)"headerName");
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObject.getStr(\"headerName\")");
                                    HttpHelper.access$setCsrf_headerName$p((String)object);
                                    object = jsonObject.getStr((Object)"parameterName");
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObject.getStr(\"parameterName\")");
                                    HttpHelper.access$setCsrf_parameterName$p((String)object);
                                    object = jsonObject.getStr((Object)"token");
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObject.getStr(\"token\")");
                                    HttpHelper.access$setCsrf_token$p((String)object);
                                    HttpHelper.INSTANCE.login("admin", HttpHelper.INSTANCE.getPviaPassword());
                                    response.close();
                                    charSequence = chain2.proceed(oldRequest);
                                } else if (StringsKt.contains$default((CharSequence)response.request().url().toString(), (CharSequence)HttpHelper.INSTANCE.getPviaLoginUrlPathCenter(), (boolean)false, (int)2, null)) {
                                    String body = HttpHelperKt.bodyString(response);
                                    T get2 = HttpHelper.getAsyn$default(HttpHelper.INSTANCE, Intrinsics.stringPlus((String)HttpHelper.INSTANCE.getPviaIpAndPortCenter(), (Object)"/center/api/session?userId=sysadmin"), null, 2, null).get();
                                    Intrinsics.checkNotNullExpressionValue(get2, (String)"getAsyn(\"${pviaIpAndPortCenter}/center/api/session?userId=sysadmin\").get()");
                                    String message = HttpHelperKt.bodyString((Response)get2);
                                    HttpHelper.INSTANCE.info(HttpHelper.INSTANCE.getPviaIpAndPortCenter() + "/center/api/session?userId=sysadmin " + message);
                                    JSONObject jsonObject = JSONUtil.parseObj((String)message);
                                    String password = SecureUtil.sha256((String)Intrinsics.stringPlus((String)SecureUtil.sha256((String)Intrinsics.stringPlus((String)HttpHelper.INSTANCE.getPviaCenterPassword(), (Object)jsonObject.getByPath("data.salt"))), (Object)jsonObject.getByPath("data.challenge.code")));
                                    Response response1 = (Response)HttpHelper.postJsonStringAsyn$default(HttpHelper.INSTANCE, Intrinsics.stringPlus((String)HttpHelper.INSTANCE.getPviaIpAndPortCenter(), (Object)"/center/api/session"), StringsKt.trimIndent((String)("\n            {\"user\":{\"id\":\"sysadmin\"},\"password\":\"" + password + "\",\n            \"captcha\":\"\",\"salt\":\"" + jsonObject.getByPath("data.salt") + "\",\n            \"challenge\":{\"code\":\"" + jsonObject.getByPath("data.challenge.code") + "\",\n            \"id\":\"" + jsonObject.getByPath("data.challenge.id") + "\"}}\n        ")), null, null, 12, null).get();
                                    CharSequence charSequence3 = (String)CollectionsKt.firstOrNull((List)response1.headers("refresh-url"));
                                    String headers = charSequence3 == null ? "" : charSequence3;
                                    response1.close();
                                    charSequence3 = headers;
                                    boolean bl4 = false;
                                    if (!StringsKt.isBlank((CharSequence)charSequence3)) {
                                        Response response2 = (Response)HttpHelper.getAsyn$default(HttpHelper.INSTANCE, headers, null, 2, null).get();
                                        response2.close();
                                        String string = Intrinsics.stringPlus((String)"\u767b\u5f55\u8fd0\u7ba1\u6210\u529f", (Object)response2);
                                        boolean bl5 = false;
                                        System.out.println((Object)string);
                                    }
                                    response.close();
                                    charSequence = chain2.proceed(oldRequest);
                                } else if (response.code() == 403 && HttpHelperKt.needFaceCsrf(oldRequest)) {
                                    Pair head = HttpHelper.requestCSRFRequestHead$default(HttpHelper.INSTANCE, Intrinsics.stringPlus((String)HttpHelper.INSTANCE.getPviaIpAndPort(), (Object)"/iface-web/index.do"), null, null, 6, null);
                                    HttpHelper.access$setCSRFRequestHeadXface$p(head);
                                    HttpHelperKt.bodyString(response);
                                    response.close();
                                    Response proceed2 = chain2.proceed(oldRequest.newBuilder().addHeader((String)head.getFirst(), (String)head.getSecond()).build());
                                    charSequence = proceed2;
                                } else if (response.code() == 403 && HttpHelperKt.needCarCsrf(oldRequest)) {
                                    Pair head = HttpHelper.requestCSRFRequestHead$default(HttpHelper.INSTANCE, Intrinsics.stringPlus((String)HttpHelper.INSTANCE.getPviaIpAndPort(), (Object)"/ivehicle-web/view/index.do"), null, null, 6, null);
                                    HttpHelper.access$setCSRFRequestHeadXcross$p(head);
                                    HttpHelperKt.bodyString(response);
                                    response.close();
                                    Response proceed3 = chain2.proceed(oldRequest.newBuilder().addHeader((String)head.getFirst(), (String)head.getSecond()).build());
                                    charSequence = proceed3;
                                } else if (response.code() == 403 && HttpHelperKt.needBodyCsrf(oldRequest)) {
                                    Pair head = HttpHelper.requestCSRFRequestHead$default(HttpHelper.INSTANCE, Intrinsics.stringPlus((String)HttpHelper.INSTANCE.getPviaIpAndPort(), (Object)"/ibody-web/web/statistic/jumpToStatisticPage.do"), null, null, 6, null);
                                    HttpHelper.access$setCSRFRequestHeadXbody$p(head);
                                    HttpHelperKt.bodyString(response);
                                    response.close();
                                    Response proceed4 = chain2.proceed(oldRequest.newBuilder().addHeader((String)head.getFirst(), (String)head.getSecond()).build());
                                    charSequence = proceed4;
                                } else if (response.code() == 403 && HttpHelperKt.needAlarmCsrf(oldRequest)) {
                                    Pair<String, String> head = HttpHelper.INSTANCE.ialarmCSRFRequestHead();
                                    HttpHelper.access$setCSRFRequestHeadialarm$p(head);
                                    HttpHelperKt.bodyString(response);
                                    response.close();
                                    Response proceed5 = chain2.proceed(oldRequest.newBuilder().addHeader((String)head.getFirst(), (String)head.getSecond()).build());
                                    charSequence = proceed5;
                                } else {
                                    charSequence = response;
                                }
                            }
                        }
                    }
                }
                return charSequence;
            }
        });
        boolean bl15 = false;
        OkHttpClient.Builder builder2 = this_$iv.addNetworkInterceptor(new Interceptor(){

            @NotNull
            public final Response intercept(@NotNull Interceptor.Chain chain) {
                Request request;
                Response response;
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                Request oldRequest = chain2.request();
                Set names = oldRequest.headers().names();
                Request.Builder requestBuild = oldRequest.newBuilder();
                CharSequence charSequence = HttpHelper.access$getCsrf_headerName$p();
                boolean bl2 = false;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    charSequence = HttpHelper.access$getCsrf_token$p();
                    bl2 = false;
                    if (!StringsKt.isBlank((CharSequence)charSequence) && !names.contains(HttpHelper.access$getCsrf_headerName$p())) {
                        requestBuild.addHeader(HttpHelper.access$getCsrf_headerName$p(), HttpHelper.access$getCsrf_token$p());
                    }
                }
                charSequence = HttpHelper.access$getCsrf_parameterName$p();
                bl2 = false;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    charSequence = HttpHelper.access$getCsrf_token$p();
                    bl2 = false;
                    if (!StringsKt.isBlank((CharSequence)charSequence) && !names.contains(HttpHelper.access$getCsrf_parameterName$p())) {
                        requestBuild.addHeader(HttpHelper.access$getCsrf_parameterName$p(), HttpHelper.access$getCsrf_token$p());
                    }
                }
                if (com.github.jchanghong.kotlin.StringsKt.isNotNUllOrBlank2((response = chain2.proceed(request = requestBuild.build())).header("Set-Cookie", ""))) {
                    HttpHelper.INSTANCE.getCookieVoList().add((Object)new SetCookieBO(request.url().toString(), String.valueOf(response.header("Set-Cookie", "")), HttpHelper.access$getCsrf_headerName$p(), HttpHelper.access$getCsrf_token$p(), HttpHelper.access$getCsrf_parameterName$p()));
                }
                HttpHelper.INSTANCE.info(Intrinsics.stringPlus((String)"\u670d\u52a1\u5668\u8fd4\u56de\uff1a", (Object)response));
                return response;
            }
        }).cookieJar(new CookieJar(cookieDirectory){
            final /* synthetic */ File $cookieDirectory;
            {
                this.$cookieDirectory = $cookieDirectory;
            }

            /*
             * WARNING - void declaration
             */
            public void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
                for (Cookie cookie : cookies) {
                    void $this$getOrPut$iv;
                    Map<String, Cookie> map = HttpHelper.INSTANCE.getCookieStore();
                    String key$iv = cookie.domain();
                    boolean $i$f$getOrPut = false;
                    Object object = $this$getOrPut$iv.get(key$iv);
                    if (object == null) {
                        boolean bl = false;
                        ConcurrentHashMap<K, V> concurrentHashMap = new ConcurrentHashMap<K, V>();
                        boolean bl2 = false;
                        boolean bl3 = false;
                        ConcurrentHashMap<K, V> default$iv = concurrentHashMap;
                        boolean bl4 = false;
                        object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                        if (object == null) {
                            object = default$iv;
                        }
                    }
                    ConcurrentHashMap hashMap = (ConcurrentHashMap)object;
                    Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"hashMap");
                    map = hashMap;
                    String string = cookie.name();
                    boolean bl = false;
                    map.put(string, cookie);
                }
                if (this.$cookieDirectory.exists()) {
                    FileUtil.writeUtf8String((String)JsonsKt.toJsonStr(HttpHelper.INSTANCE.getCookieVoList()), (File)this.$cookieDirectory);
                }
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
                void $this$getOrPut$iv;
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Object object = HttpHelper.INSTANCE.getCookieStore();
                String key$iv = url.host();
                boolean $i$f$getOrPut = false;
                Object object2 = $this$getOrPut$iv.get(key$iv);
                if (object2 == null) {
                    boolean bl = false;
                    ConcurrentHashMap<K, V> concurrentHashMap = new ConcurrentHashMap<K, V>();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ConcurrentHashMap<K, V> default$iv = concurrentHashMap;
                    boolean bl4 = false;
                    object2 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                    if (object2 == null) {
                        object2 = default$iv;
                    }
                }
                ConcurrentHashMap hashMap = (ConcurrentHashMap)object2;
                object = hashMap.values();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"hashMap.values");
                return CollectionsKt.toList((Iterable)((Iterable)object));
            }
        }).sslSocketFactory(INSTANCE.createSSLSocketFactory(), (X509TrustManager)new TrustAllCerts()).hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier());
        ExecutorService executorService = Executors.newFixedThreadPool(64, ThreadUtil.newNamedThreadFactory((String)"OKHttpDispatcher", (boolean)false));
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(\n                        64,\n                        ThreadUtil.newNamedThreadFactory(\"OKHttpDispatcher\", false)\n                    )");
        executorService = new Dispatcher(executorService);
        boolean bl16 = false;
        boolean $i$f$firstOrNull = false;
        destination$iv$iv = executorService;
        object2 = builder2;
        boolean bl17 = false;
        $this$_init__u24lambda_u2d7.setMaxRequests(64);
        $this$_init__u24lambda_u2d7.setMaxRequestsPerHost(63);
        object = Unit.INSTANCE;
        OkHttpClient.Builder builder3 = object2.dispatcher((Dispatcher)executorService).connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS).callTimeout(0L, TimeUnit.SECONDS);
        boolean bl18 = false;
        try {
            Object object8 = Result.Companion;
            boolean bl19 = false;
            File cacheDirectory = new File('.' + System.getProperty("file.separator") + "okhttpCacheResponseTmp");
            FileUtil.mkdir((File)cacheDirectory);
            OkHttpClient.Builder builder4 = builder3.cache(new Cache(cacheDirectory, 0xA00000L));
            boolean bl20 = false;
            object8 = Result.constructor-impl((Object)builder4);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl21 = false;
            Object object9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        client = builder3.build();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ%\u0010\u000b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/github/jchanghong/http/HttpHelper$TrustAllCerts;", "Ljavax/net/ssl/X509TrustManager;", "()V", "checkClientTrusted", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "checkServerTrusted", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "kotlin-lib-min"})
    private static final class TrustAllCerts
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(@NotNull X509Certificate[] chain, @Nullable String authType) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        }

        @Override
        public void checkServerTrusted(@NotNull X509Certificate[] chain, @Nullable String authType) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/github/jchanghong/http/HttpHelper$TrustAllHostnameVerifier;", "Ljavax/net/ssl/HostnameVerifier;", "()V", "verify", "", "hostname", "", "session", "Ljavax/net/ssl/SSLSession;", "kotlin-lib-min"})
    private static final class TrustAllHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(@Nullable String hostname, @Nullable SSLSession session) {
            return true;
        }
    }
}

