/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.redis;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010 \u001a\u00020!J0\u0010\"\u001a\u00020!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$2\u001a\u0010%\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030'0&R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR[\u0010\u0010\u001aB\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00030\u0003 \u0012* \u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u00110\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0017\u001a\n \u0012*\u0004\u0018\u00010\u00180\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lcom/github/jchanghong/redis/RedisHelper;", "", "ip", "", "port", "", "password", "(Ljava/lang/String;ILjava/lang/String;)V", "asyncCommands", "Lio/lettuce/core/api/async/RedisAsyncCommands;", "getAsyncCommands", "()Lio/lettuce/core/api/async/RedisAsyncCommands;", "connect", "Lio/lettuce/core/api/StatefulRedisConnection;", "getConnect", "()Lio/lettuce/core/api/StatefulRedisConnection;", "pubSubConnection", "Lio/lettuce/core/pubsub/StatefulRedisPubSubConnection;", "kotlin.jvm.PlatformType", "getPubSubConnection", "()Lio/lettuce/core/pubsub/StatefulRedisPubSubConnection;", "pubSubConnection$delegate", "Lkotlin/Lazy;", "redisClient", "Lio/lettuce/core/RedisClient;", "getRedisClient", "()Lio/lettuce/core/RedisClient;", "redisClient$delegate", "redisCommands", "Lio/lettuce/core/api/sync/RedisCommands;", "getRedisCommands", "()Lio/lettuce/core/api/sync/RedisCommands;", "close", "", "subscribe", "topics", "", "consumer", "Ljava/util/function/Consumer;", "Lkotlin/Pair;", "kotlin-lib"})
public final class RedisHelper {
    private final Lazy redisClient$delegate;
    @NotNull
    private final StatefulRedisConnection<String, String> connect;
    private final Lazy pubSubConnection$delegate;
    @NotNull
    private final RedisCommands<String, String> redisCommands;
    @NotNull
    private final RedisAsyncCommands<String, String> asyncCommands;

    public final RedisClient getRedisClient() {
        Lazy lazy = this.redisClient$delegate;
        RedisHelper redisHelper = this;
        Object var3_3 = null;
        boolean bl = false;
        return (RedisClient)lazy.getValue();
    }

    @NotNull
    public final StatefulRedisConnection<String, String> getConnect() {
        return this.connect;
    }

    public final StatefulRedisPubSubConnection<String, String> getPubSubConnection() {
        Lazy lazy = this.pubSubConnection$delegate;
        RedisHelper redisHelper = this;
        Object var3_3 = null;
        boolean bl = false;
        return (StatefulRedisPubSubConnection)lazy.getValue();
    }

    @NotNull
    public final RedisCommands<String, String> getRedisCommands() {
        return this.redisCommands;
    }

    @NotNull
    public final RedisAsyncCommands<String, String> getAsyncCommands() {
        return this.asyncCommands;
    }

    public final void subscribe(@NotNull List<String> topics, @NotNull Consumer<Pair<String, String>> consumer) {
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.getPubSubConnection().addListener((RedisPubSubListener)new RedisPubSubAdapter<String, String>(consumer){
            final /* synthetic */ Consumer $consumer;

            public void message(@NotNull String channel, @Nullable String message) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                this.$consumer.accept(TuplesKt.to((Object)channel, (Object)message));
            }
            {
                this.$consumer = $captured_local_variable$0;
            }
        });
        Collection $this$toTypedArray$iv = topics;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.getPubSubConnection().sync().subscribe((Object[])Arrays.copyOf(stringArray, stringArray.length));
    }

    public final void close() {
        this.connect.close();
        this.getPubSubConnection().close();
        this.getRedisClient().shutdown();
    }

    public RedisHelper(@NotNull String ip, int port, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        this.redisClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RedisClient>(ip, port, password){
            final /* synthetic */ String $ip;
            final /* synthetic */ int $port;
            final /* synthetic */ String $password;

            public final RedisClient invoke() {
                RedisURI.Builder builder = RedisURI.builder().withHost(this.$ip).withPort(this.$port);
                CharSequence charSequence = this.$password;
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    builder.withPassword(this.$password);
                }
                return RedisClient.create((RedisURI)builder.build());
            }
            {
                this.$ip = string;
                this.$port = n;
                this.$password = string2;
                super(0);
            }
        }));
        StatefulRedisConnection statefulRedisConnection = this.getRedisClient().connect();
        Intrinsics.checkNotNullExpressionValue((Object)statefulRedisConnection, (String)"redisClient.connect()");
        this.connect = statefulRedisConnection;
        this.pubSubConnection$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StatefulRedisPubSubConnection<String, String>>(this){
            final /* synthetic */ RedisHelper this$0;

            public final StatefulRedisPubSubConnection<String, String> invoke() {
                return this.this$0.getRedisClient().connectPubSub();
            }
            {
                this.this$0 = redisHelper;
                super(0);
            }
        }));
        RedisCommands redisCommands = this.connect.sync();
        Intrinsics.checkNotNullExpressionValue((Object)redisCommands, (String)"connect.sync()");
        this.redisCommands = redisCommands;
        RedisAsyncCommands redisAsyncCommands = this.connect.async();
        Intrinsics.checkNotNullExpressionValue((Object)redisAsyncCommands, (String)"connect.async()");
        this.asyncCommands = redisAsyncCommands;
    }

    public /* synthetic */ RedisHelper(String string, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 6379;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        this(string, n, string2);
    }
}

