/*
 * Decompiled with CFR 0.152.
 */
package com.github.jingshouyan.jdbc.data.init;

import com.github.jingshouyan.jdbc.comm.entity.Record;
import com.github.jingshouyan.jdbc.comm.util.VersionUtil;
import com.github.jingshouyan.jdbc.data.init.action.VersionHandler;
import com.github.jingshouyan.jdbc.data.init.dao.DataInitVersionDao;
import com.github.jingshouyan.jdbc.data.init.entity.DataInitVersion;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ComponentScan
@Order(value=0x7FFFFFFF)
public class DataInitAutoConfiguration
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(DataInitAutoConfiguration.class);
    @Autowired
    private DataInitVersionDao versionDao;
    @Autowired
    private ApplicationContext ctx;

    public void run(ApplicationArguments args) {
        Map map = this.ctx.getBeansOfType(VersionHandler.class);
        ArrayList handlers = Lists.newArrayList(map.values());
        Collections.sort(handlers);
        String latest = this.versionDao.latestVersion().map(DataInitVersion::getVersion).orElse("");
        handlers.stream().filter(h -> this.isNew(h.version(), latest)).forEach(h -> {
            DataInitVersion version = new DataInitVersion();
            version.setVersion(h.version());
            version.setClazz(h.getClass().getName());
            this.versionDao.insert((Record)version);
            try {
                h.action();
                version.setSuccess(true);
                this.versionDao.update((Record)version);
            }
            catch (Throwable e) {
                version.setSuccess(false);
                version.setMessage(e.getMessage());
                version.forDelete();
                this.versionDao.update((Record)version);
                throw e;
            }
        });
    }

    private boolean isNew(String version, String target) {
        return VersionUtil.compareVersion((String)version, (String)target) > 0;
    }
}

