/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.jakarta.enterprise.inject.impl;

import com.github.jonasrutishauser.jakarta.enterprise.inject.ExtendedInstance;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class CDI3ExtendedInstance<T>
implements ExtendedInstance<T> {
    private final BeanManager beanManager;
    private final Instance<T> instance;
    private final Type targetType;
    private final Set<Annotation> qualifiers;

    public CDI3ExtendedInstance(BeanManager beanManager, Instance<T> instance, Type targetType, Set<Annotation> qualifiers) {
        this.beanManager = beanManager;
        this.targetType = targetType;
        this.instance = instance;
        this.qualifiers = qualifiers;
    }

    @Override
    public ExtendedInstance<T> select(Annotation ... qualifiers) {
        return new CDI3ExtendedInstance<T>(this.beanManager, this.instance.select(qualifiers), this.targetType, this.addedQualifiers(qualifiers));
    }

    @Override
    public <U extends T> ExtendedInstance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return new CDI3ExtendedInstance<T>(this.beanManager, this.instance.select(subtype, qualifiers), subtype, this.addedQualifiers(qualifiers));
    }

    @Override
    public <U extends T> ExtendedInstance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return new CDI3ExtendedInstance<T>(this.beanManager, this.instance.select(subtype, qualifiers), subtype.getType(), this.addedQualifiers(qualifiers));
    }

    @Override
    public Instance<T> getInstance() {
        return this.instance;
    }

    @Override
    public ExtendedInstance.Handle<T> getPseudoScopeClosingHandle() {
        return new HandleImpl();
    }

    private Set<Annotation> addedQualifiers(Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return newQualifiers;
    }

    private class HandleImpl
    implements ExtendedInstance.Handle<T> {
        private T bean;

        private HandleImpl() {
        }

        @Override
        public T get() {
            if (this.bean == null) {
                this.bean = CDI3ExtendedInstance.this.instance.get();
            }
            return this.bean;
        }

        @Override
        public Bean<T> getBean() {
            return CDI3ExtendedInstance.this.beanManager.resolve(CDI3ExtendedInstance.this.beanManager.getBeans(CDI3ExtendedInstance.this.targetType, (Annotation[])CDI3ExtendedInstance.this.qualifiers.toArray(Annotation[]::new)));
        }

        @Override
        public void destroy() {
            if (this.bean != null) {
                CDI3ExtendedInstance.this.instance.destroy(this.bean);
                this.bean = null;
            }
        }

        @Override
        public void close() {
            if (!CDI3ExtendedInstance.this.beanManager.isNormalScope(this.getBean().getScope())) {
                this.destroy();
            }
        }
    }
}

