/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.jakarta.enterprise.inject.impl;

import com.github.jonasrutishauser.jakarta.enterprise.inject.ExtendedInstance;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;

class CDI4ExtendedInstance<T>
implements ExtendedInstance<T> {
    private final BeanManager beanManager;
    private final Instance<T> instance;

    public CDI4ExtendedInstance(BeanManager beanManager, Instance<T> instance) {
        this.beanManager = beanManager;
        this.instance = instance;
    }

    @Override
    public ExtendedInstance<T> select(Annotation ... qualifiers) {
        return new CDI4ExtendedInstance<T>(this.beanManager, this.instance.select(qualifiers));
    }

    @Override
    public <U extends T> ExtendedInstance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return new CDI4ExtendedInstance<T>(this.beanManager, this.instance.select(subtype, qualifiers));
    }

    @Override
    public <U extends T> ExtendedInstance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return new CDI4ExtendedInstance<T>(this.beanManager, this.instance.select(subtype, qualifiers));
    }

    @Override
    public Instance<T> getInstance() {
        return this.instance;
    }

    @Override
    public ExtendedInstance.Handle<T> getPseudoScopeClosingHandle() {
        return new HandleImpl(this.beanManager, this.instance.getHandle());
    }

    private static class HandleImpl<T>
    implements ExtendedInstance.Handle<T> {
        private final BeanManager beanManager;
        private final Instance.Handle<T> delegate;

        public HandleImpl(BeanManager beanManager, Instance.Handle<T> delegate) {
            this.beanManager = beanManager;
            this.delegate = delegate;
        }

        @Override
        public T get() {
            return (T)this.delegate.get();
        }

        @Override
        public Bean<T> getBean() {
            return this.delegate.getBean();
        }

        @Override
        public void destroy() {
            this.delegate.destroy();
        }

        @Override
        public void close() {
            if (!this.beanManager.isNormalScope(this.delegate.getBean().getScope())) {
                this.delegate.destroy();
            }
        }
    }
}

