/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.jakarta.enterprise.inject.impl;

import com.github.jonasrutishauser.jakarta.enterprise.inject.ExtendedInstance;
import com.github.jonasrutishauser.jakarta.enterprise.inject.impl.ExtendedInstanceProducer;
import com.github.jonasrutishauser.jakarta.enterprise.inject.impl.InstanceType;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.Producer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

public class ExtendedInstanceExtension
implements Extension {
    private Set<Annotation> qualifiers = new HashSet<Annotation>();

    void addProducer(@Observes BeforeBeanDiscovery event) {
        event.addAnnotatedType(ExtendedInstanceProducer.class, ExtendedInstanceProducer.class.getName()).add((Annotation)Dependent.Literal.INSTANCE);
    }

    void addQualifiers(@Observes ProcessInjectionPoint<?, ExtendedInstance<?>> event) {
        this.qualifiers.addAll(event.getInjectionPoint().getQualifiers());
    }

    void addAllQualifiers(@Observes ProcessBeanAttributes<ExtendedInstance> event) {
        event.configureBeanAttributes().qualifiers(this.qualifiers);
    }

    void setExtendedInstanceProducer(@Observes ProcessProducer<?, ExtendedInstance> event, BeanManager beanManager) {
        Producer extendedInstanceProducer = event.getProducer();
        event.configureProducer().produceWith(creationalContext -> {
            final InjectionPoint targetInjectionPoint = (InjectionPoint)beanManager.getInjectableReference(extendedInstanceProducer.getInjectionPoints().stream().filter(ip -> InjectionPoint.class.equals((Object)ip.getType())).findAny().orElseThrow(IllegalStateException::new), creationalContext);
            final InjectionPoint instanceInjectionPoint = extendedInstanceProducer.getInjectionPoints().stream().filter(ip -> ip.getType() instanceof ParameterizedType).findAny().orElseThrow(IllegalStateException::new);
            Instance instance = (Instance)beanManager.getInjectableReference(new InjectionPoint(){

                public Type getType() {
                    if (targetInjectionPoint.getType() instanceof Class) {
                        return new InstanceType((Type)((Object)Object.class));
                    }
                    return new InstanceType(((ParameterizedType)targetInjectionPoint.getType()).getActualTypeArguments()[0]);
                }

                public Set<Annotation> getQualifiers() {
                    return targetInjectionPoint.getQualifiers();
                }

                public Bean<?> getBean() {
                    return instanceInjectionPoint.getBean();
                }

                public Member getMember() {
                    return instanceInjectionPoint.getMember();
                }

                public Annotated getAnnotated() {
                    return instanceInjectionPoint.getAnnotated();
                }

                public boolean isDelegate() {
                    return false;
                }

                public boolean isTransient() {
                    return false;
                }
            }, creationalContext);
            return ExtendedInstanceProducer.create(beanManager, targetInjectionPoint, instance);
        });
    }
}

