/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.jakarta.enterprise.inject.impl;

import com.github.jonasrutishauser.jakarta.enterprise.inject.ExtendedInstance;
import com.github.jonasrutishauser.jakarta.enterprise.inject.impl.CDI3ExtendedInstance;
import com.github.jonasrutishauser.jakarta.enterprise.inject.impl.CDI4ExtendedInstance;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

class ExtendedInstanceProducer {
    private static final boolean CDI_4 = ExtendedInstanceProducer.isCdiVersionAtLeast4();

    private static boolean isCdiVersionAtLeast4() {
        try {
            Instance.class.getMethod("getHandle", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Produces
    static <T> ExtendedInstance<T> createExtendedInstance(InjectionPoint injectionPoint, Instance<Object> instance) {
        throw new IllegalStateException("should not be called");
    }

    static <T> ExtendedInstance<T> create(BeanManager beanManager, InjectionPoint injectionPoint, Instance<T> instance) {
        if (CDI_4) {
            return new CDI4ExtendedInstance<T>(beanManager, instance);
        }
        Object targetType = Object.class;
        if (injectionPoint.getType() instanceof ParameterizedType) {
            targetType = ((ParameterizedType)injectionPoint.getType()).getActualTypeArguments()[0];
        }
        return new CDI3ExtendedInstance<T>(beanManager, instance, (Type)targetType, injectionPoint.getQualifiers());
    }

    private ExtendedInstanceProducer() {
    }
}

