/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.api;

import com.github.jonasrutishauser.transactional.event.api.Configuration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Specializes;
import jakarta.inject.Inject;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.annotation.Gauge;

@Specializes
@ApplicationScoped
public class MPConfiguration
extends Configuration {
    @Inject
    @ConfigProperty(name="transactional.event.allInUseInterval")
    Optional<Integer> allInUseInterval = Optional.empty();
    @Inject
    @ConfigProperty(name="transactional.event.maxDispatchInterval")
    Optional<Integer> maxDispatchInterval = Optional.empty();
    @Inject
    @ConfigProperty(name="transactional.event.initialDispatchInterval")
    Optional<Integer> initialDispatchInterval = Optional.empty();
    @Inject
    @ConfigProperty(name="transactional.event.table")
    Optional<String> tableName = Optional.empty();
    @Inject
    @ConfigProperty(name="transactional.event.maxAquire")
    Optional<Integer> maxAquire = Optional.empty();
    @Inject
    @ConfigProperty(name="transactional.event.maxConcurrentDispatching")
    Optional<Integer> maxConcurrentDispatching = Optional.empty();

    @Override
    @Gauge(name="com.github.jonasrutishauser.transaction.event.all.in.use.interval", description="Interval between lookups for events to process when maxConcurrentDispatching is reached", unit="milliseconds", absolute=true)
    public int getAllInUseInterval() {
        return this.allInUseInterval.orElseGet(() -> super.getAllInUseInterval());
    }

    @Override
    @Gauge(name="com.github.jonasrutishauser.transaction.event.max.dispatch.interval", description="Maximum interval between lookups for events to process", unit="seconds", absolute=true)
    public int getMaxDispatchInterval() {
        return this.maxDispatchInterval.orElseGet(() -> super.getMaxDispatchInterval());
    }

    @Override
    @Gauge(name="com.github.jonasrutishauser.transaction.event.initial.dispatch.interval", description="Initial interval between lookups for events to process", unit="seconds", absolute=true)
    public int getInitialDispatchInterval() {
        return this.initialDispatchInterval.orElseGet(() -> super.getInitialDispatchInterval());
    }

    @Override
    public String getTableName() {
        return this.tableName.orElseGet(() -> super.getTableName());
    }

    @Override
    @Gauge(name="com.github.jonasrutishauser.transaction.event.max.aquire", description="Maximum number of events aquired per query", unit="none", absolute=true)
    public int getMaxAquire() {
        return this.maxAquire.orElseGet(() -> super.getMaxAquire());
    }

    @Override
    @Gauge(name="com.github.jonasrutishauser.transaction.event.max.concurrent.dispatching", description="Maximum number of dispatched events being processed concurrently", unit="none", absolute=true)
    public int getMaxConcurrentDispatching() {
        return this.maxConcurrentDispatching.orElseGet(() -> super.getMaxConcurrentDispatching());
    }
}

