/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.core;

import com.github.jonasrutishauser.transactional.event.api.serialization.EventSerializer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
class Serializer {
    private final Map<Class<?>, EventSerializer<?>> serializers = new ConcurrentHashMap();

    Serializer() {
    }

    @Inject
    Serializer(@Any Instance<EventSerializer<?>> serializers) {
        for (EventSerializer serializer : serializers) {
            this.serializers.put(serializer.getType(), serializer);
        }
    }

    String serialize(Object event) {
        return this.serialize(this.getSerializer(event), event);
    }

    private <T> String serialize(EventSerializer<T> serializer, Object event) {
        return serializer.serialize(serializer.getType().cast(event));
    }

    private EventSerializer<?> getSerializer(Object event) {
        return this.serializers.computeIfAbsent(event.getClass(), this::getSerializer);
    }

    private EventSerializer<?> getSerializer(Class<?> eventType) {
        for (Class<?> type = eventType.getSuperclass(); type != null; type = type.getSuperclass()) {
            if (!this.serializers.containsKey(type)) continue;
            return this.serializers.get(type);
        }
        throw new IllegalArgumentException("Serializer not found for " + eventType.getName());
    }
}

