/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.core;

import com.github.jonasrutishauser.transactional.event.api.EventPublisher;
import com.github.jonasrutishauser.transactional.event.api.EventTypeResolver;
import com.github.jonasrutishauser.transactional.event.core.PendingEvent;
import com.github.jonasrutishauser.transactional.event.core.PublishedEvents;
import com.github.jonasrutishauser.transactional.event.core.Serializer;
import com.github.jonasrutishauser.transactional.event.core.random.Random;
import java.time.LocalDateTime;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Dependent
public class TransactionalEventPublisher
implements EventPublisher {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EventTypeResolver typeResolver;
    private final Serializer eventSerializer;
    private final PublishedEvents publishedEvents;

    TransactionalEventPublisher() {
        this(null, null, null);
    }

    @Inject
    TransactionalEventPublisher(EventTypeResolver typeResolver, Serializer eventSerializer, PublishedEvents publishedEvents) {
        this.typeResolver = typeResolver;
        this.eventSerializer = eventSerializer;
        this.publishedEvents = publishedEvents;
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    public void publish(Object event) {
        String id = Random.randomId();
        String type = this.typeResolver.resolve(event.getClass());
        String payload = this.eventSerializer.serialize(event);
        LocalDateTime publishedAt = LocalDateTime.now();
        PendingEvent pendingEvent = new PendingEvent(id, type, payload, publishedAt);
        this.publishedEvents.add(pendingEvent);
        LOGGER.debug("enqueued event '{}' with type '{}' (payload '{}')", (Object)id, (Object)type, (Object)payload);
    }
}

