/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.core.cdi;

import com.github.jonasrutishauser.transactional.event.api.EventTypeResolver;
import com.github.jonasrutishauser.transactional.event.api.handler.AbstractHandler;
import com.github.jonasrutishauser.transactional.event.api.handler.EventHandler;
import com.github.jonasrutishauser.transactional.event.api.handler.Handler;
import com.github.jonasrutishauser.transactional.event.api.serialization.EventDeserializer;
import com.github.jonasrutishauser.transactional.event.api.serialization.GenericSerialization;
import com.github.jonasrutishauser.transactional.event.core.cdi.DefaultEventDeserializer;
import com.github.jonasrutishauser.transactional.event.core.cdi.ExtendedEventDeserializer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionPoint;

public class EventHandlerExtension
implements Extension {
    private final Set<ParameterizedType> requiredEventDeserializers = new HashSet<ParameterizedType>();
    private final Set<Class<?>> genericSerializationEventTypes = new HashSet();
    private final Map<ParameterizedType, Class<? extends Handler>> handlerClass = new HashMap<ParameterizedType, Class<? extends Handler>>();

    public Optional<Class<? extends Handler>> getHandlerClassWithImplicitType(EventTypeResolver typeResolver, String type) {
        for (Map.Entry<ParameterizedType, Class<? extends Handler>> handlerClassEntry : this.handlerClass.entrySet()) {
            if (!type.equals(typeResolver.resolve((Class)handlerClassEntry.getKey().getActualTypeArguments()[0]))) continue;
            return Optional.of(handlerClassEntry.getValue());
        }
        return Optional.empty();
    }

    <T extends Handler> void processHandlers(@Observes @Priority(value=3000) ProcessBean<T> beanEvent) {
        if (!beanEvent.getAnnotated().isAnnotationPresent(EventHandler.class)) {
            beanEvent.addDefinitionError((Throwable)new IllegalStateException("EventHandler annotation is missing on bean " + beanEvent.getBean()));
        } else {
            EventHandler annotation = (EventHandler)beanEvent.getAnnotated().getAnnotation(EventHandler.class);
            Optional<ParameterizedType> abstractHandlerType = this.getAbstractHandlerType(beanEvent.getBean().getTypes());
            if ("#abstract-handler-type".equals(annotation.eventType())) {
                if (!abstractHandlerType.isPresent()) {
                    beanEvent.addDefinitionError((Throwable)new IllegalStateException("AbstractHandler type is missing on bean " + beanEvent.getBean() + " with implicit event type"));
                } else if (!beanEvent.getBean().getTypes().contains(beanEvent.getBean().getBeanClass())) {
                    beanEvent.addDefinitionError((Throwable)new IllegalStateException(beanEvent.getBean().getBeanClass().getSimpleName() + " type is missing on bean " + beanEvent.getBean() + " with implicit event type"));
                } else {
                    this.handlerClass.put(abstractHandlerType.get(), beanEvent.getBean().getBeanClass().asSubclass(Handler.class));
                }
            }
        }
    }

    <X extends EventDeserializer<?>> void processEventDeserializerInjections(@Observes ProcessInjectionPoint<?, X> event) {
        Type type = event.getInjectionPoint().getType();
        if (type instanceof ParameterizedType && EventDeserializer.class.equals((Object)((ParameterizedType)type).getRawType())) {
            this.requiredEventDeserializers.add((ParameterizedType)type);
        }
    }

    void addMissingEventDeserializers(@Observes @Priority(value=3000) AfterBeanDiscovery event, BeanManager beanManager) {
        for (ParameterizedType type : this.requiredEventDeserializers) {
            try {
                if (beanManager.resolve(beanManager.getBeans((Type)type, new Annotation[0])) != null) continue;
                Type eventType = type.getActualTypeArguments()[0];
                Class eventClass = eventType instanceof Class ? (Class)eventType : (Class)((ParameterizedType)eventType).getRawType();
                this.genericSerializationEventTypes.add(eventClass);
                event.addBean().addType((Type)type).addType(ExtendedEventDeserializer.class).scope(ApplicationScoped.class).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).produceWith(instance -> this.createDefaultEventDeserializer((Instance<GenericSerialization>)instance.select(GenericSerialization.class, new Annotation[0]), eventClass));
            }
            catch (AmbiguousResolutionException ambiguousResolutionException) {}
        }
    }

    void verifyGenericSerializationEventTypes(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        ArrayList serializations = new ArrayList();
        Instance instance = beanManager.createInstance().select(GenericSerialization.class, new Annotation[]{Any.Literal.INSTANCE});
        instance.forEach(serializations::add);
        for (Class<?> eventType : this.genericSerializationEventTypes) {
            if (!serializations.stream().noneMatch(s -> s.accepts(eventType))) continue;
            event.addDeploymentProblem((Throwable)new UnsatisfiedResolutionException("No GenericSerialization found for " + eventType));
        }
        serializations.forEach(arg_0 -> ((Instance)instance).destroy(arg_0));
    }

    private <T> DefaultEventDeserializer<T> createDefaultEventDeserializer(Instance<GenericSerialization> instance, Class<T> type) {
        ArrayList serializations = new ArrayList();
        instance.forEach(serializations::add);
        Collections.sort(serializations, Comparator.comparing(GenericSerialization::priority));
        DefaultEventDeserializer<T> result = null;
        for (GenericSerialization serialization : serializations) {
            if (result == null && serialization.accepts(type)) {
                result = new DefaultEventDeserializer<T>(type, serialization);
                continue;
            }
            instance.destroy((Object)serialization);
        }
        return result;
    }

    private Optional<ParameterizedType> getAbstractHandlerType(Set<Type> types) {
        return types.stream().filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(type -> AbstractHandler.class.equals((Object)type.getRawType())).findAny();
    }
}

