/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.core.serialization;

import com.github.jonasrutishauser.transactional.event.api.serialization.EventSerializer;
import com.github.jonasrutishauser.transactional.event.api.serialization.GenericSerialization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class DefaultEventSerializer
implements EventSerializer<Object> {
    private final List<GenericSerialization> serializers = new ArrayList<GenericSerialization>();

    DefaultEventSerializer() {
        this(Collections.emptyList());
    }

    @Inject
    DefaultEventSerializer(@Any Instance<GenericSerialization> serializers) {
        this((Iterable<GenericSerialization>)serializers);
    }

    private DefaultEventSerializer(Iterable<GenericSerialization> serializers) {
        serializers.forEach(this.serializers::add);
        Collections.sort(this.serializers, Comparator.comparing(GenericSerialization::priority));
    }

    public String serialize(Object event) {
        for (GenericSerialization serializer : this.serializers) {
            if (!serializer.accepts(event.getClass())) continue;
            return serializer.serialize(event);
        }
        throw new IllegalArgumentException("No GenericSerialization found for " + event.getClass());
    }
}

