/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.core.serialization;

import com.github.jonasrutishauser.transactional.event.api.serialization.GenericSerialization;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

@Priority(value=500)
@ApplicationScoped
public class JaxbSerialization
implements GenericSerialization {
    private final Map<Class<?>, JAXBContext> contexts = new ConcurrentHashMap();

    public boolean accepts(Class<?> type) {
        return type.getAnnotation(XmlType.class) != null || type.getAnnotation(XmlRootElement.class) != null;
    }

    public String serialize(Object event) {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = this.getContext(event.getClass()).createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal(this.getJaxbElement(event, event.getClass()), (Writer)writer);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public <T> T deserialize(String event, Class<T> type) {
        StringReader reader = new StringReader(event);
        try {
            Unmarshaller unmarshaller = this.getContext(type).createUnmarshaller();
            if (type.getAnnotation(XmlRootElement.class) != null) {
                return type.cast(unmarshaller.unmarshal((Reader)reader));
            }
            return (T)unmarshaller.unmarshal((Source)new StreamSource(reader), type).getValue();
        }
        catch (NoSuchMethodError | JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    private <T> Object getJaxbElement(Object event, Class<T> type) {
        if (type.getAnnotation(XmlRootElement.class) != null) {
            return event;
        }
        return new JAXBElement(new QName("event"), type, type.cast(event));
    }

    private JAXBContext getContext(Class<?> type) {
        return this.contexts.computeIfAbsent(type, this::newContext);
    }

    private JAXBContext newContext(Class<?> type) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{type});
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }
}

