/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.core.serialization;

import com.github.jonasrutishauser.transactional.event.api.serialization.GenericSerialization;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;

@Priority(value=2000)
@ApplicationScoped
public class JsonbSerialization
implements GenericSerialization {
    private final Jsonb jsonb;

    @Inject
    JsonbSerialization() {
        this(new JsonbConfig());
    }

    protected JsonbSerialization(JsonbConfig config) {
        this.jsonb = JsonbBuilder.create((JsonbConfig)config);
    }

    public boolean accepts(Class<?> type) {
        return true;
    }

    public String serialize(Object event) {
        return this.jsonb.toJson(event);
    }

    public <T> T deserialize(String event, Class<T> type) {
        return (T)this.jsonb.fromJson(event, type);
    }
}

