/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.core.store;

import com.github.jonasrutishauser.transactional.event.core.random.Random;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ApplicationScoped
class LockOwner {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Clock clock;
    private final String id;

    @Inject
    public LockOwner() {
        this(Clock.systemUTC(), Random.randomId());
    }

    LockOwner(Clock clock, String id) {
        this.id = id;
        LOGGER.info("using lock id: {}", (Object)id);
        this.clock = clock;
    }

    public String getId() {
        return this.id;
    }

    public long getUntilToProcess() {
        return Instant.now(this.clock).plus(5L, ChronoUnit.MINUTES).toEpochMilli();
    }

    public long getUntilForRetry(int tries, String eventId) {
        if (tries > 5) {
            LOGGER.info("max attempts used, event with id '{}' will be blocked", (Object)eventId);
            return Long.MAX_VALUE;
        }
        return Instant.now(this.clock).plusSeconds((long)(tries * tries) * 2L).toEpochMilli();
    }

    public long getMinUntilForAquire() {
        return Instant.now(this.clock).toEpochMilli();
    }

    public boolean isOwningForProcessing(String owner, long lockedUntil) {
        return this.id.equals(owner) && lockedUntil > Instant.now(this.clock).toEpochMilli();
    }
}

