/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.core.store;

import com.github.jonasrutishauser.transactional.event.api.Configuration;
import com.github.jonasrutishauser.transactional.event.api.Events;
import com.github.jonasrutishauser.transactional.event.api.store.BlockedEvent;
import com.github.jonasrutishauser.transactional.event.api.store.EventStore;
import com.github.jonasrutishauser.transactional.event.api.store.QueryAdapter;
import com.github.jonasrutishauser.transactional.event.core.PendingEvent;
import com.github.jonasrutishauser.transactional.event.core.store.EventsPublished;
import com.github.jonasrutishauser.transactional.event.core.store.LockOwner;
import com.github.jonasrutishauser.transactional.event.core.store.QueryAdapterFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntPredicate;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.event.TransactionPhase;
import javax.inject.Inject;
import javax.sql.DataSource;
import javax.transaction.Transactional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ApplicationScoped
class PendingEventStore
implements EventStore {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Configuration configuration;
    private final DataSource dataSource;
    private final QueryAdapterFactory queryAdapterFactory;
    private final LockOwner lockOwner;
    private String insertSQL;
    private String readSQL;
    private String deleteSQL;
    private String updateSQL;
    private String updateSQLwithLockOwner;
    private String aquireSQL;
    private String readBlockedSQL;
    private String readBlockedForUpdateSQL;

    PendingEventStore() {
        this(null, null, null, null);
    }

    @Inject
    PendingEventStore(Configuration configuration, @Events DataSource dataSource, QueryAdapterFactory queryAdapterFactory, LockOwner lockOwner) {
        this.configuration = configuration;
        this.dataSource = dataSource;
        this.queryAdapterFactory = queryAdapterFactory;
        this.lockOwner = lockOwner;
    }

    @PostConstruct
    void initSqlQueries() {
        QueryAdapter adapter = this.queryAdapterFactory.getQueryAdapter();
        this.insertSQL = "INSERT INTO " + this.configuration.getTableName() + " (id, event_type, payload, published_at, tries, lock_owner, locked_until) VALUES (?, ?, ?, ?, ?, ?, ?)";
        this.readSQL = "SELECT * FROM " + this.configuration.getTableName() + " WHERE id=? FOR UPDATE";
        this.deleteSQL = "DELETE FROM " + this.configuration.getTableName() + " WHERE id=? AND lock_owner=?";
        this.updateSQL = "UPDATE " + this.configuration.getTableName() + " SET tries=?, lock_owner=?, locked_until=? WHERE id=?";
        this.updateSQLwithLockOwner = this.updateSQL + " AND lock_owner=?";
        this.aquireSQL = adapter.fixLimits(adapter.addSkipLocked("SELECT id, tries FROM " + this.configuration.getTableName() + " WHERE locked_until<=? {LIMIT ?} FOR UPDATE"));
        String readBlocked = "SELECT * FROM " + this.configuration.getTableName() + " WHERE locked_until=" + Long.MAX_VALUE;
        this.readBlockedSQL = adapter.fixLimits(readBlocked + " {LIMIT ?}");
        this.readBlockedForUpdateSQL = adapter.addSkipLocked(readBlocked + " AND id=? FOR UPDATE");
    }

    @Transactional
    public boolean unblock(String eventId) {
        boolean result;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement readStatement = connection.prepareStatement(this.readBlockedForUpdateSQL);
             ResultSet resultSet = this.executeQuery(readStatement, eventId);
             PreparedStatement updateStatement = connection.prepareStatement(this.updateSQL);){
            if (resultSet.next()) {
                updateStatement.setInt(1, 0);
                updateStatement.setNull(2, 12);
                updateStatement.setLong(3, this.lockOwner.getUntilForRetry(0, eventId));
                updateStatement.setString(4, eventId);
                result = updateStatement.executeUpdate() > 0;
            } else {
                result = false;
            }
        }
        catch (SQLException exception) {
            LOGGER.error("failed to unblock event '{}'", (Object)eventId, (Object)exception);
            result = false;
        }
        return result;
    }

    @Transactional
    public Collection<BlockedEvent> getBlockedEvents(int maxElements) {
        ArrayList<BlockedEvent> result = new ArrayList<BlockedEvent>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.readBlockedSQL);
             ResultSet resultSet = this.executeQuery(statement, maxElements);){
            while (resultSet.next()) {
                result.add(new BlockedEvent(resultSet.getString("id"), resultSet.getString("event_type"), resultSet.getString("payload"), resultSet.getTimestamp("published_at").toLocalDateTime()));
            }
        }
        catch (SQLException exception) {
            LOGGER.error("failed to read blocked events", (Throwable)exception);
        }
        return result;
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    void store(@Observes(during=TransactionPhase.BEFORE_COMPLETION) EventsPublished events) {
        String errorMessage = "failed to insert pending events";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.insertSQL);){
            for (PendingEvent event : events.getEvents()) {
                statement.setString(1, event.getId());
                statement.setString(2, event.getType());
                statement.setString(3, event.getPayload());
                statement.setTimestamp(4, Timestamp.valueOf(event.getPublishedAt()));
                statement.setInt(5, event.getTries());
                statement.setString(6, this.lockOwner.getId());
                statement.setLong(7, this.lockOwner.getUntilToProcess());
                statement.addBatch();
            }
            int[] result = statement.executeBatch();
            if (result.length != events.getEvents().size() || Arrays.stream(result).anyMatch(this.updateCountIsNot(1))) {
                LOGGER.error("failed to insert pending events (results: {})", (Object)result);
                throw new IllegalStateException(errorMessage);
            }
        }
        catch (SQLException exception) {
            LOGGER.error(errorMessage, (Throwable)exception);
            throw new IllegalStateException(errorMessage, exception);
        }
    }

    /*
     * Exception decompiling
     */
    @Transactional(value=Transactional.TxType.MANDATORY, dontRollbackOn={NoSuchElementException.class})
    public PendingEvent getAndLockEvent(String id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    public void delete(PendingEvent event) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.deleteSQL);){
            statement.setString(1, event.getId());
            statement.setString(2, this.lockOwner.getId());
            statement.setQueryTimeout(10);
            if (statement.executeUpdate() < 1) {
                throw new NoSuchElementException("failed to delete pending event with id " + event.getId());
            }
        }
        catch (SQLException exception) {
            String errorMessage = "failed to delete pending event with id " + event.getId();
            LOGGER.error(errorMessage, (Throwable)exception);
            throw new IllegalStateException(errorMessage);
        }
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    public void updateForRetry(PendingEvent event) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.updateSQLwithLockOwner);){
            statement.setInt(1, event.getTries() + 1);
            statement.setNull(2, 12);
            statement.setLong(3, this.lockOwner.getUntilForRetry(event.getTries(), event.getId()));
            statement.setString(4, event.getId());
            statement.setString(5, this.lockOwner.getId());
            statement.setQueryTimeout(10);
            if (statement.executeUpdate() < 1) {
                throw new NoSuchElementException("failed to update pending event with id " + event.getId());
            }
        }
        catch (SQLException exception) {
            String errorMessage = "failed to update pending event with id " + event.getId();
            LOGGER.error(errorMessage, (Throwable)exception);
            throw new IllegalStateException(errorMessage);
        }
    }

    @Transactional
    public Set<String> aquire() {
        Set<Object> result = new HashSet();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement aquireStatement = connection.prepareStatement(this.aquireSQL);
             ResultSet resultSet = this.executeQuery(aquireStatement, this.lockOwner.getMinUntilForAquire(), this.configuration.getMaxAquire());
             PreparedStatement updateStatement = connection.prepareStatement(this.updateSQL);){
            int[] res;
            while (resultSet.next()) {
                result.add(resultSet.getString("id"));
                updateStatement.setInt(1, resultSet.getInt("tries"));
                updateStatement.setString(2, this.lockOwner.getId());
                updateStatement.setLong(3, this.lockOwner.getUntilToProcess());
                updateStatement.setString(4, resultSet.getString("id"));
                updateStatement.addBatch();
            }
            if (!result.isEmpty() && ((res = updateStatement.executeBatch()).length != result.size() || Arrays.stream(res).anyMatch(this.updateCountIsNot(1)))) {
                LOGGER.warn("failed to aquire pending events (update failed; results: {})", (Object)res);
                result = Collections.emptySet();
            }
        }
        catch (SQLException exception) {
            LOGGER.warn("failed to aquire pending events", (Throwable)exception);
            result = Collections.emptySet();
        }
        return result;
    }

    private IntPredicate updateCountIsNot(int expected) {
        return count -> count != expected && count != -2;
    }

    private ResultSet executeQuery(PreparedStatement statement, String stringParam) throws SQLException {
        statement.setString(1, stringParam);
        return statement.executeQuery();
    }

    private ResultSet executeQueryWithTimeout(PreparedStatement statement, String stringParam, int seconds) throws SQLException {
        statement.setString(1, stringParam);
        statement.setQueryTimeout(seconds);
        return statement.executeQuery();
    }

    private ResultSet executeQuery(PreparedStatement statement, int intParam) throws SQLException {
        statement.setInt(1, intParam);
        return statement.executeQuery();
    }

    private ResultSet executeQuery(PreparedStatement statement, long param1, int param2) throws SQLException {
        statement.setLong(1, param1);
        statement.setInt(2, param2);
        return statement.executeQuery();
    }
}

