/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.core.store;

import com.github.jonasrutishauser.transactional.event.api.Events;
import com.github.jonasrutishauser.transactional.event.api.store.QueryAdapter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.TransientReference;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ApplicationScoped
class QueryAdapterFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private final QueryAdapter queryAdapter;

    public QueryAdapter getQueryAdapter() {
        return this.queryAdapter;
    }

    QueryAdapterFactory() {
        this.queryAdapter = null;
    }

    QueryAdapterFactory(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.queryAdapter = QueryAdapterFactory.getQueryAdapter(connection);
        }
    }

    @Inject
    QueryAdapterFactory(Instance<QueryAdapter> cdiInstance, @TransientReference @Events DataSource dataSource) {
        block15: {
            if (cdiInstance.isUnsatisfied()) {
                try (Connection connection = dataSource.getConnection();){
                    this.queryAdapter = QueryAdapterFactory.getQueryAdapter(connection);
                    break block15;
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.queryAdapter = (QueryAdapter)cdiInstance.get();
        }
    }

    private static QueryAdapter getQueryAdapter(Connection connection) throws SQLException {
        HashSet<String> keywords;
        String productName = connection.getMetaData().getDatabaseProductName();
        SimpleQueryAdapter queryAdapter = productName.contains("Oracle") ? new OracleQueryAdapter() : (productName.contains("MariaDB") ? new MariaDBQueryAdapter() : (productName.contains("PostgreSQL") || productName.contains("MySQL") ? new LimitQueryAdapter() : ((keywords = new HashSet<String>(Arrays.asList(connection.getMetaData().getSQLKeywords().split(",")))).contains("skip") && keywords.contains("locked") ? new SkipLockedQueryAdapter() : new SimpleQueryAdapter())));
        LOGGER.debug(() -> "DB '" + productName + "' uses " + queryAdapter.getClass().getSimpleName());
        return queryAdapter;
    }

    private static class LimitQueryAdapter
    extends SkipLockedQueryAdapter {
        private LimitQueryAdapter() {
        }

        @Override
        public String fixLimits(String sql) {
            return sql.replaceAll("\\{LIMIT ([^}]+)\\}", "LIMIT $1");
        }
    }

    private static class MariaDBQueryAdapter
    extends SimpleQueryAdapter {
        private MariaDBQueryAdapter() {
        }

        @Override
        public String fixLimits(String sql) {
            return sql.replaceAll("\\{LIMIT ([^}]+)\\}", "LIMIT $1");
        }
    }

    private static class OracleQueryAdapter
    extends SkipLockedQueryAdapter {
        private OracleQueryAdapter() {
        }

        @Override
        public String fixLimits(String sql) {
            return sql.replaceAll("\\{LIMIT ([^}]+)\\}", "AND rownum <= $1");
        }
    }

    private static class SkipLockedQueryAdapter
    extends SimpleQueryAdapter {
        private SkipLockedQueryAdapter() {
        }

        @Override
        public String addSkipLocked(String sql) {
            return sql.replace("FOR UPDATE", "FOR UPDATE SKIP LOCKED");
        }
    }

    private static class SimpleQueryAdapter
    implements QueryAdapter {
        protected static final String LIMIT_EXPRESSION = "\\{LIMIT ([^}]+)\\}";

        private SimpleQueryAdapter() {
        }

        public String fixLimits(String sql) {
            return sql;
        }

        public String addSkipLocked(String sql) {
            return sql;
        }
    }
}

