/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.core.store;

import com.github.jonasrutishauser.transactional.event.api.EventTypeResolver;
import com.github.jonasrutishauser.transactional.event.api.handler.EventHandler;
import com.github.jonasrutishauser.transactional.event.api.handler.Handler;
import com.github.jonasrutishauser.transactional.event.core.PendingEvent;
import com.github.jonasrutishauser.transactional.event.core.cdi.EventHandlerExtension;
import com.github.jonasrutishauser.transactional.event.core.store.PendingEventStore;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.transaction.Transactional;

@Dependent
class TransactionalWorker {
    private final PendingEventStore store;
    private final Instance<Handler> handlers;
    private final EventHandlerExtension handlerExtension;
    private final EventTypeResolver typeResolver;

    TransactionalWorker() {
        this(null, null, null, null);
    }

    @Inject
    TransactionalWorker(PendingEventStore store, @Any Instance<Handler> handlers, EventHandlerExtension handlerExtension, EventTypeResolver typeResolver) {
        this.store = store;
        this.handlers = handlers;
        this.handlerExtension = handlerExtension;
        this.typeResolver = typeResolver;
    }

    @Transactional
    public void process(String eventId) {
        final PendingEvent event = this.store.getAndLockEvent(eventId);
        Optional<Class<? extends Handler>> handlerClassWithImplicitType = this.handlerExtension.getHandlerClassWithImplicitType(this.typeResolver, event.getType());
        Instance handlerInstance = handlerClassWithImplicitType.isPresent() ? this.handlers.select(handlerClassWithImplicitType.get(), new Annotation[0]) : this.handlers.select(new Annotation[]{new EventHandlerLiteral(){

            public String eventType() {
                return event.getType();
            }
        }});
        this.process(event, handlerInstance);
        this.store.delete(event);
    }

    @Transactional
    public void processFailed(String eventId) {
        PendingEvent event = this.store.getAndLockEvent(eventId);
        this.store.updateForRetry(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Handler> void process(PendingEvent event, Instance<T> handlerInstance) {
        Handler handler = (Handler)handlerInstance.get();
        try {
            handler.handle(event.getPayload());
        }
        finally {
            handlerInstance.destroy((Object)handler);
        }
    }

    private static abstract class EventHandlerLiteral
    extends AnnotationLiteral<EventHandler>
    implements EventHandler {
        private EventHandlerLiteral() {
        }
    }
}

