/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonasrutishauser.transactional.event.core.store;

import com.github.jonasrutishauser.transactional.event.core.store.TransactionalWorker;
import com.github.jonasrutishauser.transactional.event.core.store.Worker;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.control.ActivateRequestContext;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Dependent
class WorkerImpl
implements Worker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TransactionalWorker transactional;

    @Inject
    WorkerImpl(TransactionalWorker transactional) {
        this.transactional = transactional;
    }

    @Override
    @ActivateRequestContext
    public boolean process(String eventId) {
        try {
            LOGGER.debug("processing event with id '{}'", (Object)eventId);
            this.transactional.process(eventId);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to process event with id '{}'", (Object)eventId, (Object)e);
            this.transactional.processFailed(eventId);
            return false;
        }
    }
}

