/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import argonaut.Argonaut$;
import argonaut.Json;
import argonaut.Parse$;
import java.io.Serializable;
import java.time.Clock;
import pdi.jwt.JwtArgonaut$;
import pdi.jwt.JwtArgonautParser;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtClaim$;
import pdi.jwt.JwtHeader;
import pdi.jwt.JwtHeader$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class JwtArgonaut
implements JwtArgonautParser<JwtHeader, JwtClaim> {
    private final Clock clock;
    private final List<String> jwtSpecificFieldNames;

    public static JwtArgonaut apply(Clock clock) {
        return JwtArgonaut$.MODULE$.apply(clock);
    }

    public JwtArgonaut(Clock clock) {
        this.clock = clock;
        this.jwtSpecificFieldNames = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"iss", "sub", "aud", "exp", "nbf", "iat", "jti"}));
    }

    public Clock clock() {
        return this.clock;
    }

    public JwtClaim parseClaim(String claim) {
        return this.parseClaimHelp(claim);
    }

    public JwtHeader parseHeader(String header) {
        return this.parseHeaderHelp(header);
    }

    public final ExtractJsonFieldToType ExtractJsonFieldToType(Json json) {
        return new ExtractJsonFieldToType(this, json);
    }

    private JwtClaim parseClaimHelp(String claim) {
        JwtClaim jwtClaim;
        Option option = Parse$.MODULE$.parseOption((Object)claim);
        if (option instanceof Some) {
            Json value = (Json)((Some)option).value();
            jwtClaim = this.jsonToJwtClaim(value);
        } else if (None$.MODULE$.equals(option)) {
            jwtClaim = JwtClaim$.MODULE$.apply(JwtClaim$.MODULE$.apply$default$1(), JwtClaim$.MODULE$.apply$default$2(), JwtClaim$.MODULE$.apply$default$3(), JwtClaim$.MODULE$.apply$default$4(), JwtClaim$.MODULE$.apply$default$5(), JwtClaim$.MODULE$.apply$default$6(), JwtClaim$.MODULE$.apply$default$7(), JwtClaim$.MODULE$.apply$default$8());
        } else {
            throw new MatchError((Object)option);
        }
        return jwtClaim;
    }

    private JwtHeader parseHeaderHelp(String header) {
        JwtHeader jwtHeader;
        Option option = Parse$.MODULE$.parseOption((Object)header).map((Function1 & Serializable)json -> this.jsonToJwtHeader((Json)json));
        if (option instanceof Some) {
            JwtHeader value;
            jwtHeader = value = (JwtHeader)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            jwtHeader = JwtHeader$.MODULE$.apply((Option)None$.MODULE$);
        } else {
            throw new MatchError((Object)option);
        }
        return jwtHeader;
    }

    private JwtHeader jsonToJwtHeader(Json json) {
        Option alg = this.getAlgorithm(json);
        Option<String> typ = this.ExtractJsonFieldToType(json).$minus$bar$greater$greater("typ");
        Option<String> contentType = this.ExtractJsonFieldToType(json).$minus$bar$greater$greater("cty");
        Option<String> keyId = this.ExtractJsonFieldToType(json).$minus$bar$greater$greater("kid");
        return JwtHeader$.MODULE$.apply(alg, typ, contentType, keyId);
    }

    private JwtClaim jsonToJwtClaim(Json json) {
        Option<String> issuer = this.ExtractJsonFieldToType(json).$minus$bar$greater$greater("iss");
        Option<String> subject = this.ExtractJsonFieldToType(json).$minus$bar$greater$greater("sub");
        Option<Set<String>> audience = this.ExtractJsonFieldToType(json).$minus$bar$bar$bar("aud");
        Option<Object> expiration = this.ExtractJsonFieldToType(json).$minus$bar$bar$greater("exp");
        Option<Object> notBefore = this.ExtractJsonFieldToType(json).$minus$bar$bar$greater("nbf");
        Option<Object> issuedAt = this.ExtractJsonFieldToType(json).$minus$bar$bar$greater("iat");
        Option<String> jwtId = this.ExtractJsonFieldToType(json).$minus$bar$greater$greater("jti");
        Json content = (Json)json.objectFieldsOrEmpty().filterNot((Function1 & Serializable)elem -> this.jwtSpecificFieldNames.contains(elem)).map((Function1 & Serializable)field -> Tuple2$.MODULE$.apply(field, json.$minus$bar(() -> JwtArgonaut.$anonfun$4$$anonfun$1(field)).get())).foldRight((Object)Argonaut$.MODULE$.jEmptyObject(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                throw new MatchError((Object)tuple22);
            }
            String fieldName = (String)tuple2._1();
            Json field = (Json)tuple2._2();
            Json obj = (Json)tuple22._2();
            Tuple2 tuple23 = Argonaut$.MODULE$.StringToStringWrap(fieldName).$colon$eq((Object)field, Argonaut$.MODULE$.JsonEncodeJson());
            return obj.$minus$greater$colon(tuple23);
        });
        return JwtClaim$.MODULE$.apply(content.nospaces(), issuer, subject, audience, expiration, notBefore, issuedAt, jwtId);
    }

    public static final String pdi$jwt$JwtArgonaut$ExtractJsonFieldToType$$_$$minus$bar$greater$$anonfun$1(String field$1) {
        return field$1;
    }

    public static final /* synthetic */ String pdi$jwt$JwtArgonaut$ExtractJsonFieldToType$$_$$minus$bar$greater$greater$$anonfun$1(Json _$3) {
        return _$3.stringOrEmpty();
    }

    public static final /* synthetic */ long pdi$jwt$JwtArgonaut$ExtractJsonFieldToType$$_$$minus$bar$bar$greater$$anonfun$1(Json _$4) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$4.nospaces()));
    }

    public static final /* synthetic */ Set pdi$jwt$JwtArgonaut$ExtractJsonFieldToType$$_$$minus$bar$bar$bar$$anonfun$1(Json _$5) {
        return _$5.arrayOrEmpty().map((Function1 & Serializable)_$6 -> _$6.nospaces()).toSet();
    }

    private static final String $anonfun$4$$anonfun$1(String field$2) {
        return field$2;
    }

    public class ExtractJsonFieldToType {
        private final Json json;
        private final JwtArgonaut $outer;

        public ExtractJsonFieldToType(JwtArgonaut $outer, Json json) {
            this.json = json;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public <T> Option<T> $minus$bar$greater(String field, Function1<Json, T> f) {
            return this.json.$minus$bar(() -> JwtArgonaut.pdi$jwt$JwtArgonaut$ExtractJsonFieldToType$$_$$minus$bar$greater$$anonfun$1(field)).map(f);
        }

        public Option<String> $minus$bar$greater$greater(String field) {
            return this.$outer.ExtractJsonFieldToType(this.json).$minus$bar$greater(field, JwtArgonaut::pdi$jwt$JwtArgonaut$ExtractJsonFieldToType$$_$$minus$bar$greater$greater$$anonfun$1);
        }

        public Option<Object> $minus$bar$bar$greater(String field) {
            return this.$outer.ExtractJsonFieldToType(this.json).$minus$bar$greater(field, JwtArgonaut::pdi$jwt$JwtArgonaut$ExtractJsonFieldToType$$_$$minus$bar$bar$greater$$anonfun$1);
        }

        public Option<Set<String>> $minus$bar$bar$bar(String field) {
            return this.$outer.ExtractJsonFieldToType(this.json).$minus$bar$greater(field, JwtArgonaut::pdi$jwt$JwtArgonaut$ExtractJsonFieldToType$$_$$minus$bar$bar$bar$$anonfun$1);
        }

        public final JwtArgonaut pdi$jwt$JwtArgonaut$ExtractJsonFieldToType$$$outer() {
            return this.$outer;
        }
    }
}

