/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import java.time.Clock;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$;
import pdi.jwt.JwtAlgorithm$HS256$;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtClaim$;
import pdi.jwt.JwtHeader;
import pdi.jwt.JwtHeader$;
import pdi.jwt.JwtJson$;
import pdi.jwt.JwtJsonImplicits;
import pdi.jwt.JwtJsonParser;
import pdi.jwt.JwtOptions;
import pdi.jwt.JwtOptions$;
import pdi.jwt.JwtPlayImplicits;
import pdi.jwt.JwtSession;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.UninitializedFieldError;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public final class JwtSession$
implements JwtJsonImplicits,
JwtPlayImplicits,
Serializable {
    public static final JwtSession$ MODULE$ = new JwtSession$();
    private static Reads<JwtClaim> jwtPlayJsonClaimReader;
    private static Writes<JwtClaim> jwtPlayJsonClaimWriter;
    private static Reads<JwtHeader> jwtPlayJsonHeaderReader;
    private static Writes<JwtHeader> jwtPlayJsonHeaderWriter;
    private static volatile byte bitmap$init$0;

    static {
        JwtJsonImplicits.$init$((JwtJsonImplicits)MODULE$);
        JwtPlayImplicits.$init$(MODULE$);
    }

    @Override
    public JwtPlayImplicits.RichResult RichResult(Result result, Configuration conf, Clock clock) {
        return JwtPlayImplicits.RichResult$(this, result, conf, clock);
    }

    @Override
    public JwtPlayImplicits.RichRequestHeader RichRequestHeader(RequestHeader request, Configuration conf, Clock clock) {
        return JwtPlayImplicits.RichRequestHeader$(this, request, conf, clock);
    }

    public JwtJsonImplicits.RichJwtClaim RichJwtClaim(JwtClaim claim) {
        return JwtJsonImplicits.RichJwtClaim$((JwtJsonImplicits)this, (JwtClaim)claim);
    }

    public JwtJsonImplicits.RichJwtHeader RichJwtHeader(JwtHeader header) {
        return JwtJsonImplicits.RichJwtHeader$((JwtJsonImplicits)this, (JwtHeader)header);
    }

    public Reads<JwtClaim> jwtPlayJsonClaimReader() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/eloisant/Code/jwt-scala/play/src/main/scala/JwtSession.scala: 99");
        }
        return jwtPlayJsonClaimReader;
    }

    public Writes<JwtClaim> jwtPlayJsonClaimWriter() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/eloisant/Code/jwt-scala/play/src/main/scala/JwtSession.scala: 99");
        }
        return jwtPlayJsonClaimWriter;
    }

    public Reads<JwtHeader> jwtPlayJsonHeaderReader() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/eloisant/Code/jwt-scala/play/src/main/scala/JwtSession.scala: 99");
        }
        return jwtPlayJsonHeaderReader;
    }

    public Writes<JwtHeader> jwtPlayJsonHeaderWriter() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/eloisant/Code/jwt-scala/play/src/main/scala/JwtSession.scala: 99");
        }
        return jwtPlayJsonHeaderWriter;
    }

    public void pdi$jwt$JwtJsonImplicits$_setter_$jwtPlayJsonClaimReader_$eq(Reads<JwtClaim> x$1) {
        jwtPlayJsonClaimReader = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
    }

    public void pdi$jwt$JwtJsonImplicits$_setter_$jwtPlayJsonClaimWriter_$eq(Writes<JwtClaim> x$1) {
        jwtPlayJsonClaimWriter = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
    }

    public void pdi$jwt$JwtJsonImplicits$_setter_$jwtPlayJsonHeaderReader_$eq(Reads<JwtHeader> x$1) {
        jwtPlayJsonHeaderReader = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
    }

    public void pdi$jwt$JwtJsonImplicits$_setter_$jwtPlayJsonHeaderWriter_$eq(Writes<JwtHeader> x$1) {
        jwtPlayJsonHeaderWriter = x$1;
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
    }

    public String REQUEST_HEADER_NAME(Configuration conf) {
        return (String)conf.getOptional("play.http.session.jwtName", ConfigLoader$.MODULE$.stringLoader()).getOrElse((Function0 & Serializable)() -> "Authorization");
    }

    public String RESPONSE_HEADER_NAME(Configuration conf) {
        return (String)conf.getOptional("play.http.session.jwtResponseName", ConfigLoader$.MODULE$.stringLoader()).getOrElse((Function0 & Serializable)() -> MODULE$.REQUEST_HEADER_NAME(conf));
    }

    public Option<Object> MAX_AGE(Configuration conf) {
        return conf.getOptional("play.http.session.maxAge", ConfigLoader$.MODULE$.durationLoader()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.toSeconds()));
    }

    public JwtAlgorithm ALGORITHM(Configuration conf) {
        return (JwtAlgorithm)conf.getOptional("play.http.session.algorithm", ConfigLoader$.MODULE$.stringLoader()).map((Function1 & Serializable)algo -> JwtAlgorithm$.MODULE$.fromString(algo)).getOrElse((Function0 & Serializable)() -> JwtAlgorithm$HS256$.MODULE$);
    }

    public String TOKEN_PREFIX(Configuration conf) {
        return (String)conf.getOptional("play.http.session.tokenPrefix", ConfigLoader$.MODULE$.stringLoader()).getOrElse((Function0 & Serializable)() -> "Bearer ");
    }

    private Option<String> secretKey(Configuration conf) {
        return conf.getOptional("play.http.secret.key", ConfigLoader$.MODULE$.stringLoader());
    }

    private Option<String> privateKey(Configuration conf) {
        return conf.getOptional("play.http.session.privateKey", ConfigLoader$.MODULE$.stringLoader());
    }

    private Option<String> publicKey(Configuration conf) {
        return conf.getOptional("play.http.session.publicKey", ConfigLoader$.MODULE$.stringLoader());
    }

    public Option<String> pdi$jwt$JwtSession$$signingKey(Configuration conf) {
        JwtAlgorithm jwtAlgorithm = this.ALGORITHM(conf);
        Option option = jwtAlgorithm instanceof JwtAsymmetricAlgorithm ? this.privateKey(conf).orElse((Function0 & Serializable)() -> MODULE$.secretKey(conf)) : (jwtAlgorithm instanceof JwtHmacAlgorithm ? this.secretKey(conf) : Option$.MODULE$.empty());
        return option;
    }

    /*
     * Enabled aggressive block sorting
     */
    public JwtSession deserialize(String token, JwtOptions options, Configuration conf, Clock clock) {
        Try try_;
        Tuple3 tuple3 = new Tuple3((Object)this.ALGORITHM(conf), this.secretKey(conf), this.publicKey(conf));
        if (tuple3 != null) {
            JwtAlgorithm algorithm = (JwtAlgorithm)tuple3._1();
            Option option = (Option)tuple3._2();
            if (algorithm instanceof JwtHmacAlgorithm) {
                JwtHmacAlgorithm jwtHmacAlgorithm = (JwtHmacAlgorithm)algorithm;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String sk = (String)some.value();
                    try_ = this.jwtJson(clock).decodeJsonAll(token, sk, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JwtHmacAlgorithm[]{jwtHmacAlgorithm})), options);
                    return (JwtSession)try_.map((Function1 & Serializable)tuple -> new JwtSession((JsObject)tuple._1(), (JsObject)tuple._2(), (String)tuple._3(), conf, clock)).getOrElse((Function0 & Serializable)() -> MODULE$.apply((Seq<Tuple2<String, Json.JsValueWrapper>>)Nil$.MODULE$, conf, clock));
                }
            }
        }
        if (tuple3 != null) {
            JwtAlgorithm algorithm = (JwtAlgorithm)tuple3._1();
            Option option = (Option)tuple3._3();
            if (algorithm instanceof JwtAsymmetricAlgorithm) {
                JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm = (JwtAsymmetricAlgorithm)algorithm;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String pk = (String)some.value();
                    try_ = this.jwtJson(clock).decodeJsonAll(token, pk, (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JwtAsymmetricAlgorithm[]{jwtAsymmetricAlgorithm})), options);
                    return (JwtSession)try_.map((Function1 & Serializable)tuple -> new JwtSession((JsObject)tuple._1(), (JsObject)tuple._2(), (String)tuple._3(), conf, clock)).getOrElse((Function0 & Serializable)() -> MODULE$.apply((Seq<Tuple2<String, Json.JsValueWrapper>>)Nil$.MODULE$, conf, clock));
                }
            }
        }
        try_ = this.jwtJson(clock).decodeJsonAll(token, options);
        return (JwtSession)try_.map((Function1 & Serializable)tuple -> new JwtSession((JsObject)tuple._1(), (JsObject)tuple._2(), (String)tuple._3(), conf, clock)).getOrElse((Function0 & Serializable)() -> MODULE$.apply((Seq<Tuple2<String, Json.JsValueWrapper>>)Nil$.MODULE$, conf, clock));
    }

    private JwtJsonParser<JwtHeader, JwtClaim> jwtJson(Clock clock) {
        return clock == JwtJson$.MODULE$.clock() ? JwtJson$.MODULE$ : JwtJson$.MODULE$.apply(clock);
    }

    public JwtSession deserialize(String token, Configuration conf, Clock clock) {
        return this.deserialize(token, JwtOptions$.MODULE$.DEFAULT(), conf, clock);
    }

    public <A> JsObject pdi$jwt$JwtSession$$asJsObject(A value, Writes<A> writer) {
        JsObject jsObject;
        JsValue jsValue = writer.writes(value);
        JsObject jsObject2 = jsValue instanceof JsObject ? (jsObject = (JsObject)jsValue) : Json$.MODULE$.obj((Seq)Nil$.MODULE$);
        return jsObject2;
    }

    public JwtHeader defaultHeader(Configuration conf) {
        return (JwtHeader)this.pdi$jwt$JwtSession$$signingKey(conf).map((Function1 & Serializable)x$2 -> JwtHeader$.MODULE$.apply(MODULE$.ALGORITHM(conf))).getOrElse((Function0 & Serializable)() -> JwtHeader$.MODULE$.apply(JwtHeader$.MODULE$.apply$default$1(), JwtHeader$.MODULE$.apply$default$2(), JwtHeader$.MODULE$.apply$default$3(), JwtHeader$.MODULE$.apply$default$4()));
    }

    public JwtClaim defaultClaim(Configuration conf, Clock clock) {
        JwtClaim jwtClaim;
        Option<Object> option = this.MAX_AGE(conf);
        if (option instanceof Some) {
            Some some = (Some)option;
            long seconds = BoxesRunTime.unboxToLong((Object)some.value());
            jwtClaim = JwtClaim$.MODULE$.apply(JwtClaim$.MODULE$.apply$default$1(), JwtClaim$.MODULE$.apply$default$2(), JwtClaim$.MODULE$.apply$default$3(), JwtClaim$.MODULE$.apply$default$4(), JwtClaim$.MODULE$.apply$default$5(), JwtClaim$.MODULE$.apply$default$6(), JwtClaim$.MODULE$.apply$default$7(), JwtClaim$.MODULE$.apply$default$8()).expiresIn(seconds, clock);
        } else {
            jwtClaim = JwtClaim$.MODULE$.apply(JwtClaim$.MODULE$.apply$default$1(), JwtClaim$.MODULE$.apply$default$2(), JwtClaim$.MODULE$.apply$default$3(), JwtClaim$.MODULE$.apply$default$4(), JwtClaim$.MODULE$.apply$default$5(), JwtClaim$.MODULE$.apply$default$6(), JwtClaim$.MODULE$.apply$default$7(), JwtClaim$.MODULE$.apply$default$8());
        }
        return jwtClaim;
    }

    public JwtSession apply(JsObject jsClaim, Configuration conf, Clock clock) {
        return this.apply(this.pdi$jwt$JwtSession$$asJsObject(this.defaultHeader(conf), this.jwtPlayJsonHeaderWriter()), jsClaim, conf, clock);
    }

    public JwtSession apply(Seq<Tuple2<String, Json.JsValueWrapper>> fields, Configuration conf, Clock clock) {
        return fields.isEmpty() ? this.apply(this.defaultHeader(conf), JwtClaim$.MODULE$.apply(JwtClaim$.MODULE$.apply$default$1(), JwtClaim$.MODULE$.apply$default$2(), JwtClaim$.MODULE$.apply$default$3(), JwtClaim$.MODULE$.apply$default$4(), JwtClaim$.MODULE$.apply$default$5(), JwtClaim$.MODULE$.apply$default$6(), JwtClaim$.MODULE$.apply$default$7(), JwtClaim$.MODULE$.apply$default$8()), conf, clock) : this.apply(Json$.MODULE$.obj(fields), conf, clock);
    }

    public JwtSession apply(JsObject jsHeader, JsObject jsClaim, Configuration conf, Clock clock) {
        return new JwtSession(jsHeader, jsClaim, "", conf, clock).refresh();
    }

    public JwtSession apply(JwtClaim claim, Configuration conf, Clock clock) {
        return this.apply(this.defaultHeader(conf), claim, conf, clock);
    }

    public JwtSession apply(JwtHeader header, JwtClaim claim, Configuration conf, Clock clock) {
        return new JwtSession(this.pdi$jwt$JwtSession$$asJsObject(header, this.jwtPlayJsonHeaderWriter()), this.pdi$jwt$JwtSession$$asJsObject(claim, this.jwtPlayJsonClaimWriter()), "", conf, clock).refresh();
    }

    public JwtSession apply(JwtHeader header, JwtClaim claim, String signature, Configuration conf, Clock clock) {
        return new JwtSession(this.pdi$jwt$JwtSession$$asJsObject(header, this.jwtPlayJsonHeaderWriter()), this.pdi$jwt$JwtSession$$asJsObject(claim, this.jwtPlayJsonClaimWriter()), signature, conf, clock).refresh();
    }

    public JwtSession apply(JsObject headerData, JsObject claimData, String signature, Configuration conf, Clock clock) {
        return new JwtSession(headerData, claimData, signature, conf, clock);
    }

    public Option<Tuple3<JsObject, JsObject, String>> unapply(JwtSession x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.headerData(), (Object)x$0.claimData(), (Object)x$0.signature()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JwtSession$.class);
    }

    private JwtSession$() {
    }
}

