/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.mapping;

import com.github.kaklakariada.fritzbox.mapping.DeserializerException;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deserializer {
    private static final Logger LOG = LoggerFactory.getLogger(Deserializer.class);
    private final Serializer xmlSerializer;

    public Deserializer() {
        this((Serializer)new Persister());
    }

    Deserializer(Serializer xmlSerializer) {
        this.xmlSerializer = xmlSerializer;
    }

    public <T> T parse(String data, Class<T> resultType) {
        if (resultType == String.class) {
            return resultType.cast(data);
        }
        if (resultType == Boolean.class) {
            return resultType.cast("1".equals(data));
        }
        if (resultType == Integer.class) {
            if (data.isEmpty() || "inval".equals(data)) {
                return null;
            }
            return resultType.cast(Integer.parseInt(data));
        }
        try {
            Object object = this.xmlSerializer.read(resultType, data);
            LOG.trace("Parsed response: {}", object);
            return (T)object;
        }
        catch (Exception e) {
            throw new DeserializerException("Error parsing response body '" + data + "'", e);
        }
    }
}

