/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.model.homeautomation;

import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Root(name="switch")
public class SwitchState {
    private static final Logger LOG = LoggerFactory.getLogger(SwitchState.class);
    @Element(name="state", required=false)
    private String state;
    @Element(name="mode", required=false)
    private String mode;
    @Element(name="lock", required=false)
    private String lock;
    @Element(name="devicelock", required=false)
    private String devicelock;

    boolean isNull() {
        return this.state == null || this.mode == null || this.lock == null;
    }

    public boolean isOn() {
        return "1".equals(this.state);
    }

    public boolean isLocked() {
        return "1".equals(this.lock);
    }

    public boolean isDeviceLocked() {
        return "1".equals(this.devicelock);
    }

    public SwitchMode getMode() {
        if (this.mode == null) {
            LOG.warn("Switch mode is null for {}", (Object)this);
            return null;
        }
        switch (this.mode) {
            case "auto": {
                return SwitchMode.AUTO;
            }
            case "manuell": {
                return SwitchMode.MANUAL;
            }
        }
        LOG.warn("Unknown value for switch mode: '{}' for {}", (Object)this.mode, (Object)this);
        return null;
    }

    public String toString() {
        return "SwitchState [state=" + this.state + ", mode=" + this.mode + ", lock=" + this.lock + "]";
    }

    public static enum SwitchMode {
        AUTO,
        MANUAL;

    }
}

