/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.log;

public class LogColorPrinter {
    public static final int WHITE = 30;
    public static final int WHITE_BACKGROUND = 40;
    public static final int RED = 31;
    public static final int RED_BACKGROUND = 41;
    public static final int GREEN = 32;
    public static final int GREEN_BACKGROUND = 42;
    public static final int YELLOW = 33;
    public static final int YELLOW_BACKGROUND = 43;
    public static final int BLUE = 34;
    public static final int BLUE_BACKGROUND = 44;
    public static final int MAGENTA = 35;
    public static final int MAGENTA_BACKGROUND = 45;
    public static final int CYAN = 36;
    public static final int CYAN_BACKGROUND = 46;
    public static final int BLACK = 37;
    public static final int BLACK_BACKGROUND = 47;
    public static final int BOLD = 1;
    public static final int ITATIC = 3;
    public static final int UNDERLINE = 4;
    public static final int REVERSE = 7;

    public static String getColorString(String txt, int ... codes) {
        return LogColorPrinter.colorFormat(txt, codes);
    }

    public static void print(String txt, int ... codes) {
        System.out.print(LogColorPrinter.colorFormat(txt, codes));
    }

    public static void println(String txt, int ... codes) {
        System.out.println(LogColorPrinter.colorFormat(txt, codes));
    }

    private static String colorFormat(String txt, int ... codes) {
        StringBuffer sb = new StringBuffer();
        for (int code : codes) {
            sb.append(code + ";");
        }
        String _code = sb.toString();
        if (_code.endsWith(";")) {
            _code = _code.substring(0, _code.length() - 1);
        }
        return "\u001b[" + _code + "m" + txt + '\u001b' + "[0m";
    }
}

