/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.log;

import com.github.kancyframework.springx.log.LogColorPrinter;
import com.github.kancyframework.springx.log.LogLevel;
import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

class LogFormatter {
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static String pid;
    private static DateTimeFormatter DATETIME_FORMATTER;
    private String logName;

    public LogFormatter(String logName) {
        this.logName = logName;
    }

    public String format(String msg, LogLevel logLevel) {
        StringBuffer log = new StringBuffer();
        log.append(LocalDateTime.now().format(DATETIME_FORMATTER));
        log.append(" ").append(LogColorPrinter.getColorString(this.toRight(logLevel.name(), 5), 32)).append(" ");
        log.append(LogColorPrinter.getColorString(LogFormatter.getPid(), 35));
        log.append(" --- ");
        log.append("[").append(this.getThreadName()).append("] ");
        log.append(LogColorPrinter.getColorString(String.format("%-40s", this.getSimpleLogName()), 36));
        log.append(" : ");
        log.append(msg);
        return log.toString();
    }

    private String getThreadName() {
        String tmp = Thread.currentThread().getName();
        if (tmp.length() > 10) {
            tmp = tmp.substring(tmp.length() - 10);
        }
        return String.format("%-10s", tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPid() {
        if (Objects.nonNull(pid)) {
            return pid;
        }
        Class<LogFormatter> clazz = LogFormatter.class;
        synchronized (LogFormatter.class) {
            if (LogFormatter.isWindows()) {
                String name = ManagementFactory.getRuntimeMXBean().getName();
                pid = name.split("@")[0];
            } else {
                pid = "12345";
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return pid;
        }
    }

    private static boolean isWindows() {
        return OS.indexOf("windows") >= 0;
    }

    private String getSimpleLogName() {
        int maxLen = 40;
        if (this.logName.length() <= maxLen) {
            return this.logName;
        }
        String[] stringArray = this.logName.split("[.]");
        StringBuffer sb = new StringBuffer();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String content = stringArray[i];
            if (sb.length() == 0 && content.length() >= maxLen) {
                return content.substring(0, maxLen);
            }
            if (sb.length() + content.length() < maxLen) {
                sb.insert(0, content);
                sb.insert(0, ".");
                continue;
            }
            sb.insert(0, content.substring(0, 1));
            sb.insert(0, ".");
        }
        if (sb.length() > maxLen) {
            return sb.substring(sb.length() - maxLen);
        }
        return sb.toString();
    }

    private String toRight(String str, int len) {
        if (str.length() >= len) {
            return str.substring(str.length() - len);
        }
        StringBuffer buffer = new StringBuffer(str);
        for (int i = 0; i < len; ++i) {
            buffer.insert(0, " ");
            if (buffer.length() == len) break;
        }
        return buffer.toString();
    }

    static {
        DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS");
    }
}

