/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.log;

import com.github.kancyframework.springx.log.LogFormatter;
import com.github.kancyframework.springx.log.LogLevel;
import com.github.kancyframework.springx.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;

class SimpleLogger
implements Logger {
    private static LogLevel logLevel = LogLevel.INFO;
    private LogFormatter logFormatter;

    SimpleLogger(String logName) {
        this.logFormatter = new LogFormatter(logName);
    }

    @Override
    public void debug(String msgFormat, Object ... args) {
        this.log(msgFormat, args, LogLevel.DEBUG);
    }

    @Override
    public void info(String msgFormat, Object ... args) {
        this.log(msgFormat, args, LogLevel.INFO);
    }

    @Override
    public void warn(String msgFormat, Object ... args) {
        this.log(msgFormat, args, LogLevel.WARN);
    }

    @Override
    public void error(String msgFormat, Object ... args) {
        this.log(msgFormat, args, LogLevel.ERROR);
    }

    @Override
    public void error(String msg, Exception e) {
        String msgFormat = String.format("%s : {}", msg);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        this.log(msgFormat, new Object[]{sw.toString()}, LogLevel.ERROR);
    }

    private void log(String msgFormat, Object[] args, LogLevel logLevel) {
        if (Objects.nonNull(msgFormat) && SimpleLogger.canLog(logLevel)) {
            msgFormat = msgFormat.replace("{}", "%s");
            String msg = String.format(msgFormat, args);
            if (Objects.equals((Object)LogLevel.ERROR, (Object)logLevel)) {
                System.err.println(this.logFormatter.format(msg, logLevel));
            } else {
                System.out.println(this.logFormatter.format(msg, logLevel));
            }
        }
    }

    private static boolean canLog(LogLevel logLevel) {
        if (Objects.nonNull((Object)SimpleLogger.logLevel)) {
            return logLevel.getLevel() >= SimpleLogger.logLevel.getLevel();
        }
        return false;
    }

    private static void loadLogLevel() {
        String propertyName = "log.level";
        String logLevelName = System.getProperty(propertyName, System.getenv(propertyName));
        if (Objects.isNull(logLevelName) || logLevelName.isEmpty()) {
            logLevelName = "INFO";
        }
        SimpleLogger.setLogLevel(LogLevel.valueOf(logLevelName.toUpperCase()));
    }

    public static void setLogLevel(LogLevel logLevel) {
        SimpleLogger.logLevel = logLevel;
    }

    public static LogLevel getLogLevel() {
        return logLevel;
    }

    static {
        SimpleLogger.loadLogLevel();
    }
}

