/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.timewatcher;

import com.alibaba.fastjson.annotation.JSONField;
import com.github.kancyframework.timewatcher.WatchContext;
import com.github.kancyframework.timewatcher.WatchRecord;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.MDC;

public class SimpleWatchContext
extends WatchContext {
    @JSONField(deserialize=false, serialize=false)
    private Deque<WatchRecord> watchRecordStack;
    private int reentry;
    private Long maxTotalCostMillis = -1L;
    private Long maxCostMillis = -1L;
    private Boolean noThrows;

    @Override
    protected void start(String contextName) {
        this.setContextName(contextName);
        this.init();
    }

    private void init() {
        this.setContextId(UUID.randomUUID().toString());
        this.setThreadId(Thread.currentThread().getId());
        this.setWatchRecordStack(new ArrayDeque<WatchRecord>());
        this.setWatchRecords(new LinkedList<WatchRecord>());
        this.initTraceId();
        this.initRootWatchRecord();
    }

    private void initTraceId() {
        WatchContext parentWatchContext = this.getParentContext();
        if (Objects.nonNull(parentWatchContext)) {
            this.setTraceId(parentWatchContext.getTraceId());
        } else {
            this.setTraceId(MDC.get((String)"traceId"));
        }
    }

    private void initRootWatchRecord() {
        WatchContext parentWatchContext = this.getParentContext();
        WatchRecord rootWatchRecord = new WatchRecord();
        rootWatchRecord.setProperties(new HashMap<String, Object>());
        rootWatchRecord.setParentWatchName("root");
        rootWatchRecord.setWatchName("root");
        rootWatchRecord.startRecord();
        if (Objects.nonNull(parentWatchContext)) {
            SimpleWatchContext simpleWatchContext;
            Deque<WatchRecord> stack;
            rootWatchRecord.setParentWatchName(parentWatchContext.getRootWatchRecord().getParentWatchName());
            rootWatchRecord.setWatchName(parentWatchContext.getRootWatchRecord().getWatchName());
            if (parentWatchContext instanceof SimpleWatchContext && !(stack = (simpleWatchContext = (SimpleWatchContext)parentWatchContext).getWatchRecordStack()).isEmpty()) {
                WatchRecord watchRecord = stack.peek();
                rootWatchRecord.setParentWatchName(watchRecord.getParentWatchName());
                rootWatchRecord.setWatchName(watchRecord.getWatchName());
            }
        }
        this.setRootWatchRecord(rootWatchRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stop() {
        if (!this.canStop()) {
            return;
        }
        this.setStopped(true);
        if (this.isEnabled()) {
            WatchRecord rootWatchRecord = this.getRootWatchRecord();
            rootWatchRecord.setStopTime(new Date());
            rootWatchRecord.setCostMillis(rootWatchRecord.getStopTime().getTime() - rootWatchRecord.getStartTime().getTime());
            WatchContext parentWatchContext = this.getParentContext();
            if (Objects.nonNull(parentWatchContext)) {
                List<WatchRecord> parentWatchRecords;
                List<WatchRecord> list = parentWatchRecords = parentWatchContext.getWatchRecords();
                synchronized (list) {
                    parentWatchRecords.addAll(this.getWatchRecords());
                }
            }
        }
    }

    private boolean canStop() {
        return !this.isStopped() && this.getReentry() <= 0;
    }

    @Override
    protected WatchContext copy() {
        SimpleWatchContext newWatchContext = new SimpleWatchContext();
        newWatchContext.setStopped(this.isStopped());
        newWatchContext.setEnabled(this.isEnabled());
        newWatchContext.setContextName(this.getContextName());
        newWatchContext.setParentContext(this.getParentContext());
        newWatchContext.setReentry(this.getReentry());
        newWatchContext.setContextId(this.getContextId());
        newWatchContext.setThreadId(this.getThreadId());
        newWatchContext.setWatchRecords(this.getWatchRecords());
        newWatchContext.setRootWatchRecord(this.getRootWatchRecord());
        newWatchContext.setWatchRecordStack(this.copyStack(this.getWatchRecordStack()));
        return newWatchContext;
    }

    private Deque<WatchRecord> copyStack(Deque<WatchRecord> stack) {
        ArrayDeque<WatchRecord> newWatchRecordStack = new ArrayDeque<WatchRecord>();
        Iterator<WatchRecord> iterator = stack.iterator();
        while (iterator.hasNext()) {
            newWatchRecordStack.push(iterator.next());
        }
        return newWatchRecordStack;
    }

    public Deque<WatchRecord> getWatchRecordStack() {
        return this.watchRecordStack;
    }

    public int getReentry() {
        return this.reentry;
    }

    public Long getMaxTotalCostMillis() {
        return this.maxTotalCostMillis;
    }

    public Long getMaxCostMillis() {
        return this.maxCostMillis;
    }

    public Boolean getNoThrows() {
        return this.noThrows;
    }

    public void setWatchRecordStack(Deque<WatchRecord> watchRecordStack) {
        this.watchRecordStack = watchRecordStack;
    }

    public void setReentry(int reentry) {
        this.reentry = reentry;
    }

    public void setMaxTotalCostMillis(Long maxTotalCostMillis) {
        this.maxTotalCostMillis = maxTotalCostMillis;
    }

    public void setMaxCostMillis(Long maxCostMillis) {
        this.maxCostMillis = maxCostMillis;
    }

    public void setNoThrows(Boolean noThrows) {
        this.noThrows = noThrows;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleWatchContext)) {
            return false;
        }
        SimpleWatchContext other = (SimpleWatchContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReentry() != other.getReentry()) {
            return false;
        }
        Long this$maxTotalCostMillis = this.getMaxTotalCostMillis();
        Long other$maxTotalCostMillis = other.getMaxTotalCostMillis();
        if (this$maxTotalCostMillis == null ? other$maxTotalCostMillis != null : !((Object)this$maxTotalCostMillis).equals(other$maxTotalCostMillis)) {
            return false;
        }
        Long this$maxCostMillis = this.getMaxCostMillis();
        Long other$maxCostMillis = other.getMaxCostMillis();
        if (this$maxCostMillis == null ? other$maxCostMillis != null : !((Object)this$maxCostMillis).equals(other$maxCostMillis)) {
            return false;
        }
        Boolean this$noThrows = this.getNoThrows();
        Boolean other$noThrows = other.getNoThrows();
        if (this$noThrows == null ? other$noThrows != null : !((Object)this$noThrows).equals(other$noThrows)) {
            return false;
        }
        Deque<WatchRecord> this$watchRecordStack = this.getWatchRecordStack();
        Deque<WatchRecord> other$watchRecordStack = other.getWatchRecordStack();
        return !(this$watchRecordStack == null ? other$watchRecordStack != null : !this$watchRecordStack.equals(other$watchRecordStack));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SimpleWatchContext;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReentry();
        Long $maxTotalCostMillis = this.getMaxTotalCostMillis();
        result = result * 59 + ($maxTotalCostMillis == null ? 43 : ((Object)$maxTotalCostMillis).hashCode());
        Long $maxCostMillis = this.getMaxCostMillis();
        result = result * 59 + ($maxCostMillis == null ? 43 : ((Object)$maxCostMillis).hashCode());
        Boolean $noThrows = this.getNoThrows();
        result = result * 59 + ($noThrows == null ? 43 : ((Object)$noThrows).hashCode());
        Deque<WatchRecord> $watchRecordStack = this.getWatchRecordStack();
        result = result * 59 + ($watchRecordStack == null ? 43 : $watchRecordStack.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SimpleWatchContext(watchRecordStack=" + this.getWatchRecordStack() + ", reentry=" + this.getReentry() + ", maxTotalCostMillis=" + this.getMaxTotalCostMillis() + ", maxCostMillis=" + this.getMaxCostMillis() + ", noThrows=" + this.getNoThrows() + ")";
    }
}

