/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.timewatcher;

import com.github.kancyframework.timewatcher.SimpleWatchContext;
import com.github.kancyframework.timewatcher.WatchContext;
import com.github.kancyframework.timewatcher.WatchRecord;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeWatcher {
    private static final Logger log = LoggerFactory.getLogger(TimeWatcher.class);
    public static final String PROPERTY_KEY_CLASS_NAME = "__className__";
    public static final String PROPERTY_KEY_METHOD_NAME = "__methodName__";
    public static final String PROPERTY_KEY_METHOD_ARGS = "__methodArgs__";
    public static final String PROPERTY_KEY_WATCH_SIZE = "__watchSize__";
    public static final String PROPERTY_KEY_URL = "__url__";
    public static final String PROPERTY_KEY_URL_QUERY = "__url_query__";
    private static final ThreadLocal<WatchContext> watchContextThreadLocal;

    private static void setEnabled(boolean enabled) {
        TimeWatcher.getWatchContext().setEnabled(enabled);
    }

    public static void enabled() {
        TimeWatcher.setEnabled(true);
    }

    public static void disEnabled() {
        TimeWatcher.setEnabled(false);
    }

    public static boolean isEnabled() {
        return TimeWatcher.getWatchContext().isEnabled();
    }

    private static SimpleWatchContext getSimpleWatchContext() {
        return (SimpleWatchContext)watchContextThreadLocal.get();
    }

    public static WatchContext getWatchContext() {
        return watchContextThreadLocal.get();
    }

    private static void setWatchContext(WatchContext watchContext) {
        watchContextThreadLocal.set(watchContext);
    }

    private static void clearWatchContext() {
        watchContextThreadLocal.remove();
    }

    public static void quickStart(String contextName) {
        TimeWatcher.enabled();
        TimeWatcher.doStart(contextName);
    }

    public static void start(String contextName) {
        TimeWatcher.doStart(contextName);
    }

    public static void startWatch(String contextName) {
        TimeWatcher.doStart(contextName);
    }

    private static void doStart(String contextName) {
        SimpleWatchContext watchContext = TimeWatcher.getSimpleWatchContext();
        if (Objects.isNull(watchContext.getContextId())) {
            try {
                watchContext.start(contextName);
            }
            catch (Exception e) {
                log.error("time watcher start fail:", (Throwable)e);
            }
            TimeWatcher.setCallClassNameAndMethodName();
        }
    }

    public static void stop() {
        TimeWatcher.stopWatch();
    }

    public static void stopWatch() {
        SimpleWatchContext watchContext = TimeWatcher.getSimpleWatchContext();
        if (Objects.nonNull(watchContext)) {
            try {
                watchContext.stop();
            }
            catch (Exception e) {
                if (watchContext.getNoThrows().booleanValue()) {
                    log.error("time watcher stop fail:", (Throwable)e);
                }
                throw e;
            }
        }
    }

    public static void close() {
        TimeWatcher.closeWatch();
    }

    public static void closeWatch() {
        SimpleWatchContext watchContext = TimeWatcher.getSimpleWatchContext();
        if (watchContext.getReentry() <= 0) {
            TimeWatcher.stopWatch();
            TimeWatcher.clearWatchContext();
        } else {
            watchContext.setReentry(watchContext.getReentry() - 1);
        }
    }

    public static WatchContext copyOfWatchContext() {
        return TimeWatcher.snapshotWatchContext();
    }

    public static WatchContext snapshotWatchContext() {
        SimpleWatchContext currentWatchContext = TimeWatcher.getSimpleWatchContext();
        if (currentWatchContext.isEnabled()) {
            return currentWatchContext.copy();
        }
        return currentWatchContext;
    }

    public static void transferWatchContext(WatchContext parentWatchContext) {
        if (Objects.isNull(parentWatchContext)) {
            return;
        }
        if (Objects.equals(parentWatchContext.getThreadId(), Thread.currentThread().getId())) {
            SimpleWatchContext watchContext = TimeWatcher.getSimpleWatchContext();
            watchContext.setReentry(watchContext.getReentry() + 1);
            TimeWatcher.setWatchContext(watchContext);
            return;
        }
        SimpleWatchContext watchContext = new SimpleWatchContext();
        if (parentWatchContext.isEnabled()) {
            watchContext.setEnabled(true);
            watchContext.setParentContext(parentWatchContext);
            watchContext.start(String.format("%s:%s", parentWatchContext.getContextName(), Thread.currentThread().getName()));
        }
        TimeWatcher.setWatchContext(watchContext);
    }

    public static <R> R watch(ProducerFunction<R> supplier) {
        return TimeWatcher.watch("", supplier, new HashMap<String, Object>());
    }

    public static <R> R watch(String watchName, ProducerFunction<R> supplier) {
        return TimeWatcher.watch(watchName, supplier, new HashMap<String, Object>());
    }

    public static <R> R watch(String watchName, Map<String, Object> properties, ProducerFunction<R> supplier) {
        return TimeWatcher.watch(watchName, supplier, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R watch(String watchName, ProducerFunction<R> supplier, Map<String, Object> properties) {
        SimpleWatchContext watchContext = TimeWatcher.getSimpleWatchContext();
        if (!watchContext.isEnabled()) {
            return supplier.get();
        }
        if (Objects.isNull(watchName) || watchName.isEmpty()) {
            watchName = supplier.getWatchMethodName();
        }
        R result = null;
        try {
            TimeWatcher.putIfAbsentClassAndMethodName(properties, supplier);
            TimeWatcher.preWatch(watchName, properties);
            result = supplier.get();
        }
        finally {
            TimeWatcher.postWatch(watchName, properties);
        }
        return result;
    }

    public static void watch(ConsumerFunction<WatchContext> consumer) {
        TimeWatcher.watch("", consumer, new HashMap<String, Object>());
    }

    public static void watch(String watchName, ConsumerFunction<WatchContext> consumer) {
        TimeWatcher.watch(watchName, consumer, new HashMap<String, Object>());
    }

    public static void watch(String watchName, Map<String, Object> properties, ConsumerFunction<WatchContext> consumer) {
        TimeWatcher.watch(watchName, consumer, properties);
    }

    public static void watch(String watchName, ConsumerFunction<WatchContext> consumer, Map<String, Object> properties) {
        watchName = Objects.isNull(watchName) || watchName.isEmpty() ? consumer.getWatchMethodName() : watchName;
        TimeWatcher.putIfAbsentClassAndMethodName(properties, consumer);
        TimeWatcher.watch(watchName, () -> {
            consumer.accept(TimeWatcher.getSimpleWatchContext());
            return 0;
        }, properties);
    }

    public static void watch(Function function) {
        TimeWatcher.watch("", function, new HashMap<String, Object>());
    }

    public static void watch(String watchName, Function function) {
        TimeWatcher.watch(watchName, function, new HashMap<String, Object>());
    }

    public static void watch(String watchName, Map<String, Object> properties, Function function) {
        TimeWatcher.watch(watchName, function, properties);
    }

    public static void watch(String watchName, Function function, Map<String, Object> properties) {
        watchName = Objects.isNull(watchName) || watchName.isEmpty() ? function.getWatchMethodName() : watchName;
        TimeWatcher.putIfAbsentClassAndMethodName(properties, function);
        TimeWatcher.watch(watchName, () -> {
            function.execute();
            return 0;
        }, properties);
    }

    private static void preWatch(String watchName, Map<String, Object> properties) {
        SimpleWatchContext watchContext = null;
        try {
            watchContext = TimeWatcher.getSimpleWatchContext();
            WatchRecord watchRecord = new WatchRecord();
            watchRecord.setWatchName(watchName);
            watchRecord.setProperties(properties);
            watchRecord.startRecord();
            Deque<WatchRecord> watchRecordStack = watchContext.getWatchRecordStack();
            List<WatchRecord> watchRecords = watchContext.getWatchRecords();
            watchRecords.add(watchRecord);
            watchRecordStack.push(watchRecord);
        }
        catch (Exception e) {
            if (Objects.nonNull(watchContext) && watchContext.getNoThrows().booleanValue()) {
                log.error("preWatch fail: watchName={} , properties={}\n{}", new Object[]{watchName, properties, e});
            }
            throw e;
        }
    }

    private static void postWatch(String watchName, Map<String, Object> properties) {
        SimpleWatchContext watchContext = null;
        try {
            watchContext = TimeWatcher.getSimpleWatchContext();
            Deque<WatchRecord> watchRecordStack = watchContext.getWatchRecordStack();
            WatchRecord currentWatchRecord = watchRecordStack.pop();
            currentWatchRecord.stopRecord();
            String parentWatchName = watchContext.getRootWatchRecord().getWatchName();
            currentWatchRecord.setParentWatchName(parentWatchName);
        }
        catch (Exception e) {
            if (Objects.nonNull(watchContext) && watchContext.getNoThrows().booleanValue()) {
                log.error("postWatch fail: watchName={} , properties={}\n{}", new Object[]{watchName, properties, e});
            }
            throw e;
        }
    }

    private static void putIfAbsentClassAndMethodName(Map<String, Object> properties, SerializableFunction function) {
        if (Objects.nonNull(properties) && TimeWatcher.isEnabled()) {
            if (!properties.containsKey(PROPERTY_KEY_CLASS_NAME)) {
                properties.put(PROPERTY_KEY_CLASS_NAME, function.getWatchClassName());
            }
            if (!properties.containsKey(PROPERTY_KEY_METHOD_NAME)) {
                properties.put(PROPERTY_KEY_METHOD_NAME, function.getWatchMethodName());
            }
        }
    }

    private static void setCallClassNameAndMethodName() {
        SimpleWatchContext watchContext = null;
        try {
            watchContext = TimeWatcher.getSimpleWatchContext();
            Map<String, Object> properties = watchContext.getRootWatchRecord().getProperties();
            if (properties.containsKey(PROPERTY_KEY_CLASS_NAME) && properties.containsKey(PROPERTY_KEY_METHOD_NAME)) {
                return;
            }
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int callIndex = 3;
            for (int i = 0; i < stackTrace.length; ++i) {
                StackTraceElement se = stackTrace[i];
                if (!Objects.equals(se.getClassName(), TimeWatcher.class.getName()) || !"quickStart,startWatch,start".contains(se.getMethodName())) continue;
                callIndex = i + 1;
                break;
            }
            StackTraceElement stackTraceElement = stackTrace[callIndex];
            properties.put(PROPERTY_KEY_CLASS_NAME, stackTraceElement.getClassName());
            properties.put(PROPERTY_KEY_METHOD_NAME, stackTraceElement.getMethodName());
        }
        catch (Exception e) {
            if (Objects.nonNull(watchContext) && watchContext.getNoThrows().booleanValue()) {
                log.warn("setCallClassNameAndMethodName fail : {}", (Object)e.getMessage());
            }
            throw e;
        }
    }

    private static <R> R preheatLoading(ProducerFunction<R> function) {
        return function.get();
    }

    public static void showGuiReport() {
        WatchContext watchContext = TimeWatcher.getWatchContext();
        watchContext.showReport();
    }

    public static void saveImageReport() {
        WatchContext watchContext = TimeWatcher.getWatchContext();
        watchContext.saveReport();
    }

    public static void saveImageReport(String filePath) {
        WatchContext watchContext = TimeWatcher.getWatchContext();
        watchContext.saveReport(filePath);
    }

    public static void saveImageReport(File file) {
        WatchContext watchContext = TimeWatcher.getWatchContext();
        watchContext.saveReport(file);
    }

    static {
        TimeWatcher.preheatLoading(UUID::randomUUID);
        watchContextThreadLocal = ThreadLocal.withInitial(SimpleWatchContext::new);
    }

    public static interface SerializableFunction
    extends Serializable {
        public static final Map<String, SerializedLambda> serializedLambdaCache = new WeakHashMap<String, SerializedLambda>();

        default public SerializedLambda getSerializedLambda() throws Exception {
            String className = this.getClass().getName();
            SerializedLambda serializedLambda = serializedLambdaCache.get(className);
            if (Objects.nonNull(serializedLambda)) {
                return serializedLambda;
            }
            Method writeReplaceMethod = this.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplaceMethod.setAccessible(true);
            Object serializedLambdaObject = writeReplaceMethod.invoke((Object)this, new Object[0]);
            if (serializedLambdaObject instanceof SerializedLambda) {
                SerializedLambda lambda = (SerializedLambda)SerializedLambda.class.cast(serializedLambdaObject);
                serializedLambdaCache.put(className, lambda);
                return lambda;
            }
            return null;
        }

        default public String getWatchClassName() {
            try {
                SerializedLambda serializedLambda = this.getSerializedLambda();
                if (Objects.nonNull(serializedLambda)) {
                    return serializedLambda.getImplClass().replace("/", ".");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        default public String getWatchMethodName() {
            try {
                SerializedLambda serializedLambda = this.getSerializedLambda();
                if (Objects.nonNull(serializedLambda)) {
                    String watchMethodName = serializedLambda.getImplMethodName();
                    if (Objects.nonNull(watchMethodName) && watchMethodName.startsWith("lambda$")) {
                        watchMethodName = watchMethodName.split("[$]")[1];
                    }
                    return watchMethodName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    @FunctionalInterface
    public static interface ProducerFunction<R>
    extends SerializableFunction {
        public R get();
    }

    @FunctionalInterface
    public static interface ConsumerFunction<T>
    extends SerializableFunction {
        public void accept(T var1);
    }

    @FunctionalInterface
    public static interface Function
    extends SerializableFunction {
        public void execute();
    }
}

