/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.timewatcher;

import com.github.kancyframework.timewatcher.WatchRecord;
import com.github.kancyframework.timewatcher.span.TimeSpanFrame;
import com.github.kancyframework.timewatcher.span.TimeSpanImage;
import java.awt.HeadlessException;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WatchContext {
    private static final Logger log = LoggerFactory.getLogger(WatchContext.class);
    private boolean enabled;
    private boolean stopped;
    private String contextId;
    private String bizId;
    private String contextName;
    private String traceId;
    private Long threadId;
    private WatchContext parentContext;
    private WatchRecord rootWatchRecord;
    private List<WatchRecord> watchRecords;

    public void putContextProperty(String key, Object value) {
        if (Objects.nonNull(this.rootWatchRecord)) {
            Map<String, Object> properties = this.rootWatchRecord.getProperties();
            properties.put(key, value);
        }
    }

    public void putContextProperty(Map<String, Object> properties) {
        if (Objects.nonNull(this.rootWatchRecord) && Objects.nonNull(properties)) {
            this.rootWatchRecord.getProperties().putAll(properties);
        }
    }

    public void showGuiReport() {
        this.showReport();
    }

    public void showReport() {
        if (this.isEnabled() && this.isStopped()) {
            try {
                TimeSpanFrame.show(this);
            }
            catch (HeadlessException headlessException) {
            }
            catch (Exception e) {
                log.warn("WatchContext show fail : {}", (Object)e.getMessage());
            }
        } else {
            log.info("WatchContext did not enabled or stop \uff0c please call stop()");
        }
    }

    public byte[] getReportBytes() {
        TimeSpanImage timeSpanImage = TimeSpanImage.create(this);
        return timeSpanImage.getImageBytes();
    }

    public void saveReport() {
        this.saveReport(String.format("%s.png", this.getContextId()));
    }

    public void saveReport(String filePath) {
        this.saveReport(new File(filePath));
    }

    public void saveReport(File file) {
        if (this.isEnabled() && this.isStopped()) {
            TimeSpanImage timeSpanImage = TimeSpanImage.create(this);
            timeSpanImage.save(file);
        } else {
            log.info("WatchContext did not enabled or stop \uff0c please call stop()");
        }
    }

    protected abstract void start(String var1);

    protected abstract void stop();

    protected abstract WatchContext copy();

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public String getContextId() {
        return this.contextId;
    }

    public String getBizId() {
        return this.bizId;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Long getThreadId() {
        return this.threadId;
    }

    public WatchContext getParentContext() {
        return this.parentContext;
    }

    public WatchRecord getRootWatchRecord() {
        return this.rootWatchRecord;
    }

    public List<WatchRecord> getWatchRecords() {
        return this.watchRecords;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setThreadId(Long threadId) {
        this.threadId = threadId;
    }

    public void setParentContext(WatchContext parentContext) {
        this.parentContext = parentContext;
    }

    public void setRootWatchRecord(WatchRecord rootWatchRecord) {
        this.rootWatchRecord = rootWatchRecord;
    }

    public void setWatchRecords(List<WatchRecord> watchRecords) {
        this.watchRecords = watchRecords;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WatchContext)) {
            return false;
        }
        WatchContext other = (WatchContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isStopped() != other.isStopped()) {
            return false;
        }
        Long this$threadId = this.getThreadId();
        Long other$threadId = other.getThreadId();
        if (this$threadId == null ? other$threadId != null : !((Object)this$threadId).equals(other$threadId)) {
            return false;
        }
        String this$contextId = this.getContextId();
        String other$contextId = other.getContextId();
        if (this$contextId == null ? other$contextId != null : !this$contextId.equals(other$contextId)) {
            return false;
        }
        String this$bizId = this.getBizId();
        String other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !this$bizId.equals(other$bizId)) {
            return false;
        }
        String this$contextName = this.getContextName();
        String other$contextName = other.getContextName();
        if (this$contextName == null ? other$contextName != null : !this$contextName.equals(other$contextName)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        WatchContext this$parentContext = this.getParentContext();
        WatchContext other$parentContext = other.getParentContext();
        if (this$parentContext == null ? other$parentContext != null : !((Object)this$parentContext).equals(other$parentContext)) {
            return false;
        }
        WatchRecord this$rootWatchRecord = this.getRootWatchRecord();
        WatchRecord other$rootWatchRecord = other.getRootWatchRecord();
        if (this$rootWatchRecord == null ? other$rootWatchRecord != null : !((Object)this$rootWatchRecord).equals(other$rootWatchRecord)) {
            return false;
        }
        List<WatchRecord> this$watchRecords = this.getWatchRecords();
        List<WatchRecord> other$watchRecords = other.getWatchRecords();
        return !(this$watchRecords == null ? other$watchRecords != null : !((Object)this$watchRecords).equals(other$watchRecords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WatchContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isStopped() ? 79 : 97);
        Long $threadId = this.getThreadId();
        result = result * 59 + ($threadId == null ? 43 : ((Object)$threadId).hashCode());
        String $contextId = this.getContextId();
        result = result * 59 + ($contextId == null ? 43 : $contextId.hashCode());
        String $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : $bizId.hashCode());
        String $contextName = this.getContextName();
        result = result * 59 + ($contextName == null ? 43 : $contextName.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        WatchContext $parentContext = this.getParentContext();
        result = result * 59 + ($parentContext == null ? 43 : ((Object)$parentContext).hashCode());
        WatchRecord $rootWatchRecord = this.getRootWatchRecord();
        result = result * 59 + ($rootWatchRecord == null ? 43 : ((Object)$rootWatchRecord).hashCode());
        List<WatchRecord> $watchRecords = this.getWatchRecords();
        result = result * 59 + ($watchRecords == null ? 43 : ((Object)$watchRecords).hashCode());
        return result;
    }

    public String toString() {
        return "WatchContext(enabled=" + this.isEnabled() + ", stopped=" + this.isStopped() + ", contextId=" + this.getContextId() + ", bizId=" + this.getBizId() + ", contextName=" + this.getContextName() + ", traceId=" + this.getTraceId() + ", threadId=" + this.getThreadId() + ", parentContext=" + this.getParentContext() + ", rootWatchRecord=" + this.getRootWatchRecord() + ", watchRecords=" + this.getWatchRecords() + ")";
    }
}

