/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.timewatcher;

import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class WatchRecord {
    private Integer watchIndex;
    private String parentWatchName;
    private String watchName;
    private String threadName;
    private Date startTime;
    private Date stopTime;
    private Long costMillis;
    private Map<String, Object> properties;

    public void startRecord() {
        if (Objects.isNull(this.startTime)) {
            this.startTime = new Date();
            this.threadName = Thread.currentThread().getName();
        }
    }

    public void stopRecord() {
        if (Objects.isNull(this.stopTime) && Objects.nonNull(this.startTime)) {
            this.stopTime = new Date();
            this.costMillis = this.stopTime.getTime() - this.startTime.getTime();
        }
    }

    public Integer getWatchIndex() {
        return this.watchIndex;
    }

    public String getParentWatchName() {
        return this.parentWatchName;
    }

    public String getWatchName() {
        return this.watchName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getStopTime() {
        return this.stopTime;
    }

    public Long getCostMillis() {
        return this.costMillis;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setWatchIndex(Integer watchIndex) {
        this.watchIndex = watchIndex;
    }

    public void setParentWatchName(String parentWatchName) {
        this.parentWatchName = parentWatchName;
    }

    public void setWatchName(String watchName) {
        this.watchName = watchName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    public void setCostMillis(Long costMillis) {
        this.costMillis = costMillis;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WatchRecord)) {
            return false;
        }
        WatchRecord other = (WatchRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$watchIndex = this.getWatchIndex();
        Integer other$watchIndex = other.getWatchIndex();
        if (this$watchIndex == null ? other$watchIndex != null : !((Object)this$watchIndex).equals(other$watchIndex)) {
            return false;
        }
        Long this$costMillis = this.getCostMillis();
        Long other$costMillis = other.getCostMillis();
        if (this$costMillis == null ? other$costMillis != null : !((Object)this$costMillis).equals(other$costMillis)) {
            return false;
        }
        String this$parentWatchName = this.getParentWatchName();
        String other$parentWatchName = other.getParentWatchName();
        if (this$parentWatchName == null ? other$parentWatchName != null : !this$parentWatchName.equals(other$parentWatchName)) {
            return false;
        }
        String this$watchName = this.getWatchName();
        String other$watchName = other.getWatchName();
        if (this$watchName == null ? other$watchName != null : !this$watchName.equals(other$watchName)) {
            return false;
        }
        String this$threadName = this.getThreadName();
        String other$threadName = other.getThreadName();
        if (this$threadName == null ? other$threadName != null : !this$threadName.equals(other$threadName)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$stopTime = this.getStopTime();
        Date other$stopTime = other.getStopTime();
        if (this$stopTime == null ? other$stopTime != null : !((Object)this$stopTime).equals(other$stopTime)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WatchRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $watchIndex = this.getWatchIndex();
        result = result * 59 + ($watchIndex == null ? 43 : ((Object)$watchIndex).hashCode());
        Long $costMillis = this.getCostMillis();
        result = result * 59 + ($costMillis == null ? 43 : ((Object)$costMillis).hashCode());
        String $parentWatchName = this.getParentWatchName();
        result = result * 59 + ($parentWatchName == null ? 43 : $parentWatchName.hashCode());
        String $watchName = this.getWatchName();
        result = result * 59 + ($watchName == null ? 43 : $watchName.hashCode());
        String $threadName = this.getThreadName();
        result = result * 59 + ($threadName == null ? 43 : $threadName.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $stopTime = this.getStopTime();
        result = result * 59 + ($stopTime == null ? 43 : ((Object)$stopTime).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "WatchRecord(watchIndex=" + this.getWatchIndex() + ", parentWatchName=" + this.getParentWatchName() + ", watchName=" + this.getWatchName() + ", threadName=" + this.getThreadName() + ", startTime=" + this.getStartTime() + ", stopTime=" + this.getStopTime() + ", costMillis=" + this.getCostMillis() + ", properties=" + this.getProperties() + ")";
    }
}

