/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.timewatcher.span;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.Objects;

public abstract class TimeSpan {
    private static Font font1 = new Font("\u9ed1\u4f53", 1, 12);
    private static Font font2 = new Font("\u5b8b\u4f53", 0, 12);
    private static Color skyBlueColor = Color.decode("#87CDFE");
    public static final int MAX_WITH = 1600;
    public static final int LINE_HEIGHT = 26;
    public static final int LINE_SPACING = 5;
    public static final int LINE_CENTER = 18;
    public static final int MARGIN = 60;
    public static final int MARGIN_TOP = 10;
    public static final int CHAR_WITH = 7;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected final int index;

    public TimeSpan(int index) {
        this.index = index;
    }

    public long getTotalTime() {
        return 0L;
    }

    public Color getSpanColor() {
        return skyBlueColor;
    }

    public String getIndexLabel() {
        if (this.index < 10) {
            return String.format("[0%d]", this.index);
        }
        return String.format("[%d]", this.index);
    }

    public AttributedString getIndexLabelAttributedString() {
        AttributedString as = new AttributedString(this.getIndexLabel());
        as.addAttribute(TextAttribute.FONT, font1);
        as.addAttribute(TextAttribute.FOREGROUND, Color.GRAY);
        return as;
    }

    public abstract String getSpanLabel();

    public AttributedString getSpanLabelAttributedString() {
        AttributedString as = new AttributedString(this.getSpanLabel());
        as.addAttribute(TextAttribute.FONT, font2);
        as.addAttribute(TextAttribute.FOREGROUND, Color.GRAY);
        return as;
    }

    public abstract String getRootSpanTimeLabel();

    public AttributedString getRootSpanTimeLabelAttributedString() {
        AttributedString as = new AttributedString(this.getRootSpanTimeLabel());
        as.addAttribute(TextAttribute.FONT, font2);
        as.addAttribute(TextAttribute.FOREGROUND, Color.GRAY);
        return as;
    }

    public boolean isFirst() {
        return Objects.equals(this.index, 0);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

